/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.building.NetherZone;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;

public class NetherZoneSaveData
extends SavedData {
    public final ArrayList<NetherZone> netherZones = new ArrayList();

    private static NetherZoneSaveData create() {
        return new NetherZoneSaveData();
    }

    @Nonnull
    public static NetherZoneSaveData getInstance(LevelAccessor level) {
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return NetherZoneSaveData.create();
        }
        return (NetherZoneSaveData)server.m_129783_().m_8895_().m_164861_(NetherZoneSaveData::load, NetherZoneSaveData::create, "saved-netherzone-data");
    }

    public static NetherZoneSaveData load(CompoundTag tag) {
        ReignOfNether.LOGGER.info("NetherZoneSaveData.load");
        NetherZoneSaveData data = NetherZoneSaveData.create();
        ListTag ltag = (ListTag)tag.m_128423_("netherzones");
        if (ltag != null) {
            for (Tag ctag : ltag) {
                CompoundTag ntag = (CompoundTag)ctag;
                int x = ntag.m_128451_("x");
                int y = ntag.m_128451_("y");
                int z = ntag.m_128451_("z");
                BlockPos origin = new BlockPos(x, y, z);
                double maxRange = ntag.m_128459_("maxRange");
                double range = ntag.m_128459_("range");
                boolean isRestoring = ntag.m_128471_("isRestoring");
                int ticksLeft = ntag.m_128451_("ticksLeft");
                int converts = ntag.m_128451_("converts");
                data.netherZones.add(NetherZone.getFromSave(origin, maxRange, range, isRestoring, ticksLeft, converts));
                ReignOfNether.LOGGER.info("NetherZoneSaveData.load: " + String.valueOf(origin) + "|" + range + "/" + maxRange + "|" + isRestoring);
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        this.netherZones.forEach(nz -> {
            CompoundTag cTag = new CompoundTag();
            cTag.m_128405_("x", nz.getOrigin().m_123341_());
            cTag.m_128405_("y", nz.getOrigin().m_123342_());
            cTag.m_128405_("z", nz.getOrigin().m_123343_());
            cTag.m_128347_("maxRange", nz.getMaxRange());
            cTag.m_128347_("range", nz.getRange());
            cTag.m_128379_("isRestoring", nz.isRestoring());
            cTag.m_128405_("ticksLeft", nz.getTicksLeft());
            cTag.m_128405_("converts", nz.getConvertsAfterConstantRange());
            list.add((Object)cTag);
            ReignOfNether.LOGGER.info("NetherZoneSaveData.save: " + String.valueOf(nz.getOrigin()) + "|" + (int)nz.getRange() + "/" + (int)nz.getMaxRange() + "|" + nz.isRestoring());
        });
        tag.m_128365_("netherzones", (Tag)list);
        return tag;
    }

    public void save() {
        this.m_77762_();
    }
}

