/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.placements;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.NetherConvertingBuilding;
import com.solegendary.reignofnether.building.NetherZone;
import com.solegendary.reignofnether.building.NightSource;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.custombuilding.CustomProductionBuilding;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;

public class CustomProductionPlacement
extends ProductionPlacement
implements NightSource,
NetherConvertingBuilding {
    private NetherZone netherZone;

    public CustomProductionPlacement(Building building, Level level, BlockPos originPos, Rotation rotation, String ownerName, ArrayList<BuildingBlock> blocks, boolean isCapitol) {
        super(building, level, originPos, rotation, ownerName, blocks, isCapitol);
    }

    private CustomProductionBuilding getCustom() {
        CustomProductionBuilding cpb;
        Building building = this.getBuilding();
        return building instanceof CustomProductionBuilding ? (cpb = (CustomProductionBuilding)building) : null;
    }

    @Override
    public int getNightRange() {
        CustomProductionBuilding cpb = this.getCustom();
        if (cpb == null || !this.isBuiltServerside) {
            return 0;
        }
        return cpb.isDarknessAuraEnabled() ? (int)Math.max(0L, Math.round(cpb.getDarknessAuraRadius())) : 0;
    }

    @Override
    public double getMaxRange() {
        CustomProductionBuilding cpb = this.getCustom();
        return cpb != null && cpb.isNetherConvertEnabled() ? cpb.getNetherMaxRange() : 0.0;
    }

    @Override
    public double getStartingRange() {
        CustomProductionBuilding cpb = this.getCustom();
        return cpb != null && cpb.isNetherConvertEnabled() ? cpb.getNetherStartRange() : 0.0;
    }

    @Override
    public NetherZone getZone() {
        return this.netherZone;
    }

    @Override
    public void setNetherZone(NetherZone nz) {
        if (this.netherZone == null) {
            this.netherZone = nz;
            if (!this.level.m_5776_() && nz != null) {
                BuildingServerEvents.netherZones.add(nz);
                BuildingServerEvents.saveNetherZones((ServerLevel)this.level);
            }
        }
    }

    @Override
    public void onBuilt() {
        super.onBuilt();
        if (this.level.m_5776_()) {
            return;
        }
        CustomProductionBuilding cpb = this.getCustom();
        if (cpb == null) {
            return;
        }
        if (cpb.isNetherConvertEnabled() && this.getMaxRange() > 0.0) {
            BlockPos zoneOrigin = this.centrePos.m_7918_(0, -2, 0);
            NetherZone nz = new NetherZone(zoneOrigin, cpb.getNetherMaxRange(), cpb.getNetherStartRange(), cpb.getNetherMappings(), cpb.getNetherPlantMappings());
            this.setNetherZone(nz);
        }
    }
}

