/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.placements;

import com.solegendary.reignofnether.ability.abilities.Sacrifice;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.NightSource;
import com.solegendary.reignofnether.building.RangeIndicator;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class SculkCatalystPlacement
extends BuildingPlacement
implements RangeIndicator,
NightSource {
    private static final Random random = new Random();
    private final Set<BlockPos> nightBorderBps = new HashSet<BlockPos>();
    private static final int SCULK_SEARCH_RANGE = 30;
    private static final float HP_PER_SCULK = 0.5f;
    private static final float RANGE_PER_SCULK = 0.25f;
    public final ArrayList<BlockPos> sculkBps = new ArrayList();
    private final boolean didSculkFix = false;
    private final BlockPos sculkFixBp = null;
    private static final int destroys = 0;

    public SculkCatalystPlacement(Building building, Level level, BlockPos originPos, Rotation rotation, String ownerName, ArrayList<BuildingBlock> blocks, boolean isCapitol) {
        super(building, level, originPos, rotation, ownerName, blocks, isCapitol);
        Sacrifice sacrifice = new Sacrifice(level);
        this.abilities.add(sacrifice);
    }

    public int getUncappedNightRange() {
        if (this.isBuilt || this.isBuiltServerside) {
            return (int)((float)this.sculkBps.size() * 0.25f) + 25;
        }
        return 0;
    }

    public int getRange() {
        if (this.isBuilt || this.isBuiltServerside) {
            return (int)Math.min(25.0f + (float)this.sculkBps.size() * 0.25f, 50.0f);
        }
        return 0;
    }

    @Override
    public int getNightRange() {
        return this.getRange();
    }

    @Override
    public void onBuilt() {
        super.onBuilt();
        this.updateBorderBps();
        this.updateSculkBps();
    }

    @Override
    public void updateBorderBps() {
        if (!this.level.m_5776_()) {
            return;
        }
        this.updateSculkBps();
        this.nightBorderBps.clear();
        this.nightBorderBps.addAll(MiscUtil.getRangeIndicatorCircleBlocks(this.centrePos, this.getNightRange() - 2, this.level));
    }

    @Override
    public Set<BlockPos> getBorderBps() {
        return this.nightBorderBps;
    }

    @Override
    public boolean showOnlyWhenSelected() {
        return false;
    }

    @Override
    public void tick(Level tickLevel) {
        super.tick(tickLevel);
        if (this.tickAgeAfterBuilt > 0L && this.tickAgeAfterBuilt % 100L == 0L) {
            if (tickLevel.m_5776_()) {
                this.updateBorderBps();
            } else {
                this.updateSculkBps();
            }
        }
    }

    @Override
    public int getHealth() {
        return (int)((float)this.getBlocksPlaced() / 0.5f) - this.getHighestBlockCountReached() + (int)((float)this.sculkBps.size() * 0.5f);
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocksFromNbt(structureName, level);
    }

    private void updateSculkBps() {
        this.sculkBps.clear();
        for (int x = this.centrePos.m_123341_() - 15; x < this.centrePos.m_123341_() + 15; ++x) {
            for (int z = this.centrePos.m_123343_() - 15; z < this.centrePos.m_123343_() + 15; ++z) {
                BlockPos bp;
                BlockState bs;
                BlockPos topBp = new BlockPos(x, this.maxCorner.m_123342_(), z);
                if (BuildingUtils.isPosInsideAnyBuilding(this.level.m_5776_(), topBp)) continue;
                int y = 0;
                while ((bs = this.level.m_8055_(bp = topBp.m_7918_(0, -(++y), 0))).m_60795_() && y < 10) {
                }
                if (!SculkCatalystPlacement.isSculk(bs.m_60734_())) continue;
                this.sculkBps.add(bp);
            }
        }
        Collections.shuffle(this.sculkBps);
    }

    public static boolean isSculk(Block block) {
        return block == Blocks.f_220855_ || block == Blocks.f_220856_ || block == Blocks.f_220857_ || block == Blocks.f_152500_ || block == Blocks.f_220858_ || block == Blocks.f_276595_;
    }

    @Override
    public void destroy(ServerLevel serverLevel) {
        super.destroy(serverLevel);
        if (this.isBuilt) {
            this.updateSculkBps();
            for (int i = 0; this.sculkBps.size() > 0 && i < 10; ++i) {
                this.restoreRandomSculk(100);
            }
        }
    }

    private int restoreRandomSculk(int amount) {
        if (this.getLevel().m_5776_()) {
            return 0;
        }
        int restoredSculk = 0;
        this.updateSculkBps();
        block0: for (int i = 0; i < amount; ++i) {
            if (i >= this.sculkBps.size()) {
                return restoredSculk;
            }
            BlockPos bp = this.sculkBps.get(i);
            BlockState bs = this.level.m_8055_(bp);
            if (bs.m_60734_() == Blocks.f_220855_) {
                for (BlockPos bpAdj : List.of(bp.m_7495_(), bp.m_122012_(), bp.m_122019_(), bp.m_122029_(), bp.m_122024_())) {
                    BlockState bsAdj = this.level.m_8055_(bpAdj);
                    if (bsAdj.m_60795_() || SculkCatalystPlacement.isSculk(bsAdj.m_60734_())) continue;
                    this.level.m_46597_(bp, bsAdj);
                    ++restoredSculk;
                    continue block0;
                }
                continue;
            }
            if (bs.m_60734_() != Blocks.f_220856_ && bs.m_60734_() != Blocks.f_152500_) continue;
            this.level.m_46961_(bp, false);
            ++restoredSculk;
        }
        return restoredSculk;
    }

    @Override
    public void destroyRandomBlocks(int amount) {
        if (this.getLevel().m_5776_() || amount <= 0) {
            return;
        }
        int restoredSculk = this.restoreRandomSculk((int)((float)amount / 0.5f));
        if (restoredSculk < amount) {
            super.destroyRandomBlocks(amount - restoredSculk);
        }
    }
}

