/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.villagers;

import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.buildings.shared.AbstractBridge;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialStage;
import com.solegendary.reignofnether.util.Faction;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.Blocks;

public class OakBridge
extends AbstractBridge {
    public static final String buildingName = "Oak Bridge";
    public static final String structureNameOrthogonal = "bridge_oak_orthogonal";
    public static final String structureNameDiagonal = "bridge_oak_diagonal";
    public static final ResourceCost cost = ResourceCosts.OAK_BRIDGE;

    public OakBridge() {
        super(cost);
        this.name = buildingName;
        this.portraitBlock = Blocks.f_50132_;
        this.icon = new ResourceLocation("reignofnether", "textures/icons/blocks/oak_fence.png");
        this.buildTimeModifier = 1.0f;
        this.startingBlockTypes.add(Blocks.f_49999_);
    }

    @Override
    public String getDiagonalStructureName() {
        return structureNameDiagonal;
    }

    @Override
    public String getOrthogonalStructureName() {
        return structureNameOrthogonal;
    }

    @Override
    public Faction getFaction() {
        return Faction.VILLAGERS;
    }

    @Override
    public AbilityButton getBuildButton(Keybinding hotkey) {
        ResourceLocation key = ReignOfNetherRegistries.BUILDING.m_7981_((Object)this);
        String name = I18n.m_118938_((String)("buildings." + this.getFaction().name().toLowerCase() + "." + key.m_135827_() + "." + key.m_135815_()), (Object[])new Object[0]);
        return new AbilityButton(name, new ResourceLocation("reignofnether", "textures/icons/blocks/oak_fence.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Buildings.OAK_BRIDGE, () -> !TutorialClientEvents.isAtOrPastStage(TutorialStage.BUILD_BRIDGE), () -> TutorialClientEvents.isAtOrPastStage(TutorialStage.BUILD_BRIDGE) && (BuildingClientEvents.hasFinishedBuilding(Buildings.TOWN_CENTRE) || BuildingClientEvents.hasFinishedBuilding(Buildings.MAUSOLEUM) || ResearchClient.hasCheat("modifythephasevariance")), () -> BuildingClientEvents.setBuildingToPlace(Buildings.OAK_BRIDGE), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.oak_bridge", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.oak_bridge.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.oak_bridge.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.oak_bridge.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.oak_bridge.tooltip4", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }
}

