/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.villagers;

import com.solegendary.reignofnether.ability.abilities.BackToWorkBuilding;
import com.solegendary.reignofnether.ability.abilities.CallToArmsBuilding;
import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.buildings.placements.RangeIndicatorProductionPlacement;
import com.solegendary.reignofnether.building.production.ProductionBuilding;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class TownCentre
extends ProductionBuilding {
    public static final String buildingName = "Town Centre";
    public static final String structureName = "town_centre";
    public static final ResourceCost cost = ResourceCosts.TOWN_CENTRE;
    public static final int MILITIA_RANGE = 60;
    private final Set<BlockPos> militiaBorderBps = new HashSet<BlockPos>();

    public TownCentre() {
        super(structureName, cost, true);
        this.name = buildingName;
        this.portraitBlock = Blocks.f_50175_;
        this.icon = new ResourceLocation("minecraft", "textures/block/polished_granite.png");
        this.buildTimeModifier = 0.331f;
        this.canAcceptResources = true;
        this.startingBlockTypes.add(Blocks.f_50194_);
        this.startingBlockTypes.add(Blocks.f_50440_);
        this.startingBlockTypes.add(Blocks.f_50641_);
        this.productions.add(ProductionItems.VILLAGER, Keybindings.keyQ);
    }

    @Override
    public Faction getFaction() {
        return Faction.VILLAGERS;
    }

    @Override
    public BuildingPlacement createBuildingPlacement(Level level, BlockPos pos, Rotation rotation, String ownerName) {
        RangeIndicatorProductionPlacement bp = new RangeIndicatorProductionPlacement(this, level, pos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(this.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, pos, rotation), true, 60, true, false);
        CallToArmsBuilding callToArms = new CallToArmsBuilding(level);
        bp.getAbilities().add(callToArms);
        BackToWorkBuilding backToWork = new BackToWorkBuilding(level);
        bp.getAbilities().add(backToWork);
        return bp;
    }

    @Override
    public AbilityButton getBuildButton(Keybinding hotkey) {
        ResourceLocation key = ReignOfNetherRegistries.BUILDING.m_7981_((Object)this);
        String name = I18n.m_118938_((String)("buildings." + this.getFaction().name().toLowerCase() + "." + key.m_135827_() + "." + key.m_135815_()), (Object[])new Object[0]);
        return new AbilityButton(name, new ResourceLocation("minecraft", "textures/block/polished_granite.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Buildings.TOWN_CENTRE, () -> false, () -> true, () -> BuildingClientEvents.setBuildingToPlace(Buildings.TOWN_CENTRE), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.town_centre", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedPop(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.town_centre.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }
}

