/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.custombuilding;

import com.solegendary.reignofnether.alliance.AlliancesClient;
import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingRegistry;
import com.solegendary.reignofnether.building.BuildingType;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.text.WordUtils;

public class CustomBuilding
extends Building {
    public BlockPos structurePos;
    public Vec3i structureSize;
    public List<ResourceLocation> requiredBuildings = new ArrayList<ResourceLocation>();
    public List<ResourceLocation> requiredResearch = new ArrayList<ResourceLocation>();

    public CustomBuilding(String structureName, BlockPos structurePos, Vec3i structureSize, Block portraitBlock) {
        super(structureName, ResourceCost.Building(0, 0, 0, 0), false);
        this.name = WordUtils.capitalize((String)structureName.replace("minecraft:", "").replace("reignofnether:", "").replace("_", " "));
        this.structurePos = structurePos;
        this.structureSize = structureSize;
        this.portraitBlock = portraitBlock;
        this.icon = new ResourceLocation("minecraft", "textures/block/command_block.png");
    }

    public CustomBuilding(String structureName, ResourceCost cost, boolean isCapitol, Block portraitBlock) {
        super(structureName, cost, isCapitol);
        this.name = WordUtils.capitalize((String)structureName.replace("minecraft:", "").replace("reignofnether:", "").replace("_", " "));
        this.portraitBlock = portraitBlock;
        this.icon = new ResourceLocation("minecraft", "textures/block/command_block.png");
    }

    @Override
    public Faction getFaction() {
        return Faction.NONE;
    }

    private boolean requirementsMet() {
        int max;
        if (ResearchClient.hasCheat("modifythephasevariance")) {
            return true;
        }
        String me = Minecraft.m_91087_().f_91074_ != null ? Minecraft.m_91087_().f_91074_.m_7755_().getString() : "";
        HashSet<String> owners = new HashSet<String>();
        owners.add(me);
        owners.addAll(AlliancesClient.getAllConnectedAllies(me));
        for (ResourceLocation bid : this.requiredBuildings) {
            Building req = (Building)ReignOfNetherRegistries.BUILDING.m_7745_(bid);
            if (req == null) {
                return false;
            }
            boolean ok = false;
            for (BuildingPlacement bpl : BuildingClientEvents.getBuildings()) {
                if (!bpl.isBuilt || !bpl.getBuilding().isTypeOf(req) || !owners.contains(bpl.ownerName)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            return false;
        }
        BuildingType<CustomBuilding> bt = BuildingRegistry.getBuildingType(this);
        int n = max = bt != null ? bt.getProperties().getMaxPerPlayer() : 0;
        if (max > 0) {
            String owner = Minecraft.m_91087_().f_91074_ != null ? Minecraft.m_91087_().f_91074_.m_7755_().getString() : "";
            int count = 0;
            for (BuildingPlacement bpl : BuildingClientEvents.getBuildings()) {
                if (!bpl.getBuilding().isTypeOf(this) || !owner.equals(bpl.ownerName)) continue;
                ++count;
            }
            if (count >= max) {
                return false;
            }
        }
        return true;
    }

    @Override
    public AbilityButton getBuildButton(Keybinding hotkey) {
        boolean enabled;
        String translatedName;
        ResourceLocation key = ReignOfNetherRegistries.BUILDING.m_7981_((Object)this);
        if (key != null) {
            String langKey = "buildings." + key.m_135827_() + "." + key.m_135815_();
            String fallback = this.name != null ? this.name : WordUtils.capitalize((String)key.m_135815_().replace("_", " "));
            translatedName = I18n.m_118936_((String)langKey) ? I18n.m_118938_((String)langKey, (Object[])new Object[0]) : fallback;
        } else {
            translatedName = this.name != null ? this.name : "Custom Building";
        }
        ResourceLocation iconRl = this.icon != null ? this.icon : new ResourceLocation("minecraft", "textures/block/command_block.png");
        ArrayList<FormattedCharSequence> tips = new ArrayList<FormattedCharSequence>();
        tips.add(FormattedCharSequence.m_13714_((String)translatedName, (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))));
        if (this.cost != null) {
            tips.add(ResourceCosts.getFormattedCost(this.cost));
        }
        if (!(enabled = this.requirementsMet())) {
            int max2;
            for (ResourceLocation bid : this.requiredBuildings) {
                Building bReq = (Building)ReignOfNetherRegistries.BUILDING.m_7745_(bid);
                if (bReq == null || BuildingClientEvents.hasFinishedBuilding(bReq)) continue;
                String keyName = "buildings." + bid.m_135827_() + "." + bid.m_135815_();
                String disp = I18n.m_118936_((String)keyName) ? I18n.m_118938_((String)keyName, (Object[])new Object[0]) : bid.toString();
                tips.add(FormattedCharSequence.m_13714_((String)("- " + I18n.m_118938_((String)"hud.reignofnether.requires_building", (Object[])new Object[]{disp})), (Style)Style.f_131099_));
            }
            for (ResourceLocation rid : this.requiredResearch) {
                if (ResearchClient.hasResearch(rid)) continue;
                String keyName = "research." + rid.m_135827_() + "." + rid.m_135815_();
                String disp = I18n.m_118936_((String)keyName) ? I18n.m_118938_((String)keyName, (Object[])new Object[0]) : rid.toString();
                tips.add(FormattedCharSequence.m_13714_((String)("- " + I18n.m_118938_((String)"hud.reignofnether.requires_research", (Object[])new Object[]{disp})), (Style)Style.f_131099_));
            }
            BuildingType<CustomBuilding> bt2 = BuildingRegistry.getBuildingType(this);
            int n = max2 = bt2 != null ? bt2.getProperties().getMaxPerPlayer() : 0;
            if (max2 > 0) {
                String owner = Minecraft.m_91087_().f_91074_ != null ? Minecraft.m_91087_().f_91074_.m_7755_().getString() : "";
                int count = 0;
                for (BuildingPlacement bpl : BuildingClientEvents.getBuildings()) {
                    if (!bpl.getBuilding().isTypeOf(this) || !owner.equals(bpl.ownerName)) continue;
                    ++count;
                }
                if (count >= max2) {
                    tips.add(FormattedCharSequence.m_13714_((String)("- " + I18n.m_118938_((String)"hud.reignofnether.max_per_player_reached", (Object[])new Object[]{max2})), (Style)Style.f_131099_));
                }
            }
        }
        return new AbilityButton(translatedName, iconRl, hotkey, () -> BuildingClientEvents.getBuildingToPlace() == this, () -> false, () -> enabled, () -> BuildingClientEvents.setBuildingToPlace(this), null, tips, null);
    }
}

