/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.custombuilding;

import com.solegendary.reignofnether.building.custombuilding.CustomBuildingClientEvents;
import com.solegendary.reignofnether.registrars.PacketHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class CustomBuildingClientboundPacket {
    public String name;
    public BlockPos originPos;
    public BlockPos structurePos;
    public BlockPos structureSize;

    public static void registerCustomBuilding(String name, BlockPos originPos, BlockPos structurePos, Vec3i structureSize) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new CustomBuildingClientboundPacket(name, originPos, structurePos, new BlockPos(structureSize)));
    }

    public CustomBuildingClientboundPacket(String name, BlockPos originPos, BlockPos structurePos, BlockPos structureSize) {
        this.name = name;
        this.originPos = originPos;
        this.structurePos = structurePos;
        this.structureSize = structureSize;
    }

    public CustomBuildingClientboundPacket(FriendlyByteBuf buffer) {
        this.name = buffer.m_130277_();
        this.originPos = buffer.m_130135_();
        this.structurePos = buffer.m_130135_();
        this.structureSize = buffer.m_130135_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.name);
        buffer.m_130064_(this.originPos);
        buffer.m_130064_(this.structurePos);
        buffer.m_130064_(this.structureSize);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            CustomBuildingClientEvents.registerCustomBuilding(this.name, this.originPos, this.structurePos, (Vec3i)this.structureSize);
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

