/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.custombuilding;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.blocks.RTSStructureBlockEntity;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.custombuilding.CustomBuilding;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingClientboundPacket;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class CustomBuildingServerEvents {
    private static final ArrayList<CustomBuilding> customBuildings = new ArrayList();

    public static Building getCustomBuilding(String structureName) {
        for (CustomBuilding building : customBuildings) {
            if (!building.structureName.equals(structureName)) continue;
            return building;
        }
        return null;
    }

    public static boolean createNewCustomBuilding(ResourceLocation structureRL, String structureName, ServerLevel level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof RTSStructureBlockEntity) {
            RTSStructureBlockEntity rtsBe = (RTSStructureBlockEntity)be;
            return CustomBuildingServerEvents.createNewCustomBuilding(structureRL, structureName, level, pos, rtsBe.m_59902_(), rtsBe.m_155805_(), true);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean createNewCustomBuilding(ResourceLocation structureRL, String structureName, ServerLevel level, BlockPos pos, BlockPos structurePos, Vec3i structureSize, boolean save) {
        StructureTemplateManager manager = level.m_215082_();
        Optional template = manager.m_230407_(structureRL);
        CompoundTag structureNbt = null;
        if (template.isPresent()) {
            structureNbt = ((StructureTemplate)template.get()).m_74618_(new CompoundTag());
        }
        if (structureNbt == null) return false;
        boolean buildingExists = false;
        for (BuildingPlacement existingPlacement : BuildingServerEvents.getBuildings()) {
            if (!existingPlacement.originPos.equals((Object)pos)) continue;
            buildingExists = true;
            break;
        }
        if (buildingExists) {
            ReignOfNether.LOGGER.error("ERROR (server): cannot register custom building at same origin as another building");
            return false;
        }
        ArrayList<BuildingBlock> blocks = BuildingUtils.getAbsoluteBlockData(BuildingBlockData.getBuildingBlocksFromNbt(structureNbt), (LevelAccessor)level, pos, Rotation.NONE, new Vec3i(1, 0, 1));
        int numSolidBlocks = 0;
        Block portraitBlock = Blocks.f_50272_;
        for (BuildingBlock bb : blocks) {
            BlockState bs = bb.getBlockState();
            if (bs.m_60795_() || !bs.m_60819_().m_76178_()) continue;
            ++numSolidBlocks;
            portraitBlock = bs.m_60734_();
        }
        if (numSolidBlocks == 0) {
            ReignOfNether.LOGGER.error("ERROR (server): cannot register custom building with no solid blocks");
            return false;
        }
        CustomBuilding building = new CustomBuilding(structureName, structurePos, structureSize, portraitBlock);
        customBuildings.add(building);
        BuildingPlacement placement = new BuildingPlacement(building, (Level)level, pos, Rotation.NONE, "", blocks, false);
        BuildingServerEvents.getBuildings().add(placement);
        CustomBuildingClientboundPacket.registerCustomBuilding(structureName, pos, structurePos, structureSize);
        return true;
    }
}

