/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.custombuilding;

import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingRegistry;
import com.solegendary.reignofnether.building.BuildingType;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.NetherZone;
import com.solegendary.reignofnether.building.buildings.placements.CustomProductionPlacement;
import com.solegendary.reignofnether.building.production.ProductionBuilding;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import org.apache.commons.lang3.text.WordUtils;

public class CustomProductionBuilding
extends ProductionBuilding {
    public BlockPos structurePos;
    public Vec3i structureSize;
    public final List<ResourceLocation> requiredBuildings = new ArrayList<ResourceLocation>();
    public final List<ResourceLocation> requiredResearch = new ArrayList<ResourceLocation>();
    private boolean netherConvertEnabled = false;
    private double netherMaxRange = 0.0;
    private double netherStartRange = 0.0;
    private NetherZone netherZone;
    private Map<Block, List<Block>> netherMappings = null;
    private Map<Block, List<Block>> netherPlantMappings = null;
    private boolean darknessAuraEnabled = false;
    private double darknessAuraRadius = 0.0;

    public CustomProductionBuilding(String structureName, ResourceCost cost, boolean isCapitol, Block portraitBlock) {
        super(structureName, cost, isCapitol);
        this.name = WordUtils.capitalize((String)structureName.replace("minecraft:", "").replace("reignofnether:", "").replace("_", " "));
        this.portraitBlock = portraitBlock;
        this.icon = new ResourceLocation("minecraft", "textures/block/command_block.png");
    }

    @Override
    public Faction getFaction() {
        return Faction.NONE;
    }

    public void setNetherConvert(boolean enabled, double maxRange, double startRange) {
        this.netherConvertEnabled = enabled;
        this.netherMaxRange = enabled ? maxRange : 0.0;
        this.netherStartRange = enabled ? startRange : 0.0;
    }

    public boolean isNetherConvertEnabled() {
        return this.netherConvertEnabled && this.netherMaxRange > 0.0;
    }

    public double getNetherMaxRange() {
        return this.netherMaxRange;
    }

    public double getNetherStartRange() {
        return this.netherStartRange;
    }

    public void setDarknessAura(boolean enabled, double radius) {
        this.darknessAuraEnabled = enabled;
        this.darknessAuraRadius = enabled ? radius : 0.0;
    }

    public boolean isDarknessAuraEnabled() {
        return this.darknessAuraEnabled && this.darknessAuraRadius > 0.0;
    }

    public double getDarknessAuraRadius() {
        return this.darknessAuraRadius;
    }

    public void setNetherMappings(Map<Block, List<Block>> mappings, Map<Block, List<Block>> plantMappings) {
        this.netherMappings = mappings;
        this.netherPlantMappings = plantMappings;
    }

    public Map<Block, List<Block>> getNetherMappings() {
        return this.netherMappings;
    }

    public Map<Block, List<Block>> getNetherPlantMappings() {
        return this.netherPlantMappings;
    }

    @Override
    public BuildingPlacement createBuildingPlacement(Level level, BlockPos pos, Rotation rotation, String ownerName) {
        ArrayList<BuildingBlock> relativeBlocks = this.getRelativeBlockData((LevelAccessor)level);
        ArrayList<BuildingBlock> abs = BuildingUtils.getAbsoluteBlockData(relativeBlocks, (LevelAccessor)level, pos, rotation);
        return new CustomProductionPlacement(this, level, pos, rotation, ownerName, abs, this.isCapitol);
    }

    private boolean requirementsMet() {
        int max;
        if (ResearchClient.hasCheat("modifythephasevariance")) {
            return true;
        }
        for (ResourceLocation bid : this.requiredBuildings) {
            Building b = (Building)ReignOfNetherRegistries.BUILDING.m_7745_(bid);
            if (b == null) {
                return false;
            }
            if (BuildingClientEvents.hasFinishedBuilding(b)) continue;
            return false;
        }
        for (ResourceLocation rid : this.requiredResearch) {
            if (ResearchClient.hasResearch(rid)) continue;
            return false;
        }
        BuildingType<CustomProductionBuilding> bt = BuildingRegistry.getBuildingType(this);
        int n = max = bt != null ? bt.getProperties().getMaxPerPlayer() : 0;
        if (max > 0) {
            String owner = Minecraft.m_91087_().f_91074_ != null ? Minecraft.m_91087_().f_91074_.m_7755_().getString() : "";
            int count = 0;
            for (BuildingPlacement bpl : BuildingClientEvents.getBuildings()) {
                if (!bpl.getBuilding().isTypeOf(this) || !owner.equals(bpl.ownerName)) continue;
                ++count;
            }
            if (count >= max) {
                return false;
            }
        }
        return true;
    }

    @Override
    public AbilityButton getBuildButton(Keybinding hotkey) {
        String translatedName;
        ResourceLocation key = ReignOfNetherRegistries.BUILDING.m_7981_((Object)this);
        if (key != null) {
            String langKey = "buildings." + key.m_135827_() + "." + key.m_135815_();
            String fallback = this.name != null ? this.name : WordUtils.capitalize((String)key.m_135815_().replace("_", " "));
            translatedName = I18n.m_118936_((String)langKey) ? I18n.m_118938_((String)langKey, (Object[])new Object[0]) : fallback;
        } else {
            translatedName = this.name != null ? this.name : "Custom Building";
        }
        ResourceLocation iconRl = this.icon != null ? this.icon : new ResourceLocation("minecraft", "textures/block/command_block.png");
        boolean enabled = this.requirementsMet();
        ArrayList<FormattedCharSequence> tips = new ArrayList<FormattedCharSequence>();
        tips.add(FormattedCharSequence.m_13714_((String)translatedName, (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))));
        if (this.cost != null) {
            tips.add(ResourceCosts.getFormattedCost(this.cost));
        }
        return new AbilityButton(translatedName, iconRl, hotkey, () -> BuildingClientEvents.getBuildingToPlace() == this, () -> false, () -> enabled, () -> BuildingClientEvents.setBuildingToPlace(this), null, tips, null);
    }
}

