/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.production;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ProductionItemList;
import com.solegendary.reignofnether.resources.ResourceCost;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;

public abstract class ProductionBuilding
extends Building {
    public ProductionItemList productions = new ProductionItemList();
    public boolean canSetRallyPoint = true;
    public float spawnRadiusOffset = 1.0f;

    public ProductionBuilding(String structureName, ResourceCost cost, boolean isCapitol) {
        super(structureName, cost, isCapitol);
    }

    @Override
    public BuildingPlacement createBuildingPlacement(Level level, BlockPos pos, Rotation rotation, String ownerName) {
        return new ProductionPlacement(this, level, pos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(this.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, pos, rotation), this.isCapitol);
    }

    public BlockPos getDefaultOutdoorSpawnPoint(BlockPos minCorner) {
        return minCorner.m_7918_((int)(-this.spawnRadiusOffset), 0, (int)(-this.spawnRadiusOffset));
    }

    public BlockPos getIndoorSpawnPoint(ServerLevel level, BlockPos centrePos) {
        BlockPos spawnPoint = centrePos;
        while (level.m_8055_(spawnPoint.m_7495_()).m_60795_()) {
            spawnPoint = spawnPoint.m_7918_(0, -1, 0);
        }
        return spawnPoint;
    }
}

