/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.production.dynamic;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.building.BuildingServerboundPacket;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ProductionItem;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.UnitRegistry;
import com.solegendary.reignofnether.unit.UnitType;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.EntityType;

public class DatapackUnitProductionItem
extends ProductionItem {
    private final ResourceLocation unitId;
    private final String displayName;
    private final ResourceLocation icon;

    public DatapackUnitProductionItem(ResourceLocation unitId, String displayName, ResourceCost cost, ResourceLocation icon) {
        super(cost);
        this.unitId = unitId;
        this.displayName = displayName;
        this.icon = icon;
        this.onComplete = (lvl, placement) -> {
            if (!(lvl instanceof ServerLevel) || !(placement instanceof ProductionPlacement)) {
                return;
            }
            ServerLevel server = (ServerLevel)lvl;
            ProductionPlacement prod = placement;
            UnitType<ResourceLocation> ut = UnitRegistry.getUnitType(unitId);
            if (ut == null) {
                return;
            }
            EntityType<ResourceLocation> raw = ut.getEntityType();
            try {
                prod.produceUnit(server, raw, prod.ownerName, false);
            }
            catch (Throwable t) {
                ReignOfNether.LOGGER.error("Failed to spawn unit {} from production: {}", (Object)unitId, (Object)t.toString());
            }
        };
    }

    @Override
    public Button getStartButton(ProductionPlacement prodBuilding, Keybinding keybinding) {
        String name = this.displayName != null && !this.displayName.isBlank() ? this.displayName : this.unitId.m_135815_();
        return new Button(name, Button.itemIconSize, this.icon, keybinding, () -> false, () -> false, () -> true, () -> BuildingServerboundPacket.startProduction(prodBuilding.originPos, this), null, List.of(FormattedCharSequence.m_13714_((String)name, (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(this.getCost(true, prodBuilding.ownerName)), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.reignofnether.production_time", (Object[])new Object[]{this.getCost((boolean)true, (String)prodBuilding.ownerName).ticks / 20}), (Style)Style.f_131099_)));
    }
}

