/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.production.dynamic;

public class DynamicProductionProperties {
    private final int productionTime;
    private final int queueLimit;
    private final boolean batchProduction;
    private final int batchSize;
    private final float resourceEfficiency;
    private final boolean requiresContinuousResources;
    private final boolean refundsOnCancel;
    private final float refundPercentage;
    private final boolean requiresWorkers;
    private final int workerCount;
    private final float workerEfficiencyBonus;
    private final boolean requiresSpecificBuilding;
    private final boolean canBeUpgraded;
    private final float upgradeEfficiencyBonus;
    private final float factionEfficiencyBonus;
    private final boolean requiresFactionTech;
    private final boolean shareableBetweenFactions;
    private final int priority;
    private final boolean pausableProduction;
    private final boolean visibleToEnemies;
    private final boolean countsTowardPopulation;

    private DynamicProductionProperties(Builder builder) {
        this.productionTime = builder.productionTime;
        this.queueLimit = builder.queueLimit;
        this.batchProduction = builder.batchProduction;
        this.batchSize = builder.batchSize;
        this.resourceEfficiency = builder.resourceEfficiency;
        this.requiresContinuousResources = builder.requiresContinuousResources;
        this.refundsOnCancel = builder.refundsOnCancel;
        this.refundPercentage = builder.refundPercentage;
        this.requiresWorkers = builder.requiresWorkers;
        this.workerCount = builder.workerCount;
        this.workerEfficiencyBonus = builder.workerEfficiencyBonus;
        this.requiresSpecificBuilding = builder.requiresSpecificBuilding;
        this.canBeUpgraded = builder.canBeUpgraded;
        this.upgradeEfficiencyBonus = builder.upgradeEfficiencyBonus;
        this.factionEfficiencyBonus = builder.factionEfficiencyBonus;
        this.requiresFactionTech = builder.requiresFactionTech;
        this.shareableBetweenFactions = builder.shareableBetweenFactions;
        this.priority = builder.priority;
        this.pausableProduction = builder.pausableProduction;
        this.visibleToEnemies = builder.visibleToEnemies;
        this.countsTowardPopulation = builder.countsTowardPopulation;
    }

    public static DynamicProductionProperties defaultProperties() {
        return new Builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getProductionTime() {
        return this.productionTime;
    }

    public int getQueueLimit() {
        return this.queueLimit;
    }

    public boolean isBatchProduction() {
        return this.batchProduction;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public float getResourceEfficiency() {
        return this.resourceEfficiency;
    }

    public boolean requiresContinuousResources() {
        return this.requiresContinuousResources;
    }

    public boolean refundsOnCancel() {
        return this.refundsOnCancel;
    }

    public float getRefundPercentage() {
        return this.refundPercentage;
    }

    public boolean requiresWorkers() {
        return this.requiresWorkers;
    }

    public int getWorkerCount() {
        return this.workerCount;
    }

    public float getWorkerEfficiencyBonus() {
        return this.workerEfficiencyBonus;
    }

    public boolean requiresSpecificBuilding() {
        return this.requiresSpecificBuilding;
    }

    public boolean canBeUpgraded() {
        return this.canBeUpgraded;
    }

    public float getUpgradeEfficiencyBonus() {
        return this.upgradeEfficiencyBonus;
    }

    public float getFactionEfficiencyBonus() {
        return this.factionEfficiencyBonus;
    }

    public boolean requiresFactionTech() {
        return this.requiresFactionTech;
    }

    public boolean isShareableBetweenFactions() {
        return this.shareableBetweenFactions;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isPausableProduction() {
        return this.pausableProduction;
    }

    public boolean isVisibleToEnemies() {
        return this.visibleToEnemies;
    }

    public boolean countsTowardPopulation() {
        return this.countsTowardPopulation;
    }

    public static class Builder {
        private int productionTime = 600;
        private int queueLimit = 5;
        private boolean batchProduction = false;
        private int batchSize = 1;
        private float resourceEfficiency = 1.0f;
        private boolean requiresContinuousResources = false;
        private boolean refundsOnCancel = true;
        private float refundPercentage = 0.8f;
        private boolean requiresWorkers = false;
        private int workerCount = 1;
        private float workerEfficiencyBonus = 1.2f;
        private boolean requiresSpecificBuilding = true;
        private boolean canBeUpgraded = true;
        private float upgradeEfficiencyBonus = 1.5f;
        private float factionEfficiencyBonus = 1.0f;
        private boolean requiresFactionTech = false;
        private boolean shareableBetweenFactions = false;
        private int priority = 50;
        private boolean pausableProduction = true;
        private boolean visibleToEnemies = true;
        private boolean countsTowardPopulation = false;

        public Builder productionTime(int time) {
            this.productionTime = time;
            return this;
        }

        public Builder queueLimit(int limit) {
            this.queueLimit = limit;
            return this;
        }

        public Builder batchProduction(boolean batch) {
            this.batchProduction = batch;
            return this;
        }

        public Builder batchSize(int size) {
            this.batchSize = size;
            return this;
        }

        public Builder resourceEfficiency(float efficiency) {
            this.resourceEfficiency = efficiency;
            return this;
        }

        public Builder requiresContinuousResources(boolean requires) {
            this.requiresContinuousResources = requires;
            return this;
        }

        public Builder refundsOnCancel(boolean refunds) {
            this.refundsOnCancel = refunds;
            return this;
        }

        public Builder refundPercentage(float percentage) {
            this.refundPercentage = percentage;
            return this;
        }

        public Builder requiresWorkers(boolean requires) {
            this.requiresWorkers = requires;
            return this;
        }

        public Builder workerCount(int count) {
            this.workerCount = count;
            return this;
        }

        public Builder workerEfficiencyBonus(float bonus) {
            this.workerEfficiencyBonus = bonus;
            return this;
        }

        public Builder requiresSpecificBuilding(boolean requires) {
            this.requiresSpecificBuilding = requires;
            return this;
        }

        public Builder canBeUpgraded(boolean upgradeable) {
            this.canBeUpgraded = upgradeable;
            return this;
        }

        public Builder upgradeEfficiencyBonus(float bonus) {
            this.upgradeEfficiencyBonus = bonus;
            return this;
        }

        public Builder factionEfficiencyBonus(float bonus) {
            this.factionEfficiencyBonus = bonus;
            return this;
        }

        public Builder requiresFactionTech(boolean requires) {
            this.requiresFactionTech = requires;
            return this;
        }

        public Builder shareableBetweenFactions(boolean shareable) {
            this.shareableBetweenFactions = shareable;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder pausableProduction(boolean pausable) {
            this.pausableProduction = pausable;
            return this;
        }

        public Builder visibleToEnemies(boolean visible) {
            this.visibleToEnemies = visible;
            return this;
        }

        public Builder countsTowardPopulation(boolean counts) {
            this.countsTowardPopulation = counts;
            return this;
        }

        public Builder renewable(boolean renewable) {
            return this;
        }

        public DynamicProductionProperties build() {
            return new DynamicProductionProperties(this);
        }
    }
}

