/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.production.dynamic;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.building.production.dynamic.DynamicProductionItem;
import com.solegendary.reignofnether.building.production.dynamic.ProductionType;
import com.solegendary.reignofnether.faction.FactionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Event;

public class DynamicProductionRegistry {
    private static final Map<ResourceLocation, DynamicProductionItem> PRODUCTIONS = new ConcurrentHashMap<ResourceLocation, DynamicProductionItem>();
    private static final Map<ResourceLocation, List<DynamicProductionItem>> PRODUCTIONS_BY_FACTION = new ConcurrentHashMap<ResourceLocation, List<DynamicProductionItem>>();
    private static final Map<ProductionType, List<DynamicProductionItem>> PRODUCTIONS_BY_TYPE = new ConcurrentHashMap<ProductionType, List<DynamicProductionItem>>();
    private static final List<DynamicProductionItem> PRODUCTION_LIST = new ArrayList<DynamicProductionItem>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DynamicProductionItem register(DynamicProductionItem productionItem) {
        if (productionItem == null) {
            throw new IllegalArgumentException("DynamicProductionItem cannot be null");
        }
        ResourceLocation id = productionItem.getId();
        if (PRODUCTIONS.containsKey(id)) {
            ReignOfNether.LOGGER.warn("Production item {} is already registered, skipping duplicate registration", (Object)id);
            return PRODUCTIONS.get(id);
        }
        PRODUCTIONS.put(id, productionItem);
        if (productionItem.getFaction() != null) {
            PRODUCTIONS_BY_FACTION.computeIfAbsent(productionItem.getFaction().getId(), k -> new ArrayList()).add(productionItem);
        }
        PRODUCTIONS_BY_TYPE.computeIfAbsent(productionItem.getProductionType(), k -> new ArrayList()).add(productionItem);
        List<DynamicProductionItem> list = PRODUCTION_LIST;
        synchronized (list) {
            PRODUCTION_LIST.add(productionItem);
        }
        ReignOfNether.LOGGER.info("Registered production item: {} ({}) for faction {} of type {}", (Object)productionItem.getDisplayName(), (Object)id, (Object)(productionItem.getFaction() != null ? productionItem.getFaction().getDisplayName() : "None"), (Object)productionItem.getProductionType().getDisplayName());
        return productionItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DynamicProductionItem registerOrUpdate(DynamicProductionItem productionItem) {
        if (productionItem == null) {
            throw new IllegalArgumentException("DynamicProductionItem cannot be null");
        }
        ResourceLocation id = productionItem.getId();
        DynamicProductionItem existing = PRODUCTIONS.get(id);
        if (existing != null) {
            List<DynamicProductionItem> typeProductions;
            List<DynamicProductionItem> factionProductions;
            if (existing.getFaction() != null && (factionProductions = PRODUCTIONS_BY_FACTION.get(existing.getFaction().getId())) != null) {
                factionProductions.remove(existing);
            }
            if ((typeProductions = PRODUCTIONS_BY_TYPE.get((Object)existing.getProductionType())) != null) {
                typeProductions.remove(existing);
            }
            List<DynamicProductionItem> list = PRODUCTION_LIST;
            synchronized (list) {
                PRODUCTION_LIST.remove(existing);
            }
            ReignOfNether.LOGGER.info("Updating existing production item: {} ({})", (Object)productionItem.getDisplayName(), (Object)id);
        } else {
            ReignOfNether.LOGGER.info("Registering new production item: {} ({})", (Object)productionItem.getDisplayName(), (Object)id);
        }
        PRODUCTIONS.put(id, productionItem);
        if (productionItem.getFaction() != null) {
            PRODUCTIONS_BY_FACTION.computeIfAbsent(productionItem.getFaction().getId(), k -> new ArrayList()).add(productionItem);
        }
        PRODUCTIONS_BY_TYPE.computeIfAbsent(productionItem.getProductionType(), k -> new ArrayList()).add(productionItem);
        List<DynamicProductionItem> list = PRODUCTION_LIST;
        synchronized (list) {
            PRODUCTION_LIST.add(productionItem);
        }
        return productionItem;
    }

    public static DynamicProductionItem getProductionItem(ResourceLocation id) {
        return PRODUCTIONS.get(id);
    }

    public static List<DynamicProductionItem> getProductionsForFaction(FactionType faction) {
        if (faction == null) {
            return new ArrayList<DynamicProductionItem>();
        }
        return new ArrayList<DynamicProductionItem>(PRODUCTIONS_BY_FACTION.getOrDefault(faction.getId(), Collections.emptyList()));
    }

    public static List<DynamicProductionItem> getProductionsForFaction(ResourceLocation factionId) {
        return new ArrayList<DynamicProductionItem>(PRODUCTIONS_BY_FACTION.getOrDefault(factionId, Collections.emptyList()));
    }

    public static List<DynamicProductionItem> getProductionsByType(ProductionType type) {
        return new ArrayList<DynamicProductionItem>(PRODUCTIONS_BY_TYPE.getOrDefault((Object)type, Collections.emptyList()));
    }

    public static List<DynamicProductionItem> getAllProductions() {
        return new ArrayList<DynamicProductionItem>(PRODUCTION_LIST);
    }

    public static Set<ResourceLocation> getAllProductionIds() {
        return new HashSet<ResourceLocation>(PRODUCTIONS.keySet());
    }

    public static List<DynamicProductionItem> getProductionsByFactionAndType(FactionType faction, ProductionType type) {
        List<DynamicProductionItem> factionProductions = DynamicProductionRegistry.getProductionsForFaction(faction);
        return factionProductions.stream().filter(production -> production.getProductionType() == type).collect(Collectors.toList());
    }

    public static List<DynamicProductionItem> getProductionsForResult(ItemStack result) {
        return PRODUCTION_LIST.stream().filter(production -> ItemStack.m_41656_((ItemStack)production.getResult(), (ItemStack)result)).collect(Collectors.toList());
    }

    public static List<DynamicProductionItem> getProductionsByTime(FactionType faction, boolean ascending) {
        List<DynamicProductionItem> productions = DynamicProductionRegistry.getProductionsForFaction(faction);
        productions.sort((a, b) -> {
            int comparison = Integer.compare(a.getProductionTime(), b.getProductionTime());
            return ascending ? comparison : -comparison;
        });
        return productions;
    }

    public static List<DynamicProductionItem> getProductionsByPriority(FactionType faction) {
        List<DynamicProductionItem> productions = DynamicProductionRegistry.getProductionsForFaction(faction);
        productions.sort((a, b) -> Integer.compare(b.getProperties().getPriority(), a.getProperties().getPriority()));
        return productions;
    }

    public static List<DynamicProductionItem> getWorkerBasedProductions() {
        return PRODUCTION_LIST.stream().filter(production -> production.getProperties().requiresWorkers()).collect(Collectors.toList());
    }

    public static List<DynamicProductionItem> getBatchProductions() {
        return PRODUCTION_LIST.stream().filter(production -> production.getProperties().isBatchProduction()).collect(Collectors.toList());
    }

    public static List<DynamicProductionItem> getVisibleProductions() {
        return PRODUCTION_LIST.stream().filter(production -> production.getProperties().isVisibleToEnemies()).collect(Collectors.toList());
    }

    public static boolean isRegistered(ResourceLocation id) {
        return PRODUCTIONS.containsKey(id);
    }

    public static Set<ProductionType> getActiveProductionTypes() {
        return new HashSet<ProductionType>(PRODUCTIONS_BY_TYPE.keySet());
    }

    public static Set<ResourceLocation> getFactionsWithProductions() {
        return new HashSet<ResourceLocation>(PRODUCTIONS_BY_FACTION.keySet());
    }

    public static int getProductionCount(FactionType faction) {
        return DynamicProductionRegistry.getProductionsForFaction(faction).size();
    }

    public static int getProductionCountByType(FactionType faction, ProductionType type) {
        return DynamicProductionRegistry.getProductionsByFactionAndType(faction, type).size();
    }

    public static double getAverageProductionTime(FactionType faction) {
        List<DynamicProductionItem> productions = DynamicProductionRegistry.getProductionsForFaction(faction);
        if (productions.isEmpty()) {
            return 0.0;
        }
        return productions.stream().mapToInt(DynamicProductionItem::getProductionTime).average().orElse(0.0);
    }

    public static synchronized void clear() {
        PRODUCTIONS.clear();
        PRODUCTIONS_BY_FACTION.clear();
        PRODUCTIONS_BY_TYPE.clear();
        PRODUCTION_LIST.clear();
    }

    public static class ProductionRegistrationEvent
    extends Event {
        public DynamicProductionItem registerProduction(DynamicProductionItem productionItem) {
            return DynamicProductionRegistry.register(productionItem);
        }
    }
}

