/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.config;

import com.solegendary.reignofnether.config.ConfigClientEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSyncResourceCostPacket {
    private final int food;
    private final int wood;
    private final int ore;
    private final int ticks;
    private final int population;
    private final String id;

    public ClientboundSyncResourceCostPacket(ResourceCost entry) {
        this.food = entry.food;
        this.wood = entry.wood;
        this.ore = entry.ore;
        this.ticks = entry.ticks;
        this.population = entry.population;
        this.id = entry.id;
    }

    public ClientboundSyncResourceCostPacket(FriendlyByteBuf buf) {
        this.food = buf.readInt();
        this.wood = buf.readInt();
        this.ore = buf.readInt();
        this.ticks = buf.readInt();
        this.population = buf.readInt();
        this.id = buf.m_130277_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.getFood());
        buf.writeInt(this.getWood());
        buf.writeInt(this.getOre());
        buf.writeInt(this.getTicks());
        buf.writeInt(this.getPopulation());
        buf.m_130070_(this.getId());
    }

    public static ClientboundSyncResourceCostPacket decode(FriendlyByteBuf buf) {
        return new ClientboundSyncResourceCostPacket(buf);
    }

    public static boolean handle(ClientboundSyncResourceCostPacket msg, Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientboundSyncResourceCostPacket.lambda$handle$1(msg, (Supplier)ctx));
            success.set(true);
        });
        context.setPacketHandled(true);
        return success.get();
    }

    public int getFood() {
        return this.food;
    }

    public int getWood() {
        return this.wood;
    }

    public int getOre() {
        return this.ore;
    }

    public int getTicks() {
        return this.ticks;
    }

    public int getPopulation() {
        return this.population;
    }

    public String getId() {
        return this.id;
    }

    private static /* synthetic */ Runnable lambda$handle$1(ClientboundSyncResourceCostPacket msg, Supplier ctx) {
        return () -> ClientboundSyncResourceCostPacket.lambda$handle$0(msg, (Supplier)ctx);
    }

    private static /* synthetic */ void lambda$handle$0(ClientboundSyncResourceCostPacket msg, Supplier ctx) {
        ConfigClientEvents.loadConfigData(msg, ctx);
    }
}

