/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.config;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.config.ClientboundSyncResourceCostPacket;
import com.solegendary.reignofnether.config.ResourceCostConfigEntry;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkEvent;

@OnlyIn(value=Dist.CLIENT)
public class ConfigClientEvents {
    private static ArrayList<FormattedCharSequence> tooltipLines = new ArrayList();
    public static boolean showDiffsButton = false;
    private static final Minecraft MC;

    public static void resetDiffsTooltips() {
        tooltipLines.clear();
        tooltipLines.add(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"config.reignofnether.warn_config_change", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))));
        tooltipLines.add(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"config.reignofnether.hide_config_change", (Object[])new Object[0]), (Style)Style.f_131099_));
        tooltipLines.add(FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_));
        showDiffsButton = false;
    }

    public static Button getDiffsButton() {
        return new Button("Configs Changed Warning", Button.itemIconSize, new ResourceLocation("reignofnether", "textures/hud/warning.png"), (Keybinding)null, () -> false, () -> !showDiffsButton || TutorialClientEvents.isEnabled(), () -> true, () -> {
            showDiffsButton = false;
        }, null, tooltipLines);
    }

    public static void loadConfigData(ClientboundSyncResourceCostPacket msg, Supplier<NetworkEvent.Context> ctx) {
        String key = msg.getId();
        if (ResourceCost.ENTRIES.containsKey(key)) {
            ResourceCost rescost = ResourceCost.ENTRIES.get(key);
            int woodDiff = msg.getWood() - rescost.wood;
            int foodDiff = msg.getFood() - rescost.food;
            int oreDiff = msg.getOre() - rescost.ore;
            int ticksDiff = msg.getTicks() - rescost.ticks;
            int popDiff = msg.getPopulation() - rescost.population;
            rescost.wood = msg.getWood();
            rescost.food = msg.getFood();
            rescost.ore = msg.getOre();
            rescost.ticks = msg.getTicks();
            rescost.population = msg.getPopulation();
            if (foodDiff != 0 || woodDiff != 0 || oreDiff != 0 || ticksDiff != 0 || popDiff != 0) {
                Object text = rescost.id.replace("reignofnether.", "").replace("_", "    ").toLowerCase(Locale.ENGLISH);
                text = ((String)text).substring(0, 1).toUpperCase() + ((String)text).substring(1);
                text = (String)text + ":";
                if (foodDiff != 0) {
                    text = (String)text + (foodDiff > 0 ? "    +" : "    ") + foodDiff + " \ue000";
                }
                if (woodDiff != 0) {
                    text = (String)text + (woodDiff > 0 ? "    +" : "    ") + woodDiff + " \ue001";
                }
                if (oreDiff != 0) {
                    text = (String)text + (oreDiff > 0 ? "    +" : "    ") + oreDiff + " \ue002";
                }
                if (ticksDiff != 0) {
                    text = (String)text + (ticksDiff > 0 ? "    +" : "    ") + ticksDiff / 20 + " \ue004";
                }
                if (popDiff != 0) {
                    text = (String)text + (popDiff > 0 ? "    +" : "    ") + popDiff + " \ue003";
                }
                showDiffsButton = true;
                tooltipLines.add(FormattedCharSequence.m_13714_((String)text, (Style)MyRenderer.iconStyle));
                ReignOfNether.LOGGER.info("Received different config from server: " + (String)text);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        ReignOfNether.LOGGER.info("onPlayerJoined fired from ClientConfigEvents");
        if (evt.getEntity().m_20194_().m_7779_(evt.getEntity().m_36316_())) {
            ConfigClientEvents.resetDiffsTooltips();
            ReignOfNether.LOGGER.info("Attempting to rebake from client..");
            for (ResourceCostConfigEntry entry : ResourceCostConfigEntry.ENTRIES) {
                String key = entry.id;
                if (!ResourceCost.ENTRIES.containsKey(key)) continue;
                ResourceCost rescost = ResourceCost.ENTRIES.get(key);
                ReignOfNether.LOGGER.info("ID found: " + key + ", replacing resourcecost " + String.valueOf(ResourceCost.ENTRIES.get(key)));
                rescost.bakeValues(entry);
            }
            ResourceCosts.deferredLoadResourceCosts();
        }
    }

    static {
        ConfigClientEvents.resetDiffsTooltips();
        MC = Minecraft.m_91087_();
    }
}

