/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.config;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.config.ResourceBlockConfig;
import com.solegendary.reignofnether.config.ResourceBlockConfigHandler;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.unit.pathfinding.async.MultiThreadedPathfindingManager;
import java.nio.file.Path;
import java.util.Map;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="reignofnether", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ConfigServerEvents {
    private static boolean configSystemInitialized = false;

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            if (!configSystemInitialized) {
                ReignOfNether.LOGGER.info("Initializing configurable resource block system...");
                ResourceBlockConfigHandler.loadConfig();
                ResourceSources.initializeConfigurableSystem();
                configSystemInitialized = true;
                ReignOfNether.LOGGER.info("Configurable resource block system initialized successfully");
                Map<String, Integer> stats = ResourceBlockConfig.getStatistics();
                ReignOfNether.LOGGER.info("Resource block configuration loaded: {} total blocks ({} enabled, {} wood, {} food, {} ore, {} modded)", (Object)stats.get("total"), (Object)stats.get("enabled"), (Object)stats.get("wood"), (Object)stats.get("food"), (Object)stats.get("ore"), (Object)stats.get("modded"));
            }
        });
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        ReignOfNether.LOGGER.info("Server starting - validating resource block configurations...");
        ResourceBlockConfigHandler.reloadConfig();
        Map<String, ResourceBlockConfig.ResourceBlockEntry> allConfigs = ResourceBlockConfig.getAllConfigs();
        int invalidBlocks = 0;
        for (Map.Entry<String, ResourceBlockConfig.ResourceBlockEntry> entry : allConfigs.entrySet()) {
            String blockId = entry.getKey();
            ResourceBlockConfig.ResourceBlockEntry config = entry.getValue();
            if (!config.enabled || config.isValidBlock()) continue;
            ReignOfNether.LOGGER.warn("Configured block '{}' not found in registry - disabling", (Object)blockId);
            ResourceBlockConfig.setConfig(blockId, config.resourceType, config.resourceValue, config.gatherTicks, false);
            ++invalidBlocks;
        }
        if (invalidBlocks > 0) {
            ReignOfNether.LOGGER.warn("Disabled {} invalid block configurations", (Object)invalidBlocks);
            ResourceBlockConfigHandler.saveConfig();
        }
        ResourceSources.refreshCombinedSources();
        ReignOfNether.LOGGER.info("Resource block configuration validation complete");
        try {
            ReignOfNether.LOGGER.info("Initializing multi-threaded pathfinding system...");
            MultiThreadedPathfindingManager.initialize(event.getServer());
            ReignOfNether.LOGGER.info("Multi-threaded pathfinding system initialized successfully");
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Failed to initialize multi-threaded pathfinding system: {}", (Object)e.getMessage());
            ReignOfNether.LOGGER.error("Pathfinding will fall back to synchronous mode");
        }
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        ReignOfNether.LOGGER.info("Server stopped - saving resource block configurations...");
        ResourceBlockConfigHandler.saveConfig();
        try {
            ReignOfNether.LOGGER.info("Shutting down multi-threaded pathfinding system...");
            MultiThreadedPathfindingManager.shutdown();
            ReignOfNether.LOGGER.info("Multi-threaded pathfinding system shutdown complete");
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error during pathfinding system shutdown: {}", (Object)e.getMessage());
        }
    }

    public static void reloadConfigSystem() {
        ReignOfNether.LOGGER.info("Reloading configurable resource system...");
        try {
            ResourceBlockConfigHandler.reloadConfig();
            ResourceSources.refreshCombinedSources();
            Map<String, Integer> stats = ResourceBlockConfig.getStatistics();
            ReignOfNether.LOGGER.info("Configuration reloaded: {} total blocks ({} enabled, {} wood, {} food, {} ore, {} modded)", (Object)stats.get("total"), (Object)stats.get("enabled"), (Object)stats.get("wood"), (Object)stats.get("food"), (Object)stats.get("ore"), (Object)stats.get("modded"));
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Failed to reload configuration system: {}", (Object)e.getMessage());
        }
    }

    public static boolean isConfigSystemInitialized() {
        return configSystemInitialized;
    }

    public static void exportConfigTemplate() {
        try {
            Path configPath = FMLPaths.CONFIGDIR.get().resolve("reignofnether").resolve("resource_blocks_template.json");
            ResourceBlockConfigHandler.exportTemplate(configPath);
            ReignOfNether.LOGGER.info("Exported configuration template to: {}", (Object)configPath);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Failed to export configuration template: {}", (Object)e.getMessage());
        }
    }
}

