/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.config;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.solegendary.reignofnether.config.ConfigServerEvents;
import com.solegendary.reignofnether.config.ResourceBlockConfig;
import com.solegendary.reignofnether.config.ResourceBlockConfigHandler;
import com.solegendary.reignofnether.resources.ConfigurableResourceSources;
import com.solegendary.reignofnether.resources.ResourceName;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="reignofnether", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ResourceBlockCommand {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reignofnether").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"resourceblocks").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list").executes(ResourceBlockCommand::listAllBlocks)).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("WOOD");
            builder.suggest("FOOD");
            builder.suggest("ORE");
            return builder.buildFuture();
        }).executes(ResourceBlockCommand::listBlocksByType)))).then(Commands.m_82127_((String)"info").then(Commands.m_82129_((String)"block", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(ResourceBlockCommand::getBlockInfo)))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"block", (ArgumentType)ResourceLocationArgument.m_106984_()).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("WOOD");
            builder.suggest("FOOD");
            builder.suggest("ORE");
            return builder.buildFuture();
        }).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000)).then(Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1, (int)6000)).executes(ResourceBlockCommand::addBlock))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"block", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(ResourceBlockCommand::removeBlock)))).then(Commands.m_82127_((String)"enable").then(Commands.m_82129_((String)"block", (ArgumentType)ResourceLocationArgument.m_106984_()).then(Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(ResourceBlockCommand::enableBlock))))).then(Commands.m_82127_((String)"reload").executes(ResourceBlockCommand::reloadConfig))).then(Commands.m_82127_((String)"export").executes(ResourceBlockCommand::exportTemplate))).then(Commands.m_82127_((String)"stats").executes(ResourceBlockCommand::showStats))));
    }

    private static int listAllBlocks(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Map<String, ResourceBlockConfig.ResourceBlockEntry> allConfigs = ResourceBlockConfig.getAllConfigs();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76=== Resource Block Configurations ==="), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7eTool configurations: " + allConfigs.size() + " blocks")), false);
        int enabled = 0;
        for (Map.Entry<String, ResourceBlockConfig.ResourceBlockEntry> entry : allConfigs.entrySet()) {
            ResourceBlockConfig.ResourceBlockEntry config = entry.getValue();
            if (!config.enabled) continue;
            ++enabled;
            String status = config.isValidBlock() ? "\u00a7a\u2713" : "\u00a7c\u2717";
            source.m_288197_(() -> Component.m_237113_((String)String.format("%s \u00a7f%s \u00a77(%s) \u00a7f%d resources \u00a77in %d ticks", new Object[]{status, entry.getKey(), config.resourceType, config.resourceValue, config.gatherTicks})), false);
        }
        int enabledCount = enabled;
        int totalCount = allConfigs.size();
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7aEnabled: " + enabledCount + " \u00a77/ \u00a7cDisabled: " + (totalCount - enabledCount))), false);
        return enabled;
    }

    private static int listBlocksByType(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String typeStr = StringArgumentType.getString(context, (String)"type").toUpperCase();
        try {
            ResourceName resourceType = ResourceName.valueOf(typeStr);
            Map<String, ResourceBlockConfig.ResourceBlockEntry> configs = ResourceBlockConfig.getConfigsByType(resourceType);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a76=== " + String.valueOf((Object)resourceType) + " Resource Blocks ===")), false);
            for (Map.Entry<String, ResourceBlockConfig.ResourceBlockEntry> entry : configs.entrySet()) {
                ResourceBlockConfig.ResourceBlockEntry config = entry.getValue();
                String status = config.isValidBlock() ? "\u00a7a\u2713" : "\u00a7c\u2717";
                source.m_288197_(() -> Component.m_237113_((String)String.format("%s \u00a7f%s \u00a7f%d resources \u00a77in %d ticks", status, entry.getKey(), config.resourceValue, config.gatherTicks)), false);
            }
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7aTool: " + configs.size() + " blocks")), false);
            return configs.size();
        }
        catch (IllegalArgumentException e) {
            source.m_81352_((Component)Component.m_237113_((String)"\u00a7cInvalid resource type. Use: WOOD, FOOD, or ORE"));
            return 0;
        }
    }

    private static int getBlockInfo(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ResourceLocation blockId = ResourceLocationArgument.m_107011_(context, (String)"block");
        ResourceBlockConfig.ResourceBlockEntry config = ResourceBlockConfig.getConfig(blockId.toString());
        if (config == null) {
            source.m_81352_((Component)Component.m_237113_((String)("\u00a7cBlock '" + String.valueOf(blockId) + "' is not configured as a resource block")));
            return 0;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockId);
        boolean exists = block != null && block != Blocks.f_50016_;
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76=== Block Information ==="), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7fBlock: \u00a7e" + String.valueOf(blockId))), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7fExists: " + (exists ? "\u00a7aYes" : "\u00a7cNo"))), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7fResource Type: \u00a7e" + String.valueOf((Object)config.resourceType))), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7fResource Value: \u00a7e" + config.resourceValue)), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7fGather Time: \u00a7e" + config.gatherTicks + " ticks \u00a77(" + (float)config.gatherTicks / 20.0f + "s)")), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7fEnabled: " + (config.enabled ? "\u00a7aYes" : "\u00a7cNo"))), false);
        return 1;
    }

    private static int addBlock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ResourceLocation blockId = ResourceLocationArgument.m_107011_(context, (String)"block");
        String typeStr = StringArgumentType.getString(context, (String)"type").toUpperCase();
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        int ticks = IntegerArgumentType.getInteger(context, (String)"ticks");
        try {
            ResourceName resourceType = ResourceName.valueOf(typeStr);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockId);
            if (block == null || block == Blocks.f_50016_) {
                source.m_81352_((Component)Component.m_237113_((String)("\u00a7cBlock '" + String.valueOf(blockId) + "' does not exist in the registry")));
                return 0;
            }
            ResourceBlockConfigHandler.addBlockConfig(blockId.toString(), resourceType, value, ticks, true);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7aAdded resource block configuration:"), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7f  Block: \u00a7e" + String.valueOf(blockId))), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7f  Type: \u00a7e" + String.valueOf((Object)resourceType))), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7f  Value: \u00a7e" + value + " resources")), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7f  Time: \u00a7e" + ticks + " ticks \u00a77(" + (float)ticks / 20.0f + "s)")), false);
            return 1;
        }
        catch (IllegalArgumentException e) {
            source.m_81352_((Component)Component.m_237113_((String)"\u00a7cInvalid resource type. Use: WOOD, FOOD, or ORE"));
            return 0;
        }
    }

    private static int removeBlock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ResourceLocation blockId = ResourceLocationArgument.m_107011_(context, (String)"block");
        ResourceBlockConfig.ResourceBlockEntry config = ResourceBlockConfig.getConfig(blockId.toString());
        if (config == null) {
            source.m_81352_((Component)Component.m_237113_((String)("\u00a7cBlock '" + String.valueOf(blockId) + "' is not configured as a resource block")));
            return 0;
        }
        ResourceBlockConfigHandler.removeBlockConfig(blockId.toString());
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7aRemoved resource block configuration for: \u00a7e" + String.valueOf(blockId))), false);
        return 1;
    }

    private static int enableBlock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ResourceLocation blockId = ResourceLocationArgument.m_107011_(context, (String)"block");
        boolean enabled = BoolArgumentType.getBool(context, (String)"enabled");
        ResourceBlockConfig.ResourceBlockEntry config = ResourceBlockConfig.getConfig(blockId.toString());
        if (config == null) {
            source.m_81352_((Component)Component.m_237113_((String)("\u00a7cBlock '" + String.valueOf(blockId) + "' is not configured as a resource block")));
            return 0;
        }
        ResourceBlockConfig.setConfig(blockId.toString(), config.resourceType, config.resourceValue, config.gatherTicks, enabled);
        ResourceBlockConfigHandler.saveConfig();
        String status = enabled ? "\u00a7aenabled" : "\u00a7cdisabled";
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7aResource block '" + String.valueOf(blockId) + "' has been " + status)), false);
        return 1;
    }

    private static int reloadConfig(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7eReloading resource block configurations..."), false);
        ConfigServerEvents.reloadConfigSystem();
        Map<String, Integer> stats = ResourceBlockConfig.getStatistics();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7aConfiguration reloaded successfully!"), false);
        source.m_288197_(() -> Component.m_237113_((String)String.format("\u00a7fLoaded: \u00a7e%d \u00a7ftotal blocks (\u00a7a%d \u00a7fenabled, \u00a7c%d \u00a7fdisabled)", stats.get("total"), stats.get("enabled"), (Integer)stats.get("total") - (Integer)stats.get("enabled"))), false);
        source.m_288197_(() -> Component.m_237113_((String)String.format("\u00a7fTypes: \u00a76%d \u00a7fwood, \u00a72%d \u00a7ffood, \u00a77%d \u00a7fore, \u00a7d%d \u00a7fmodded", stats.get("wood"), stats.get("food"), stats.get("ore"), stats.get("modded"))), false);
        return 1;
    }

    private static int exportTemplate(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7eExporting configuration template..."), false);
        ConfigServerEvents.exportConfigTemplate();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7aTemplate exported to config directory!"), false);
        return 1;
    }

    private static int showStats(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Map<String, Integer> configStats = ResourceBlockConfig.getStatistics();
        Map<String, Object> sourceStats = ConfigurableResourceSources.getSourceStatistics();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76=== Resource Block Statistics ==="), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7fConfiguration Stats:"), false);
        source.m_288197_(() -> Component.m_237113_((String)String.format("  \u00a7fTotal: \u00a7e%d \u00a77(\u00a7a%d \u00a7fenabled, \u00a7c%d \u00a7fdisabled)", configStats.get("total"), configStats.get("enabled"), (Integer)configStats.get("total") - (Integer)configStats.get("enabled"))), false);
        source.m_288197_(() -> Component.m_237113_((String)String.format("  \u00a7fBy Type: \u00a76%d \u00a7fwood, \u00a72%d \u00a7ffood, \u00a77%d \u00a7fore", configStats.get("wood"), configStats.get("food"), configStats.get("ore"))), false);
        source.m_288197_(() -> Component.m_237113_((String)String.format("  \u00a7fModded Blocks: \u00a7d%d", configStats.get("modded"))), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7fGenerated Sources:"), false);
        source.m_288197_(() -> Component.m_237113_((String)String.format("  \u00a7fSources: \u00a7e%d \u00a77(covering \u00a7e%d \u00a7fblocks total)", sourceStats.get("total_sources"), sourceStats.get("total_blocks"))), false);
        return 1;
    }
}

