/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.config;

import com.solegendary.reignofnether.resources.ResourceName;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class ResourceBlockConfig {
    private static final Map<String, ResourceBlockEntry> DEFAULT_CONFIGS = new HashMap<String, ResourceBlockEntry>();
    private static final Map<String, ResourceBlockEntry> RUNTIME_CONFIGS = new HashMap<String, ResourceBlockEntry>();

    private static void initializeDefaultConfigs() {
        ResourceBlockConfig.addDefault("minecraft:oak_log", ResourceName.WOOD, 4, 40, true);
        ResourceBlockConfig.addDefault("minecraft:spruce_log", ResourceName.WOOD, 4, 40, true);
        ResourceBlockConfig.addDefault("minecraft:birch_log", ResourceName.WOOD, 4, 40, true);
        ResourceBlockConfig.addDefault("minecraft:jungle_log", ResourceName.WOOD, 4, 40, true);
        ResourceBlockConfig.addDefault("minecraft:acacia_log", ResourceName.WOOD, 4, 40, true);
        ResourceBlockConfig.addDefault("minecraft:dark_oak_log", ResourceName.WOOD, 4, 40, true);
        ResourceBlockConfig.addDefault("minecraft:cherry_log", ResourceName.WOOD, 4, 40, true);
        ResourceBlockConfig.addDefault("minecraft:mangrove_log", ResourceName.WOOD, 4, 40, true);
        ResourceBlockConfig.addDefault("minecraft:stripped_oak_log", ResourceName.WOOD, 3, 35, true);
        ResourceBlockConfig.addDefault("minecraft:stripped_spruce_log", ResourceName.WOOD, 3, 35, true);
        ResourceBlockConfig.addDefault("minecraft:stripped_birch_log", ResourceName.WOOD, 3, 35, true);
        ResourceBlockConfig.addDefault("minecraft:stripped_jungle_log", ResourceName.WOOD, 3, 35, true);
        ResourceBlockConfig.addDefault("minecraft:stripped_acacia_log", ResourceName.WOOD, 3, 35, true);
        ResourceBlockConfig.addDefault("minecraft:stripped_dark_oak_log", ResourceName.WOOD, 3, 35, true);
        ResourceBlockConfig.addDefault("minecraft:stripped_cherry_log", ResourceName.WOOD, 3, 35, true);
        ResourceBlockConfig.addDefault("minecraft:stripped_mangrove_log", ResourceName.WOOD, 3, 35, true);
        ResourceBlockConfig.addDefault("minecraft:crimson_stem", ResourceName.WOOD, 4, 45, true);
        ResourceBlockConfig.addDefault("minecraft:warped_stem", ResourceName.WOOD, 4, 45, true);
        ResourceBlockConfig.addDefault("minecraft:stripped_crimson_stem", ResourceName.WOOD, 3, 40, true);
        ResourceBlockConfig.addDefault("minecraft:stripped_warped_stem", ResourceName.WOOD, 3, 40, true);
        ResourceBlockConfig.addDefault("minecraft:wheat", ResourceName.FOOD, 2, 20, true);
        ResourceBlockConfig.addDefault("minecraft:carrots", ResourceName.FOOD, 3, 20, true);
        ResourceBlockConfig.addDefault("minecraft:potatoes", ResourceName.FOOD, 3, 20, true);
        ResourceBlockConfig.addDefault("minecraft:beetroots", ResourceName.FOOD, 2, 20, true);
        ResourceBlockConfig.addDefault("minecraft:pumpkin", ResourceName.FOOD, 4, 30, true);
        ResourceBlockConfig.addDefault("minecraft:melon", ResourceName.FOOD, 3, 25, true);
        ResourceBlockConfig.addDefault("minecraft:carved_pumpkin", ResourceName.FOOD, 3, 25, true);
        ResourceBlockConfig.addDefault("minecraft:nether_wart", ResourceName.FOOD, 3, 25, true);
        ResourceBlockConfig.addDefault("minecraft:sweet_berry_bush", ResourceName.FOOD, 2, 15, true);
        ResourceBlockConfig.addDefault("minecraft:red_mushroom", ResourceName.FOOD, 1, 10, true);
        ResourceBlockConfig.addDefault("minecraft:brown_mushroom", ResourceName.FOOD, 1, 10, true);
        ResourceBlockConfig.addDefault("minecraft:stone", ResourceName.ORE, 2, 60, true);
        ResourceBlockConfig.addDefault("minecraft:cobblestone", ResourceName.ORE, 1, 50, true);
        ResourceBlockConfig.addDefault("minecraft:granite", ResourceName.ORE, 2, 55, true);
        ResourceBlockConfig.addDefault("minecraft:andesite", ResourceName.ORE, 2, 55, true);
        ResourceBlockConfig.addDefault("minecraft:diorite", ResourceName.ORE, 2, 55, true);
        ResourceBlockConfig.addDefault("minecraft:deepslate", ResourceName.ORE, 3, 70, true);
        ResourceBlockConfig.addDefault("minecraft:cobbled_deepslate", ResourceName.ORE, 2, 60, true);
        ResourceBlockConfig.addDefault("minecraft:coal_ore", ResourceName.ORE, 5, 80, true);
        ResourceBlockConfig.addDefault("minecraft:iron_ore", ResourceName.ORE, 8, 100, true);
        ResourceBlockConfig.addDefault("minecraft:copper_ore", ResourceName.ORE, 6, 90, true);
        ResourceBlockConfig.addDefault("minecraft:gold_ore", ResourceName.ORE, 12, 120, true);
        ResourceBlockConfig.addDefault("minecraft:diamond_ore", ResourceName.ORE, 20, 150, true);
        ResourceBlockConfig.addDefault("minecraft:emerald_ore", ResourceName.ORE, 25, 160, true);
        ResourceBlockConfig.addDefault("minecraft:deepslate_coal_ore", ResourceName.ORE, 6, 90, true);
        ResourceBlockConfig.addDefault("minecraft:deepslate_iron_ore", ResourceName.ORE, 10, 110, true);
        ResourceBlockConfig.addDefault("minecraft:deepslate_copper_ore", ResourceName.ORE, 8, 100, true);
        ResourceBlockConfig.addDefault("minecraft:deepslate_gold_ore", ResourceName.ORE, 15, 130, true);
        ResourceBlockConfig.addDefault("minecraft:deepslate_diamond_ore", ResourceName.ORE, 25, 160, true);
        ResourceBlockConfig.addDefault("minecraft:deepslate_emerald_ore", ResourceName.ORE, 30, 170, true);
        ResourceBlockConfig.addDefault("minecraft:nether_quartz_ore", ResourceName.ORE, 8, 90, true);
        ResourceBlockConfig.addDefault("minecraft:nether_gold_ore", ResourceName.ORE, 10, 100, true);
        ResourceBlockConfig.addDefault("minecraft:ancient_debris", ResourceName.ORE, 50, 200, true);
        ResourceBlockConfig.addDefault("minecraft:blackstone", ResourceName.ORE, 3, 65, true);
        ResourceBlockConfig.addDefault("minecraft:gilded_blackstone", ResourceName.ORE, 8, 85, true);
        RUNTIME_CONFIGS.putAll(DEFAULT_CONFIGS);
    }

    private static void addDefault(String blockId, ResourceName resourceType, int resourceValue, int gatherTicks, boolean enabled) {
        DEFAULT_CONFIGS.put(blockId, new ResourceBlockEntry(blockId, resourceType, resourceValue, gatherTicks, enabled));
    }

    public static ResourceBlockEntry getConfig(String blockId) {
        return RUNTIME_CONFIGS.get(blockId);
    }

    public static ResourceBlockEntry getConfig(Block block) {
        ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (resourceLocation != null) {
            return ResourceBlockConfig.getConfig(resourceLocation.toString());
        }
        return null;
    }

    public static boolean hasConfig(String blockId) {
        return RUNTIME_CONFIGS.containsKey(blockId) && ResourceBlockConfig.RUNTIME_CONFIGS.get((Object)blockId).enabled;
    }

    public static boolean hasConfig(Block block) {
        ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((Object)block);
        return resourceLocation != null && ResourceBlockConfig.hasConfig(resourceLocation.toString());
    }

    public static void setConfig(String blockId, ResourceName resourceType, int resourceValue, int gatherTicks, boolean enabled) {
        RUNTIME_CONFIGS.put(blockId, new ResourceBlockEntry(blockId, resourceType, resourceValue, gatherTicks, enabled));
    }

    public static void removeConfig(String blockId) {
        RUNTIME_CONFIGS.remove(blockId);
    }

    public static Map<String, ResourceBlockEntry> getAllConfigs() {
        return new HashMap<String, ResourceBlockEntry>(RUNTIME_CONFIGS);
    }

    public static Map<String, ResourceBlockEntry> getConfigsByType(ResourceName resourceType) {
        HashMap<String, ResourceBlockEntry> filtered = new HashMap<String, ResourceBlockEntry>();
        for (Map.Entry<String, ResourceBlockEntry> entry : RUNTIME_CONFIGS.entrySet()) {
            if (entry.getValue().resourceType != resourceType || !entry.getValue().enabled) continue;
            filtered.put(entry.getKey(), entry.getValue());
        }
        return filtered;
    }

    public static void resetToDefaults() {
        RUNTIME_CONFIGS.clear();
        RUNTIME_CONFIGS.putAll(DEFAULT_CONFIGS);
    }

    public static void loadConfigs(Map<String, ResourceBlockEntry> configs) {
        RUNTIME_CONFIGS.clear();
        RUNTIME_CONFIGS.putAll(configs);
        RUNTIME_CONFIGS.entrySet().removeIf(entry -> !((ResourceBlockEntry)entry.getValue()).isValidBlock());
    }

    public static Map<String, Integer> getStatistics() {
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        int totalConfigs = 0;
        int enabledConfigs = 0;
        int woodBlocks = 0;
        int foodBlocks = 0;
        int oreBlocks = 0;
        int moddedBlocks = 0;
        for (ResourceBlockEntry entry : RUNTIME_CONFIGS.values()) {
            ++totalConfigs;
            if (entry.enabled) {
                ++enabledConfigs;
                switch (entry.resourceType) {
                    case WOOD: {
                        ++woodBlocks;
                        break;
                    }
                    case FOOD: {
                        ++foodBlocks;
                        break;
                    }
                    case ORE: {
                        ++oreBlocks;
                    }
                }
            }
            if (entry.blockId.startsWith("minecraft:")) continue;
            ++moddedBlocks;
        }
        stats.put("total", totalConfigs);
        stats.put("enabled", enabledConfigs);
        stats.put("wood", woodBlocks);
        stats.put("food", foodBlocks);
        stats.put("ore", oreBlocks);
        stats.put("modded", moddedBlocks);
        return stats;
    }

    static {
        ResourceBlockConfig.initializeDefaultConfigs();
    }

    public static class ResourceBlockEntry {
        public final String blockId;
        public final ResourceName resourceType;
        public final int resourceValue;
        public final int gatherTicks;
        public final boolean enabled;

        public ResourceBlockEntry(String blockId, ResourceName resourceType, int resourceValue, int gatherTicks, boolean enabled) {
            this.blockId = blockId;
            this.resourceType = resourceType;
            this.resourceValue = resourceValue;
            this.gatherTicks = gatherTicks;
            this.enabled = enabled;
        }

        public Block getBlock() {
            ResourceLocation resourceLocation = new ResourceLocation(this.blockId);
            return (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
        }

        public boolean isValidBlock() {
            ResourceLocation resourceLocation = new ResourceLocation(this.blockId);
            return ForgeRegistries.BLOCKS.containsKey(resourceLocation);
        }
    }
}

