/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.datapack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingProperties;
import com.solegendary.reignofnether.building.BuildingRegistry;
import com.solegendary.reignofnether.building.BuildingType;
import com.solegendary.reignofnether.building.custombuilding.CustomBuilding;
import com.solegendary.reignofnether.building.custombuilding.CustomProductionBuilding;
import com.solegendary.reignofnether.building.production.dynamic.DatapackUnitProductionItem;
import com.solegendary.reignofnether.faction.FactionRegistry;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.resources.ResourceCost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;

public class BuildingDataLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();

    public BuildingDataLoader() {
        super(GSON, "reignofnether/buildings");
    }

    private static ResourceCost parseUnitCost(JsonObject c) {
        if (c == null) {
            return null;
        }
        int food = GsonHelper.m_13824_((JsonObject)c, (String)"food", (int)0);
        int wood = GsonHelper.m_13824_((JsonObject)c, (String)"wood", (int)0);
        int ore = GsonHelper.m_13824_((JsonObject)c, (String)"ore", (int)0);
        int ticks = GsonHelper.m_13824_((JsonObject)c, (String)"ticks", (int)0);
        int pop = GsonHelper.m_13824_((JsonObject)c, (String)"population", (int)0);
        return ResourceCost.Unit(food, wood, ore, Math.max(0, ticks / 20), pop);
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> elements, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller profiler) {
        ReignOfNether.LOGGER.info("=== BUILDING DATAPACK LOADING START ===");
        ReignOfNether.LOGGER.info("Found {} building file(s) to process", (Object)elements.size());
        int count = 0;
        int failed = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry : elements.entrySet()) {
            ResourceLocation id = entry.getKey();
            ReignOfNether.LOGGER.info("Processing building file: {}", (Object)id);
            try {
                BuildingType<Building> buildingType;
                Building instance;
                boolean hasProductions;
                BuildingProperties properties;
                ResourceCost cost;
                ResourceLocation pbKey;
                FactionType faction;
                String displayName;
                JsonObject root;
                block57: {
                    boolean wantsProduction;
                    Block portraitBlock0;
                    String factionStr;
                    if (!entry.getValue().isJsonObject()) {
                        ReignOfNether.LOGGER.warn("Skipping building {}: root is not an object", (Object)id);
                        ++failed;
                        continue;
                    }
                    root = entry.getValue().getAsJsonObject();
                    ReignOfNether.LOGGER.debug("  - JSON parsed successfully");
                    displayName = GsonHelper.m_13851_((JsonObject)root, (String)"display_name", (String)id.m_135815_());
                    ReignOfNether.LOGGER.debug("  - Display name: '{}'", (Object)displayName);
                    String string = factionStr = root.has("faction") ? GsonHelper.m_13906_((JsonObject)root, (String)"faction") : "";
                    if (!factionStr.isEmpty()) {
                        ReignOfNether.LOGGER.debug("  - Faction string: '{}'", (Object)factionStr);
                    } else {
                        ReignOfNether.LOGGER.debug("  - No faction specified");
                    }
                    String structure = GsonHelper.m_13851_((JsonObject)root, (String)"structure", (String)id.m_135815_());
                    ReignOfNether.LOGGER.debug("  - Structure path: '{}'", (Object)structure);
                    String portraitBlockStr = GsonHelper.m_13851_((JsonObject)root, (String)"portrait_block", (String)"minecraft:stone");
                    ReignOfNether.LOGGER.debug("  - Portrait block string: '{}'", (Object)portraitBlockStr);
                    faction = null;
                    if (!factionStr.isEmpty()) {
                        ResourceLocation factionId = ResourceLocation.m_135820_((String)factionStr);
                        if (factionId == null) {
                            ReignOfNether.LOGGER.error("  - Invalid faction ResourceLocation: '{}'", (Object)factionStr);
                            ++failed;
                            continue;
                        }
                        faction = FactionRegistry.getFaction(factionId);
                        if (faction == null) {
                            ReignOfNether.LOGGER.error("  - Unknown faction: {} - Faction must be loaded before buildings", (Object)factionId);
                            ReignOfNether.LOGGER.error("  - Available factions: {}", FactionRegistry.getAllFactions().stream().map(f -> f.getId().toString()).toList());
                            ++failed;
                            continue;
                        }
                        ReignOfNether.LOGGER.debug("  - Faction resolved: {}", (Object)faction.getDisplayName());
                    }
                    if ((pbKey = ResourceLocation.m_135820_((String)portraitBlockStr)) == null) {
                        ReignOfNether.LOGGER.warn("  - Failed to parse portrait_block as ResourceLocation: '{}', defaulting to stone", (Object)portraitBlockStr);
                    }
                    Block block = portraitBlock0 = pbKey != null ? (Block)BuiltInRegistries.f_256975_.m_7745_(pbKey) : null;
                    if (portraitBlock0 == null) {
                        ReignOfNether.LOGGER.warn("  - Unknown portrait_block: {}, defaulting to minecraft:stone", (Object)portraitBlockStr);
                        portraitBlock0 = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation("minecraft", "stone"));
                    } else {
                        ReignOfNether.LOGGER.debug("  - Portrait block resolved: {}", (Object)pbKey);
                    }
                    ReignOfNether.LOGGER.debug("  - Parsing cost section");
                    cost = BuildingDataLoader.parseCost(root, id);
                    boolean isCapitol = FactionRegistry.getAllFactions().stream().anyMatch(f -> id.equals((Object)f.getStartCapitolBuildingId()));
                    if (isCapitol) {
                        ReignOfNether.LOGGER.debug("  - Detected as capitol building for at least one faction");
                    }
                    ReignOfNether.LOGGER.debug("  - Parsing properties section");
                    properties = BuildingDataLoader.parseBuildingProperties(root.has("properties") ? root.getAsJsonObject("properties") : null, isCapitol, id);
                    Block portraitBlock = portraitBlock0;
                    boolean bl = hasProductions = root.has("productions") && root.get("productions").isJsonArray();
                    if (hasProductions) {
                        ReignOfNether.LOGGER.debug("  - Found productions configuration with {} entries", (Object)root.getAsJsonArray("productions").size());
                    }
                    boolean hasEffectsEnabled = false;
                    if (root.has("effects") && root.get("effects").isJsonObject()) {
                        boolean enabled;
                        JsonObject eff = root.getAsJsonObject("effects");
                        ReignOfNether.LOGGER.debug("  - Found effects configuration");
                        if (eff.has("nether_convert") && eff.get("nether_convert").isJsonObject()) {
                            JsonObject nc = eff.getAsJsonObject("nether_convert");
                            enabled = GsonHelper.m_13855_((JsonObject)nc, (String)"enabled", (boolean)false);
                            hasEffectsEnabled |= enabled;
                            if (enabled) {
                                ReignOfNether.LOGGER.debug("  - Nether conversion effect enabled");
                            }
                        }
                        if (eff.has("darkness_aura") && eff.get("darkness_aura").isJsonObject()) {
                            JsonObject da = eff.getAsJsonObject("darkness_aura");
                            enabled = GsonHelper.m_13855_((JsonObject)da, (String)"enabled", (boolean)false);
                            hasEffectsEnabled |= enabled;
                            if (enabled) {
                                ReignOfNether.LOGGER.debug("  - Darkness aura effect enabled");
                            }
                        }
                    }
                    instance = (Building)ReignOfNetherRegistries.BUILDING.m_7745_(id);
                    boolean bl2 = wantsProduction = properties.isProductionBuilding() || hasProductions || hasEffectsEnabled;
                    if (instance == null) {
                        ReignOfNether.LOGGER.debug("  - Creating new building instance (production={})", (Object)wantsProduction);
                        instance = wantsProduction ? new CustomProductionBuilding(structure, cost, isCapitol, portraitBlock) : new CustomBuilding(structure, cost, isCapitol, portraitBlock);
                        try {
                            Registry.m_122965_(ReignOfNetherRegistries.BUILDING, (ResourceLocation)id, (Object)instance);
                            ReignOfNether.LOGGER.debug("  - Registered building in BUILDING registry");
                            break block57;
                        }
                        catch (Exception e) {
                            ReignOfNether.LOGGER.error("  - Failed to register building in registry: {}", (Object)e.getMessage());
                            ReignOfNether.LOGGER.error("  - Stack trace:", (Throwable)e);
                            ++failed;
                            continue;
                        }
                    }
                    ReignOfNether.LOGGER.debug("  - Updating existing building instance");
                    instance.structureName = structure;
                    instance.cost = cost;
                    instance.portraitBlock = portraitBlock;
                }
                try {
                    if (pbKey != null) {
                        instance.icon = new ResourceLocation(pbKey.m_135827_(), "textures/block/" + pbKey.m_135815_() + ".png");
                        ReignOfNether.LOGGER.debug("  - Derived icon from portrait block: {}", (Object)instance.icon);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (root.has("requires") && root.get("requires").isJsonObject()) {
                    JsonObject req = root.getAsJsonObject("requires");
                    ReignOfNether.LOGGER.debug("  - Processing requirements section");
                    if (instance instanceof CustomProductionBuilding) {
                        CustomProductionBuilding ip = (CustomProductionBuilding)instance;
                        ip.requiredBuildings.clear();
                        ip.requiredResearch.clear();
                        if (req.has("buildings") && req.get("buildings").isJsonArray()) {
                            for (JsonElement el : req.getAsJsonArray("buildings")) {
                                rid = ResourceLocation.m_135820_((String)el.getAsString());
                                if (rid == null) continue;
                                ip.requiredBuildings.add(rid);
                                ReignOfNether.LOGGER.debug("  - Added building requirement: {}", (Object)rid);
                            }
                        }
                        if (req.has("research") && req.get("research").isJsonArray()) {
                            for (JsonElement el : req.getAsJsonArray("research")) {
                                rid = ResourceLocation.m_135820_((String)el.getAsString());
                                if (rid == null) continue;
                                ip.requiredResearch.add(rid);
                                ReignOfNether.LOGGER.debug("  - Added research requirement: {}", (Object)rid);
                            }
                        }
                    } else if (instance instanceof CustomBuilding) {
                        CustomBuilding ic = (CustomBuilding)instance;
                        ic.requiredBuildings.clear();
                        ic.requiredResearch.clear();
                        if (req.has("buildings") && req.get("buildings").isJsonArray()) {
                            for (JsonElement el : req.getAsJsonArray("buildings")) {
                                rid = ResourceLocation.m_135820_((String)el.getAsString());
                                if (rid == null) continue;
                                ic.requiredBuildings.add(rid);
                                ReignOfNether.LOGGER.debug("  - Added building requirement: {}", (Object)rid);
                            }
                        }
                        if (req.has("research") && req.get("research").isJsonArray()) {
                            for (JsonElement el : req.getAsJsonArray("research")) {
                                rid = ResourceLocation.m_135820_((String)el.getAsString());
                                if (rid == null) continue;
                                ic.requiredResearch.add(rid);
                                ReignOfNether.LOGGER.debug("  - Added research requirement: {}", (Object)rid);
                            }
                        }
                    }
                }
                if (hasProductions && instance instanceof CustomProductionBuilding) {
                    CustomProductionBuilding prodBuilding = (CustomProductionBuilding)instance;
                    prodBuilding.productions.productions.clear();
                    ReignOfNether.LOGGER.debug("  - Processing productions");
                    int prodCount = 0;
                    for (JsonElement el : root.getAsJsonArray("productions")) {
                        String iconStr;
                        ResourceLocation rl;
                        if (!el.isJsonObject()) continue;
                        JsonObject p = el.getAsJsonObject();
                        String unitStr = GsonHelper.m_13851_((JsonObject)p, (String)"unit", (String)"");
                        if (unitStr.isEmpty()) {
                            ReignOfNether.LOGGER.warn("  - Skipping production: missing 'unit' id");
                            continue;
                        }
                        ResourceLocation unitId = ResourceLocation.m_135820_((String)unitStr);
                        if (unitId == null) {
                            ReignOfNether.LOGGER.warn("  - Skipping production: invalid unit id '{}'", (Object)unitStr);
                            continue;
                        }
                        String disp = GsonHelper.m_13851_((JsonObject)p, (String)"display_name", (String)unitId.m_135815_());
                        ResourceCost pcost = BuildingDataLoader.parseUnitCost(p.has("cost") ? p.getAsJsonObject("cost") : null);
                        if (pcost == null) {
                            pcost = ResourceCost.Unit(0, 0, 0, 0, 0);
                        }
                        ResourceLocation icon = null;
                        if (p.has("icon") && (rl = BuildingDataLoader.parseTextureResource(iconStr = GsonHelper.m_13906_((JsonObject)p, (String)"icon"))) != null) {
                            icon = rl;
                        }
                        ResourceLocation prodId = new ResourceLocation(id.m_135827_(), id.m_135815_() + "/unit/" + unitId.m_135827_() + "." + unitId.m_135815_());
                        DatapackUnitProductionItem dynItem = new DatapackUnitProductionItem(unitId, disp, pcost, icon);
                        try {
                            Registry.m_122965_(ReignOfNetherRegistries.PRODUCTION_ITEM, (ResourceLocation)prodId, (Object)dynItem);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        prodBuilding.productions.add(dynItem, null);
                        ReignOfNether.LOGGER.debug("  - Added production: {} ({})", (Object)disp, (Object)unitId);
                        ++prodCount;
                    }
                    ReignOfNether.LOGGER.debug("  - Loaded {} production(s)", (Object)prodCount);
                }
                if (root.has("effects") && root.get("effects").isJsonObject() && instance instanceof CustomProductionBuilding) {
                    CustomProductionBuilding cpb = (CustomProductionBuilding)instance;
                    JsonObject eff = root.getAsJsonObject("effects");
                    if (eff.has("nether_convert") && eff.get("nether_convert").isJsonObject()) {
                        Block ow;
                        ArrayList<Block> list;
                        Block nether;
                        JsonObject mapObj;
                        JsonObject nc = eff.getAsJsonObject("nether_convert");
                        boolean enabled = GsonHelper.m_13855_((JsonObject)nc, (String)"enabled", (boolean)false);
                        double maxRange = GsonHelper.m_144742_((JsonObject)nc, (String)"max_range", (double)0.0);
                        double startRange = GsonHelper.m_144742_((JsonObject)nc, (String)"start_range", (double)0.0);
                        cpb.setNetherConvert(enabled, maxRange, startRange);
                        HashMap<Block, List<Block>> m = new HashMap<Block, List<Block>>();
                        HashMap<Block, List<Block>> pm = new HashMap<Block, List<Block>>();
                        if (nc.has("mappings") && nc.get("mappings").isJsonObject()) {
                            mapObj = nc.getAsJsonObject("mappings");
                            for (String k : mapObj.keySet()) {
                                nether = (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_135820_((String)k));
                                if (nether == null) continue;
                                list = new ArrayList<Block>();
                                for (JsonElement v : mapObj.getAsJsonArray(k)) {
                                    ow = (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_135820_((String)v.getAsString()));
                                    if (ow == null) continue;
                                    list.add(ow);
                                }
                                if (list.isEmpty()) continue;
                                m.put(nether, list);
                            }
                        }
                        if (nc.has("plant_mappings") && nc.get("plant_mappings").isJsonObject()) {
                            mapObj = nc.getAsJsonObject("plant_mappings");
                            for (String k : mapObj.keySet()) {
                                nether = (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_135820_((String)k));
                                if (nether == null) continue;
                                list = new ArrayList();
                                for (JsonElement v : mapObj.getAsJsonArray(k)) {
                                    ow = (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_135820_((String)v.getAsString()));
                                    if (ow == null) continue;
                                    list.add(ow);
                                }
                                if (list.isEmpty()) continue;
                                pm.put(nether, list);
                            }
                        }
                        if (!m.isEmpty() || !pm.isEmpty()) {
                            cpb.setNetherMappings(m.isEmpty() ? null : m, pm.isEmpty() ? null : pm);
                        }
                    }
                    if (eff.has("darkness_aura") && eff.get("darkness_aura").isJsonObject()) {
                        JsonObject da = eff.getAsJsonObject("darkness_aura");
                        boolean enabled = GsonHelper.m_13855_((JsonObject)da, (String)"enabled", (boolean)false);
                        double radius = GsonHelper.m_144742_((JsonObject)da, (String)"radius", (double)0.0);
                        cpb.setDarknessAura(enabled, radius);
                    }
                }
                Building inst = instance;
                Supplier<Building> supplier = () -> inst;
                int uiOrder = Integer.MAX_VALUE;
                String uiHotkey = null;
                if (root.has("ui") && root.get("ui").isJsonObject()) {
                    JsonObject ui = root.getAsJsonObject("ui");
                    uiOrder = GsonHelper.m_13824_((JsonObject)ui, (String)"order", (int)Integer.MAX_VALUE);
                    uiHotkey = GsonHelper.m_13851_((JsonObject)ui, (String)"hotkey", (String)"");
                    if (uiHotkey.isBlank()) {
                        uiHotkey = null;
                    }
                }
                BuildingType<Building> typed = buildingType = new BuildingType<Building>(id, displayName, supplier, faction, cost, properties, inst.getClass(), uiOrder, uiHotkey);
                BuildingRegistry.registerOrUpdate(typed);
                ++count;
            }
            catch (Exception ex) {
                ++failed;
                ReignOfNether.LOGGER.error("Failed to load building {} from datapack: {}", (Object)id, (Object)ex.getMessage());
                ReignOfNether.LOGGER.error("Stack trace:", (Throwable)ex);
            }
        }
        ReignOfNether.LOGGER.info("=== BUILDING DATAPACK LOADING COMPLETE ===");
        ReignOfNether.LOGGER.info("Successfully loaded: {}, Failed: {}", (Object)count, (Object)failed);
    }

    private static ResourceCost parseCost(JsonObject root, ResourceLocation id) {
        if (!root.has("cost") || !root.get("cost").isJsonObject()) {
            ReignOfNether.LOGGER.warn("  - No cost section found in building {}", (Object)id);
            return null;
        }
        JsonObject c = root.getAsJsonObject("cost");
        int food = GsonHelper.m_13824_((JsonObject)c, (String)"food", (int)0);
        int wood = GsonHelper.m_13824_((JsonObject)c, (String)"wood", (int)0);
        int ore = GsonHelper.m_13824_((JsonObject)c, (String)"ore", (int)0);
        int supply = GsonHelper.m_13824_((JsonObject)c, (String)"supply", (int)0);
        ReignOfNether.LOGGER.debug("  - Cost parsed: food={}, wood={}, ore={}, supply={}", (Object)food, (Object)wood, (Object)ore, (Object)supply);
        return ResourceCost.Building(food, wood, ore, supply);
    }

    private static BuildingProperties parseBuildingProperties(JsonObject p, boolean isCapitol, ResourceLocation id) {
        if (p == null) {
            p = new JsonObject();
        }
        BuildingProperties.Builder b = BuildingProperties.builder();
        if (p.has("production_building")) {
            b.productionBuilding(GsonHelper.m_13912_((JsonObject)p, (String)"production_building"));
        }
        if (p.has("garrison_building")) {
            b.garrisonBuilding(GsonHelper.m_13912_((JsonObject)p, (String)"garrison_building"));
        }
        if (p.has("defensive_building")) {
            b.defensiveBuilding(GsonHelper.m_13912_((JsonObject)p, (String)"defensive_building"));
        }
        if (p.has("resource_building")) {
            b.resourceBuilding(GsonHelper.m_13912_((JsonObject)p, (String)"resource_building"));
        }
        if (p.has("population_building")) {
            b.populationBuilding(GsonHelper.m_13912_((JsonObject)p, (String)"population_building"));
        }
        if (p.has("max_health")) {
            b.maxHealth(GsonHelper.m_13927_((JsonObject)p, (String)"max_health"));
        }
        if (p.has("armor_value")) {
            b.armorValue(GsonHelper.m_13915_((JsonObject)p, (String)"armor_value"));
        }
        if (p.has("explosion_resistance")) {
            b.explosionResistance(GsonHelper.m_13915_((JsonObject)p, (String)"explosion_resistance"));
        }
        if (p.has("fire_proof")) {
            b.fireProof(GsonHelper.m_13912_((JsonObject)p, (String)"fire_proof"));
        }
        if (p.has("can_be_destroyed")) {
            b.canBeDestroyed(GsonHelper.m_13912_((JsonObject)p, (String)"can_be_destroyed"));
        }
        if (p.has("build_time")) {
            b.buildTime(GsonHelper.m_13927_((JsonObject)p, (String)"build_time"));
        }
        if (p.has("population_provided")) {
            b.populationProvided(GsonHelper.m_13927_((JsonObject)p, (String)"population_provided"));
        }
        if (p.has("population_required")) {
            b.populationRequired(GsonHelper.m_13927_((JsonObject)p, (String)"population_required"));
        }
        if (p.has("resource_production_rate")) {
            b.resourceProductionRate(GsonHelper.m_13915_((JsonObject)p, (String)"resource_production_rate"));
        }
        if (p.has("attack_damage")) {
            b.attackDamage(GsonHelper.m_13927_((JsonObject)p, (String)"attack_damage"));
        }
        if (p.has("attack_range")) {
            b.attackRange(GsonHelper.m_13927_((JsonObject)p, (String)"attack_range"));
        }
        if (p.has("vision_range")) {
            b.visionRange(GsonHelper.m_13927_((JsonObject)p, (String)"vision_range"));
        }
        if (p.has("has_ranged_attack")) {
            b.hasRangedAttack(GsonHelper.m_13912_((JsonObject)p, (String)"has_ranged_attack"));
        }
        if (p.has("garrison_capacity")) {
            b.garrisonCapacity(GsonHelper.m_13927_((JsonObject)p, (String)"garrison_capacity"));
        }
        if (p.has("requires_nether")) {
            b.requiresNether(GsonHelper.m_13912_((JsonObject)p, (String)"requires_nether"));
        }
        if (p.has("requires_water")) {
            b.requiresWater(GsonHelper.m_13912_((JsonObject)p, (String)"requires_water"));
        }
        if (p.has("requires_flat")) {
            b.requiresFlat(GsonHelper.m_13912_((JsonObject)p, (String)"requires_flat"));
        }
        if (p.has("can_be_bridge")) {
            b.canBeBridge(GsonHelper.m_13912_((JsonObject)p, (String)"can_be_bridge"));
        }
        if (p.has("converts_nether")) {
            b.convertsNether(GsonHelper.m_13912_((JsonObject)p, (String)"converts_nether"));
        }
        if (p.has("provides_night_vision")) {
            b.providesNightVision(GsonHelper.m_13912_((JsonObject)p, (String)"provides_night_vision"));
        }
        if (p.has("max_per_player")) {
            b.maxPerPlayer(GsonHelper.m_13927_((JsonObject)p, (String)"max_per_player"));
        }
        if (p.has("provides") && p.get("provides").isJsonArray()) {
            for (JsonElement el : p.getAsJsonArray("provides")) {
                String s = el.getAsString().toLowerCase();
                if ("food".equals(s)) {
                    b.providesFood(true);
                    continue;
                }
                if ("wood".equals(s)) {
                    b.providesWood(true);
                    continue;
                }
                if (!"ore".equals(s)) continue;
                b.providesOre(true);
            }
        }
        if (isCapitol && !p.has("max_per_player")) {
            b.maxPerPlayer(1);
        }
        ReignOfNether.LOGGER.debug("  - Properties parsed: {}", (Object)b.build());
        return b.build();
    }

    private static ResourceLocation parseTextureResource(String s) {
        String rest;
        int slash;
        if (s == null || s.isEmpty()) {
            return null;
        }
        if (s.startsWith("assets/") && (slash = (rest = s.substring("assets/".length())).indexOf(47)) > 0) {
            String ns = rest.substring(0, slash);
            String path = rest.substring(slash + 1);
            return new ResourceLocation(ns, path);
        }
        return ResourceLocation.m_135820_((String)s);
    }
}

