/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.datapack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.faction.FactionProperties;
import com.solegendary.reignofnether.faction.FactionRegistry;
import com.solegendary.reignofnether.faction.FactionType;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class FactionDataLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();

    public FactionDataLoader() {
        super(GSON, "reignofnether/factions");
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> elements, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller profiler) {
        ReignOfNether.LOGGER.info("=== FACTION DATAPACK LOADING START ===");
        ReignOfNether.LOGGER.info("Found {} faction file(s) to process", (Object)elements.size());
        int count = 0;
        int failed = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry : elements.entrySet()) {
            ResourceLocation id = entry.getKey();
            ReignOfNether.LOGGER.info("Processing faction file: {}", (Object)id);
            try {
                if (!entry.getValue().isJsonObject()) {
                    ReignOfNether.LOGGER.warn("Skipping faction {}: root is not an object", (Object)id);
                    ++failed;
                    continue;
                }
                JsonObject root = entry.getValue().getAsJsonObject();
                ReignOfNether.LOGGER.debug("  - JSON parsed successfully");
                String displayName = GsonHelper.m_13851_((JsonObject)root, (String)"display_name", (String)id.m_135815_());
                ReignOfNether.LOGGER.debug("  - Display name: '{}'", (Object)displayName);
                String primaryColorStr = GsonHelper.m_13851_((JsonObject)root, (String)"primary_color", (String)"#FFFFFF");
                String secondaryColorStr = GsonHelper.m_13851_((JsonObject)root, (String)"secondary_color", (String)"#AAAAAA");
                ReignOfNether.LOGGER.debug("  - Colors: primary={}, secondary={}", (Object)primaryColorStr, (Object)secondaryColorStr);
                int primaryColor = FactionDataLoader.parseColor(primaryColorStr);
                int secondaryColor = FactionDataLoader.parseColor(secondaryColorStr);
                FactionProperties.Builder propsBuilder = FactionProperties.builder();
                if (root.has("properties") && root.get("properties").isJsonObject()) {
                    JsonObject p = root.getAsJsonObject("properties");
                    ReignOfNether.LOGGER.debug("  - Loading {} faction properties", (Object)p.size());
                    propsBuilder.nightHealing(GsonHelper.m_13855_((JsonObject)p, (String)"night_healing", (boolean)false)).nightSourceHealing(GsonHelper.m_13855_((JsonObject)p, (String)"night_source_healing", (boolean)false)).netherHealing(GsonHelper.m_13855_((JsonObject)p, (String)"nether_healing", (boolean)false)).healingTicks(GsonHelper.m_13824_((JsonObject)p, (String)"healing_ticks", (int)100)).healingAmount(GsonHelper.m_13820_((JsonObject)p, (String)"healing_amount", (float)1.0f)).fireImmune(GsonHelper.m_13855_((JsonObject)p, (String)"fire_immune", (boolean)false)).drownImmune(GsonHelper.m_13855_((JsonObject)p, (String)"drown_immune", (boolean)false)).freezeImmune(GsonHelper.m_13855_((JsonObject)p, (String)"freeze_immune", (boolean)false)).poisonImmune(GsonHelper.m_13855_((JsonObject)p, (String)"poison_immune", (boolean)false)).damageMultiplier(GsonHelper.m_13820_((JsonObject)p, (String)"damage_multiplier", (float)1.0f)).armorMultiplier(GsonHelper.m_13820_((JsonObject)p, (String)"armor_multiplier", (float)1.0f)).speedMultiplier(GsonHelper.m_13820_((JsonObject)p, (String)"speed_multiplier", (float)1.0f)).resourceProductionMultiplier(GsonHelper.m_13820_((JsonObject)p, (String)"resource_production_multiplier", (float)1.0f)).buildTimeMultiplier(GsonHelper.m_13820_((JsonObject)p, (String)"build_time_multiplier", (float)1.0f)).recruitmentCostMultiplier(GsonHelper.m_13820_((JsonObject)p, (String)"recruitment_cost_multiplier", (float)1.0f)).aggressive(GsonHelper.m_13855_((JsonObject)p, (String)"aggressive", (boolean)false)).defensive(GsonHelper.m_13855_((JsonObject)p, (String)"defensive", (boolean)false)).expansionist(GsonHelper.m_13855_((JsonObject)p, (String)"expansionist", (boolean)false)).aiDifficultyMultiplier(GsonHelper.m_13820_((JsonObject)p, (String)"ai_difficulty_multiplier", (float)1.0f));
                } else {
                    ReignOfNether.LOGGER.debug("  - No properties section found, using defaults");
                }
                ResourceLocation icon = null;
                if (root.has("icon")) {
                    String iconStr = GsonHelper.m_13906_((JsonObject)root, (String)"icon");
                    ReignOfNether.LOGGER.debug("  - Parsing icon: '{}'", (Object)iconStr);
                    ResourceLocation rl = FactionDataLoader.parseTextureResource(iconStr);
                    if (rl != null) {
                        icon = rl;
                        ReignOfNether.LOGGER.debug("  - Icon resolved to: {}", (Object)rl);
                    } else {
                        ReignOfNether.LOGGER.warn("  - Failed to parse icon resource: '{}'", (Object)iconStr);
                    }
                } else {
                    ReignOfNether.LOGGER.debug("  - No icon specified");
                }
                ResourceLocation startWorkerUnitId = null;
                if (root.has("start_worker_unit")) {
                    String sw = GsonHelper.m_13906_((JsonObject)root, (String)"start_worker_unit");
                    ReignOfNether.LOGGER.debug("  - Parsing start_worker_unit: '{}'", (Object)sw);
                    ResourceLocation rl = ResourceLocation.m_135820_((String)sw);
                    if (rl != null) {
                        startWorkerUnitId = rl;
                        ReignOfNether.LOGGER.debug("  - Start worker unit resolved to: {}", (Object)rl);
                    } else {
                        ReignOfNether.LOGGER.warn("  - Invalid start_worker_unit ResourceLocation: '{}'", (Object)sw);
                    }
                } else {
                    ReignOfNether.LOGGER.debug("  - No start_worker_unit specified");
                }
                ResourceLocation startCapitolBuildingId = null;
                if (root.has("start_capitol_building")) {
                    String sb = GsonHelper.m_13906_((JsonObject)root, (String)"start_capitol_building");
                    ReignOfNether.LOGGER.debug("  - Parsing start_capitol_building: '{}'", (Object)sb);
                    ResourceLocation rl = ResourceLocation.m_135820_((String)sb);
                    if (rl != null) {
                        startCapitolBuildingId = rl;
                        ReignOfNether.LOGGER.debug("  - Start capitol building resolved to: {}", (Object)rl);
                    } else {
                        ReignOfNether.LOGGER.warn("  - Invalid start_capitol_building ResourceLocation: '{}'", (Object)sb);
                    }
                } else {
                    ReignOfNether.LOGGER.debug("  - No start_capitol_building specified");
                }
                FactionType type = new FactionType(id, displayName, primaryColor, secondaryColor, propsBuilder.build(), icon, startWorkerUnitId, startCapitolBuildingId);
                FactionRegistry.registerOrUpdate(type);
                ++count;
            }
            catch (Exception ex) {
                ++failed;
                ReignOfNether.LOGGER.error("Failed to load faction {} from datapack: {}", (Object)id, (Object)ex.getMessage());
                ReignOfNether.LOGGER.error("Stack trace:", (Throwable)ex);
            }
        }
        ReignOfNether.LOGGER.info("=== FACTION DATAPACK LOADING COMPLETE ===");
        ReignOfNether.LOGGER.info("Successfully loaded: {}, Failed: {}", (Object)count, (Object)failed);
    }

    private static int parseColor(String s) {
        String hex = s.startsWith("#") ? s.substring(1) : s;
        int value = (int)Long.parseLong(hex, 16);
        if (hex.length() <= 6) {
            return 0xFF000000 | value;
        }
        return value;
    }

    private static ResourceLocation parseTextureResource(String s) {
        String rest;
        int slash;
        if (s == null || s.isEmpty()) {
            return null;
        }
        if (s.startsWith("assets/") && (slash = (rest = s.substring("assets/".length())).indexOf(47)) > 0) {
            String ns = rest.substring(0, slash);
            String path = rest.substring(slash + 1);
            return new ResourceLocation(ns, path);
        }
        return ResourceLocation.m_135820_((String)s);
    }
}

