/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.datapack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.building.production.dynamic.DynamicProductionItem;
import com.solegendary.reignofnether.building.production.dynamic.DynamicProductionProperties;
import com.solegendary.reignofnether.building.production.dynamic.DynamicProductionRegistry;
import com.solegendary.reignofnether.building.production.dynamic.ProductionType;
import com.solegendary.reignofnether.faction.FactionRegistry;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceRegistry;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ProductionDataLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();

    public ProductionDataLoader() {
        super(GSON, "reignofnether/productions");
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> elements, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller profiler) {
        ReignOfNether.LOGGER.info("=== PRODUCTION DATAPACK LOADING START ===");
        ReignOfNether.LOGGER.info("Found {} production file(s) to process", (Object)elements.size());
        int count = 0;
        int failed = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry : elements.entrySet()) {
            ResourceLocation id = entry.getKey();
            ReignOfNether.LOGGER.info("Processing production file: {}", (Object)id);
            try {
                ProductionType type;
                String factionStr;
                if (!entry.getValue().isJsonObject()) {
                    ReignOfNether.LOGGER.warn("Skipping production {}: root is not an object", (Object)id);
                    ++failed;
                    continue;
                }
                JsonObject root = entry.getValue().getAsJsonObject();
                ReignOfNether.LOGGER.debug("  - JSON parsed successfully");
                String displayName = GsonHelper.m_13851_((JsonObject)root, (String)"display_name", (String)id.m_135815_());
                ReignOfNether.LOGGER.debug("  - Display name: '{}'", (Object)displayName);
                String string = factionStr = root.has("faction") ? GsonHelper.m_13906_((JsonObject)root, (String)"faction") : "";
                if (!factionStr.isEmpty()) {
                    ReignOfNether.LOGGER.debug("  - Faction string: '{}'", (Object)factionStr);
                } else {
                    ReignOfNether.LOGGER.debug("  - No faction specified");
                }
                String typeStr = GsonHelper.m_13851_((JsonObject)root, (String)"type", (String)ProductionType.UNIT.name());
                ReignOfNether.LOGGER.debug("  - Production type string: '{}'", (Object)typeStr);
                FactionType faction = null;
                if (!factionStr.isEmpty()) {
                    ResourceLocation factionId = ResourceLocation.m_135820_((String)factionStr);
                    if (factionId == null) {
                        ReignOfNether.LOGGER.error("  - Invalid faction ResourceLocation: '{}'", (Object)factionStr);
                        ++failed;
                        continue;
                    }
                    faction = FactionRegistry.getFaction(factionId);
                    if (faction == null) {
                        ReignOfNether.LOGGER.error("  - Unknown faction: {} - Faction must be loaded before productions", (Object)factionId);
                        ReignOfNether.LOGGER.error("  - Available factions: {}", FactionRegistry.getAllFactions().stream().map(f -> f.getId().toString()).toList());
                        ++failed;
                        continue;
                    }
                    ReignOfNether.LOGGER.debug("  - Faction resolved: {}", (Object)faction.getDisplayName());
                }
                try {
                    type = ProductionType.valueOf(typeStr.toUpperCase());
                    ReignOfNether.LOGGER.debug("  - Production type resolved: {}", (Object)type);
                }
                catch (IllegalArgumentException ex) {
                    ReignOfNether.LOGGER.warn("  - Unknown production type '{}', defaulting to UNIT", (Object)typeStr);
                    type = ProductionType.UNIT;
                }
                if (!root.has("result") || !root.get("result").isJsonObject()) {
                    ReignOfNether.LOGGER.error("  - Missing or invalid 'result' section");
                    ++failed;
                    continue;
                }
                JsonObject resultObj = root.getAsJsonObject("result");
                String resultItemStr = GsonHelper.m_13906_((JsonObject)resultObj, (String)"item");
                ReignOfNether.LOGGER.debug("  - Result item string: '{}'", (Object)resultItemStr);
                int resultCount = GsonHelper.m_13824_((JsonObject)resultObj, (String)"count", (int)1);
                ReignOfNether.LOGGER.debug("  - Result count: {}", (Object)resultCount);
                ResourceLocation resultItemId = ResourceLocation.m_135820_((String)resultItemStr);
                if (resultItemId == null) {
                    ReignOfNether.LOGGER.error("  - Failed to parse result item as ResourceLocation: '{}'", (Object)resultItemStr);
                    ++failed;
                    continue;
                }
                Item resultItem = (Item)BuiltInRegistries.f_257033_.m_7745_(resultItemId);
                if (resultItem == null) {
                    ReignOfNether.LOGGER.error("  - Unknown result item: {} - Item is not registered in the game", (Object)resultItemId);
                    ++failed;
                    continue;
                }
                ReignOfNether.LOGGER.debug("  - Result item found: {}", (Object)resultItem.m_5524_());
                ItemStack resultStack = new ItemStack((ItemLike)resultItem, Math.max(1, resultCount));
                HashMap<DynamicResourceType, Integer> costs = new HashMap<DynamicResourceType, Integer>();
                if (root.has("costs") && root.get("costs").isJsonObject()) {
                    JsonObject costsObj = root.getAsJsonObject("costs");
                    ReignOfNether.LOGGER.debug("  - Processing {} cost entries", (Object)costsObj.size());
                    for (Object key : costsObj.keySet()) {
                        ResourceLocation resId = ResourceLocation.m_135820_((String)key);
                        if (resId == null) {
                            ReignOfNether.LOGGER.warn("  - Invalid resource ResourceLocation in costs: '{}'", key);
                            continue;
                        }
                        DynamicResourceType dynRes = DynamicResourceRegistry.getResourceType(resId);
                        if (dynRes == null) {
                            ReignOfNether.LOGGER.warn("  - Unknown resource {} in costs \u2014 skipping cost entry", key);
                            continue;
                        }
                        int amount = GsonHelper.m_13927_((JsonObject)costsObj, (String)key);
                        costs.put(dynRes, amount);
                        ReignOfNether.LOGGER.debug("  - Added cost: {} x{}", (Object)dynRes.getDisplayName(), (Object)amount);
                    }
                } else {
                    ReignOfNether.LOGGER.debug("  - No costs section found");
                }
                ReignOfNether.LOGGER.debug("  - Parsing properties section");
                DynamicProductionProperties properties = ProductionDataLoader.parseProductionProperties(root.has("properties") ? root.getAsJsonObject("properties") : null, id);
                ArrayList<ResourceLocation> requirements = new ArrayList<ResourceLocation>();
                if (root.has("requirements") && root.get("requirements").isJsonArray()) {
                    Object key;
                    ReignOfNether.LOGGER.debug("  - Processing requirements");
                    key = root.getAsJsonArray("requirements").iterator();
                    while (key.hasNext()) {
                        JsonElement el = (JsonElement)key.next();
                        ResourceLocation req = ResourceLocation.m_135820_((String)el.getAsString());
                        if (req != null) {
                            requirements.add(req);
                            ReignOfNether.LOGGER.debug("  - Added requirement: {}", (Object)req);
                            continue;
                        }
                        ReignOfNether.LOGGER.warn("  - Invalid requirement ResourceLocation: '{}'", (Object)el.getAsString());
                    }
                } else {
                    ReignOfNether.LOGGER.debug("  - No requirements section found");
                }
                DynamicProductionItem item = new DynamicProductionItem(id, displayName, faction, type, resultStack, costs, properties, requirements);
                DynamicProductionRegistry.registerOrUpdate(item);
                ++count;
            }
            catch (Exception ex) {
                ++failed;
                ReignOfNether.LOGGER.error("Failed to load production {} from datapack: {}", (Object)id, (Object)ex.getMessage());
                ReignOfNether.LOGGER.error("Stack trace:", (Throwable)ex);
            }
        }
        ReignOfNether.LOGGER.info("=== PRODUCTION DATAPACK LOADING COMPLETE ===");
        ReignOfNether.LOGGER.info("Successfully loaded: {}, Failed: {}", (Object)count, (Object)failed);
    }

    private static DynamicProductionProperties parseProductionProperties(JsonObject p, ResourceLocation id) {
        if (p == null) {
            ReignOfNether.LOGGER.debug("  - No properties section found for {}, using defaults", (Object)id);
            return DynamicProductionProperties.defaultProperties();
        }
        ReignOfNether.LOGGER.debug("  - Found {} properties to parse", (Object)p.size());
        DynamicProductionProperties.Builder b = DynamicProductionProperties.builder();
        if (p.has("production_time")) {
            b.productionTime(GsonHelper.m_13927_((JsonObject)p, (String)"production_time"));
        }
        if (p.has("queue_limit")) {
            b.queueLimit(GsonHelper.m_13927_((JsonObject)p, (String)"queue_limit"));
        }
        if (p.has("batch_production")) {
            b.batchProduction(GsonHelper.m_13912_((JsonObject)p, (String)"batch_production"));
        }
        if (p.has("batch_size")) {
            b.batchSize(GsonHelper.m_13927_((JsonObject)p, (String)"batch_size"));
        }
        if (p.has("resource_efficiency")) {
            b.resourceEfficiency(GsonHelper.m_13915_((JsonObject)p, (String)"resource_efficiency"));
        }
        if (p.has("requires_continuous_resources")) {
            b.requiresContinuousResources(GsonHelper.m_13912_((JsonObject)p, (String)"requires_continuous_resources"));
        }
        if (p.has("refunds_on_cancel")) {
            b.refundsOnCancel(GsonHelper.m_13912_((JsonObject)p, (String)"refunds_on_cancel"));
        }
        if (p.has("refund_percentage")) {
            b.refundPercentage(GsonHelper.m_13915_((JsonObject)p, (String)"refund_percentage"));
        }
        if (p.has("requires_workers")) {
            b.requiresWorkers(GsonHelper.m_13912_((JsonObject)p, (String)"requires_workers"));
        }
        if (p.has("worker_count")) {
            b.workerCount(GsonHelper.m_13927_((JsonObject)p, (String)"worker_count"));
        }
        if (p.has("worker_efficiency_bonus")) {
            b.workerEfficiencyBonus(GsonHelper.m_13915_((JsonObject)p, (String)"worker_efficiency_bonus"));
        }
        if (p.has("requires_specific_building")) {
            b.requiresSpecificBuilding(GsonHelper.m_13912_((JsonObject)p, (String)"requires_specific_building"));
        }
        if (p.has("can_be_upgraded")) {
            b.canBeUpgraded(GsonHelper.m_13912_((JsonObject)p, (String)"can_be_upgraded"));
        }
        if (p.has("upgrade_efficiency_bonus")) {
            b.upgradeEfficiencyBonus(GsonHelper.m_13915_((JsonObject)p, (String)"upgrade_efficiency_bonus"));
        }
        if (p.has("faction_efficiency_bonus")) {
            b.factionEfficiencyBonus(GsonHelper.m_13915_((JsonObject)p, (String)"faction_efficiency_bonus"));
        }
        if (p.has("requires_faction_tech")) {
            b.requiresFactionTech(GsonHelper.m_13912_((JsonObject)p, (String)"requires_faction_tech"));
        }
        if (p.has("shareable_between_factions")) {
            b.shareableBetweenFactions(GsonHelper.m_13912_((JsonObject)p, (String)"shareable_between_factions"));
        }
        if (p.has("priority")) {
            b.priority(GsonHelper.m_13927_((JsonObject)p, (String)"priority"));
        }
        if (p.has("pausable_production")) {
            b.pausableProduction(GsonHelper.m_13912_((JsonObject)p, (String)"pausable_production"));
        }
        if (p.has("visible_to_enemies")) {
            b.visibleToEnemies(GsonHelper.m_13912_((JsonObject)p, (String)"visible_to_enemies"));
        }
        if (p.has("counts_toward_population")) {
            b.countsTowardPopulation(GsonHelper.m_13912_((JsonObject)p, (String)"counts_toward_population"));
        }
        return b.build();
    }
}

