/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.datapack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.faction.FactionRegistry;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceProperties;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceRegistry;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceType;
import com.solegendary.reignofnether.resources.dynamic.ResourceCategory;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;

public class ResourceDataLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();

    public ResourceDataLoader() {
        super(GSON, "reignofnether/resources");
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> elements, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller profiler) {
        ReignOfNether.LOGGER.info("=== RESOURCE DATAPACK LOADING START ===");
        ReignOfNether.LOGGER.info("Found {} resource file(s) to process", (Object)elements.size());
        int count = 0;
        int failed = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry : elements.entrySet()) {
            ResourceLocation id = entry.getKey();
            ReignOfNether.LOGGER.info("Processing resource file: {}", (Object)id);
            try {
                ResourceCategory category;
                String factionStr;
                if (!entry.getValue().isJsonObject()) {
                    ReignOfNether.LOGGER.warn("Skipping resource {}: root is not an object", (Object)id);
                    ++failed;
                    continue;
                }
                JsonObject root = entry.getValue().getAsJsonObject();
                ReignOfNether.LOGGER.debug("  - JSON parsed successfully");
                String displayName = GsonHelper.m_13851_((JsonObject)root, (String)"display_name", (String)id.m_135815_());
                ReignOfNether.LOGGER.debug("  - Display name: '{}'", (Object)displayName);
                String itemStr = GsonHelper.m_13906_((JsonObject)root, (String)"item");
                ReignOfNether.LOGGER.debug("  - Item string: '{}'", (Object)itemStr);
                String string = factionStr = root.has("faction") ? GsonHelper.m_13906_((JsonObject)root, (String)"faction") : "";
                if (!factionStr.isEmpty()) {
                    ReignOfNether.LOGGER.debug("  - Faction string: '{}'", (Object)factionStr);
                } else {
                    ReignOfNether.LOGGER.debug("  - No faction specified");
                }
                String categoryStr = GsonHelper.m_13851_((JsonObject)root, (String)"category", (String)ResourceCategory.BASIC.name());
                ReignOfNether.LOGGER.debug("  - Category string: '{}'", (Object)categoryStr);
                ResourceLocation itemKey = ResourceLocation.m_135820_((String)itemStr);
                if (itemKey == null) {
                    ReignOfNether.LOGGER.error("  - Failed to parse item as ResourceLocation: '{}'", (Object)itemStr);
                    ++failed;
                    continue;
                }
                ReignOfNether.LOGGER.debug("  - Item ResourceLocation: {}", (Object)itemKey);
                Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemKey);
                if (item == null) {
                    ReignOfNether.LOGGER.error("  - Unknown item: {} - Item is not registered in the game", (Object)itemKey);
                    ReignOfNether.LOGGER.error("  - Make sure the item exists (from vanilla or another mod)");
                    ++failed;
                    continue;
                }
                ReignOfNether.LOGGER.debug("  - Item found: {}", (Object)item.m_5524_());
                FactionType faction = null;
                if (!factionStr.isEmpty()) {
                    ResourceLocation factionId = ResourceLocation.m_135820_((String)factionStr);
                    if (factionId == null) {
                        ReignOfNether.LOGGER.error("  - Invalid faction ResourceLocation: '{}'", (Object)factionStr);
                        ++failed;
                        continue;
                    }
                    faction = FactionRegistry.getFaction(factionId);
                    if (faction == null) {
                        ReignOfNether.LOGGER.error("  - Unknown faction: {} - Faction must be loaded before resources", (Object)factionId);
                        ReignOfNether.LOGGER.error("  - Available factions: {}", FactionRegistry.getAllFactions().stream().map(f -> f.getId().toString()).toList());
                        ++failed;
                        continue;
                    }
                    ReignOfNether.LOGGER.debug("  - Faction resolved: {}", (Object)faction.getDisplayName());
                }
                try {
                    category = ResourceCategory.valueOf(categoryStr.toUpperCase());
                    ReignOfNether.LOGGER.debug("  - Category resolved: {}", (Object)category);
                }
                catch (IllegalArgumentException ex) {
                    ReignOfNether.LOGGER.warn("  - Unknown category '{}', defaulting to BASIC", (Object)categoryStr);
                    category = ResourceCategory.BASIC;
                }
                ReignOfNether.LOGGER.debug("  - Parsing properties section");
                DynamicResourceProperties properties = ResourceDataLoader.parseResourceProperties(root.has("properties") ? root.getAsJsonObject("properties") : null, id);
                DynamicResourceType type = new DynamicResourceType(id, displayName, item, faction, category, properties);
                DynamicResourceRegistry.registerOrUpdate(type);
                ++count;
            }
            catch (Exception ex) {
                ++failed;
                ReignOfNether.LOGGER.error("Failed to load resource {} from datapack: {}", (Object)id, (Object)ex.getMessage());
                ReignOfNether.LOGGER.error("Stack trace:", (Throwable)ex);
            }
        }
        ReignOfNether.LOGGER.info("=== RESOURCE DATAPACK LOADING COMPLETE ===");
        ReignOfNether.LOGGER.info("Successfully loaded: {}, Failed: {}", (Object)count, (Object)failed);
    }

    private static DynamicResourceProperties parseResourceProperties(JsonObject p, ResourceLocation id) {
        if (p == null) {
            ReignOfNether.LOGGER.debug("  - No properties section found for {}, using defaults", (Object)id);
            return DynamicResourceProperties.defaultProperties();
        }
        ReignOfNether.LOGGER.debug("  - Found {} properties to parse", (Object)p.size());
        DynamicResourceProperties.Builder b = DynamicResourceProperties.builder();
        if (p.has("base_value")) {
            b.baseValue(GsonHelper.m_13927_((JsonObject)p, (String)"base_value"));
        }
        if (p.has("market_volatility")) {
            b.marketVolatility(GsonHelper.m_13915_((JsonObject)p, (String)"market_volatility"));
        }
        if (p.has("tradeable")) {
            b.tradeable(GsonHelper.m_13912_((JsonObject)p, (String)"tradeable"));
        }
        if (p.has("max_stack_size")) {
            b.maxStackSize(GsonHelper.m_13927_((JsonObject)p, (String)"max_stack_size"));
        }
        if (p.has("stack_size")) {
            b.stackSize(GsonHelper.m_13927_((JsonObject)p, (String)"stack_size"));
        }
        if (p.has("production_rate")) {
            b.productionRate(GsonHelper.m_13915_((JsonObject)p, (String)"production_rate"));
        }
        if (p.has("renewable")) {
            b.renewable(GsonHelper.m_13912_((JsonObject)p, (String)"renewable"));
        }
        if (p.has("depletion_time")) {
            b.depletionTime(GsonHelper.m_13927_((JsonObject)p, (String)"depletion_time"));
        }
        if (p.has("requires_workers")) {
            b.requiresWorkers(GsonHelper.m_13912_((JsonObject)p, (String)"requires_workers"));
        }
        if (p.has("requires_special_storage")) {
            b.requiresSpecialStorage(GsonHelper.m_13912_((JsonObject)p, (String)"requires_special_storage"));
        }
        if (p.has("decay_rate")) {
            b.decayRate(GsonHelper.m_13927_((JsonObject)p, (String)"decay_rate"));
        }
        if (p.has("stackable")) {
            b.stackable(GsonHelper.m_13912_((JsonObject)p, (String)"stackable"));
        }
        if (p.has("shareable_between_factions")) {
            b.shareableBetweenFactions(GsonHelper.m_13912_((JsonObject)p, (String)"shareable_between_factions"));
        }
        if (p.has("faction_production_bonus")) {
            b.factionProductionBonus(GsonHelper.m_13915_((JsonObject)p, (String)"faction_production_bonus"));
        }
        if (p.has("requires_faction_technology")) {
            b.requiresFactionTechnology(GsonHelper.m_13912_((JsonObject)p, (String)"requires_faction_technology"));
        }
        if (p.has("consumed_on_use")) {
            b.consumedOnUse(GsonHelper.m_13912_((JsonObject)p, (String)"consumed_on_use"));
        }
        if (p.has("transport_cost")) {
            b.transportCost(GsonHelper.m_13927_((JsonObject)p, (String)"transport_cost"));
        }
        if (p.has("visible_to_enemies")) {
            b.visibleToEnemies(GsonHelper.m_13912_((JsonObject)p, (String)"visible_to_enemies"));
        }
        return b.build();
    }
}

