/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.datapack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.faction.FactionRegistry;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.unit.UnitProperties;
import com.solegendary.reignofnether.unit.UnitRegistry;
import com.solegendary.reignofnether.unit.UnitType;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class UnitDataLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();

    public UnitDataLoader() {
        super(GSON, "reignofnether/units");
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> elements, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller profiler) {
        ReignOfNether.LOGGER.info("=== UNIT DATAPACK LOADING START ===");
        ReignOfNether.LOGGER.info("Found {} unit file(s) to process", (Object)elements.size());
        int count = 0;
        int failed = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry : elements.entrySet()) {
            ResourceLocation id = entry.getKey();
            ReignOfNether.LOGGER.info("Processing unit file: {}", (Object)id);
            try {
                UnitType<LivingEntity> unitType;
                String factionStr;
                if (!entry.getValue().isJsonObject()) {
                    ReignOfNether.LOGGER.warn("Skipping unit {}: root is not an object", (Object)id);
                    ++failed;
                    continue;
                }
                JsonObject root = entry.getValue().getAsJsonObject();
                ReignOfNether.LOGGER.debug("  - JSON parsed successfully");
                String displayName = GsonHelper.m_13851_((JsonObject)root, (String)"display_name", (String)id.m_135815_());
                ReignOfNether.LOGGER.debug("  - Display name: '{}'", (Object)displayName);
                String entityTypeStr = GsonHelper.m_13906_((JsonObject)root, (String)"entity_type");
                ReignOfNether.LOGGER.debug("  - Entity type string: '{}'", (Object)entityTypeStr);
                String string = factionStr = root.has("faction") ? GsonHelper.m_13906_((JsonObject)root, (String)"faction") : "";
                if (!factionStr.isEmpty()) {
                    ReignOfNether.LOGGER.debug("  - Faction string: '{}'", (Object)factionStr);
                } else {
                    ReignOfNether.LOGGER.debug("  - No faction specified");
                }
                ResourceLocation etKey = ResourceLocation.m_135820_((String)entityTypeStr);
                if (etKey == null) {
                    ReignOfNether.LOGGER.error("  - Failed to parse entity_type as ResourceLocation: '{}'", (Object)entityTypeStr);
                    ++failed;
                    continue;
                }
                ReignOfNether.LOGGER.debug("  - Entity type ResourceLocation: {}", (Object)etKey);
                EntityType rawEntityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(etKey);
                if (rawEntityType == null) {
                    ReignOfNether.LOGGER.error("  - Unknown entity_type: {} - Entity is not registered in the game", (Object)etKey);
                    ReignOfNether.LOGGER.error("  - Make sure the entity type exists (from vanilla or another mod)");
                    ++failed;
                    continue;
                }
                ReignOfNether.LOGGER.debug("  - Entity type found: {}", (Object)rawEntityType.m_20675_());
                FactionType faction = null;
                if (!factionStr.isEmpty()) {
                    ResourceLocation factionId = ResourceLocation.m_135820_((String)factionStr);
                    if (factionId == null) {
                        ReignOfNether.LOGGER.error("  - Invalid faction ResourceLocation: '{}'", (Object)factionStr);
                        ++failed;
                        continue;
                    }
                    faction = FactionRegistry.getFaction(factionId);
                    if (faction == null) {
                        ReignOfNether.LOGGER.error("  - Unknown faction: {} - Faction must be loaded before units", (Object)factionId);
                        ReignOfNether.LOGGER.error("  - Available factions: {}", FactionRegistry.getAllFactions().stream().map(f -> f.getId().toString()).toList());
                        ++failed;
                        continue;
                    }
                    ReignOfNether.LOGGER.debug("  - Faction resolved: {}", (Object)faction.getDisplayName());
                }
                ReignOfNether.LOGGER.debug("  - Parsing cost section");
                ResourceCost cost = UnitDataLoader.parseCost(root, id);
                if (cost != null) {
                    ReignOfNether.LOGGER.debug("  - Cost: food={}, wood={}, ore={}, ticks={}, population={}", (Object)cost.food, (Object)cost.wood, (Object)cost.ore, (Object)cost.ticks, (Object)cost.population);
                }
                ReignOfNether.LOGGER.debug("  - Parsing properties section");
                UnitProperties properties = UnitDataLoader.parseUnitProperties(root.has("properties") ? root.getAsJsonObject("properties") : null, id);
                Supplier supplier = () -> rawEntityType;
                UnitType<LivingEntity> typed = unitType = new UnitType<LivingEntity>(id, displayName, supplier, faction, cost, properties, LivingEntity.class);
                UnitRegistry.registerOrUpdate(typed);
                ++count;
                ReignOfNether.LOGGER.info("  - Properties: worker={}, attacker={}, ranged={}", (Object)(properties != null && properties.isWorker() ? 1 : 0), (Object)(properties != null && properties.isAttacker() ? 1 : 0), (Object)(properties != null && properties.isRanged() ? 1 : 0));
            }
            catch (Exception ex) {
                ++failed;
                ReignOfNether.LOGGER.error("Failed to load unit {} from datapack: {}", (Object)id, (Object)ex.getMessage());
                ReignOfNether.LOGGER.error("Stack trace:", (Throwable)ex);
            }
        }
        ReignOfNether.LOGGER.info("=== UNIT DATAPACK LOADING COMPLETE ===");
        ReignOfNether.LOGGER.info("Successfully loaded: {}, Failed: {}", (Object)count, (Object)failed);
    }

    private static ResourceCost parseCost(JsonObject root, ResourceLocation id) {
        if (!root.has("cost") || !root.get("cost").isJsonObject()) {
            ReignOfNether.LOGGER.debug("  - No cost section found for {}", (Object)id);
            return null;
        }
        JsonObject c = root.getAsJsonObject("cost");
        int food = GsonHelper.m_13824_((JsonObject)c, (String)"food", (int)0);
        int wood = GsonHelper.m_13824_((JsonObject)c, (String)"wood", (int)0);
        int ore = GsonHelper.m_13824_((JsonObject)c, (String)"ore", (int)0);
        int ticks = GsonHelper.m_13824_((JsonObject)c, (String)"ticks", (int)0);
        int population = GsonHelper.m_13824_((JsonObject)c, (String)"population", (int)0);
        int seconds = Math.max(0, ticks / 20);
        return ResourceCost.Unit(food, wood, ore, seconds, population);
    }

    private static UnitProperties parseUnitProperties(JsonObject p, ResourceLocation id) {
        if (p == null) {
            ReignOfNether.LOGGER.debug("  - No properties section found for {}, using defaults", (Object)id);
            return UnitProperties.defaultProperties();
        }
        ReignOfNether.LOGGER.debug("  - Found {} properties to parse", (Object)p.size());
        UnitProperties.Builder b = UnitProperties.builder();
        if (p.has("worker")) {
            b.worker(GsonHelper.m_13912_((JsonObject)p, (String)"worker"));
        }
        if (p.has("attacker")) {
            b.attacker(GsonHelper.m_13912_((JsonObject)p, (String)"attacker"));
        }
        if (p.has("ranged")) {
            b.ranged(GsonHelper.m_13912_((JsonObject)p, (String)"ranged"));
        }
        if (p.has("flying")) {
            b.flying(GsonHelper.m_13912_((JsonObject)p, (String)"flying"));
        }
        if (p.has("hero")) {
            b.hero(GsonHelper.m_13912_((JsonObject)p, (String)"hero"));
        }
        if (p.has("move_speed_multiplier")) {
            b.moveSpeedMultiplier(GsonHelper.m_13915_((JsonObject)p, (String)"move_speed_multiplier"));
        }
        if (p.has("can_climb_ladders")) {
            b.canClimbLadders(GsonHelper.m_13912_((JsonObject)p, (String)"can_climb_ladders"));
        }
        if (p.has("can_destroy_terrain")) {
            b.canDestroyTerrain(GsonHelper.m_13912_((JsonObject)p, (String)"can_destroy_terrain"));
        }
        if (p.has("can_swim")) {
            b.canSwim(GsonHelper.m_13912_((JsonObject)p, (String)"can_swim"));
        }
        if (p.has("build_time")) {
            b.buildTime(GsonHelper.m_13927_((JsonObject)p, (String)"build_time"));
        }
        if (p.has("population_cost")) {
            b.populationCost(GsonHelper.m_13927_((JsonObject)p, (String)"population_cost"));
        }
        if (p.has("population_provided")) {
            b.populationProvided(GsonHelper.m_13927_((JsonObject)p, (String)"population_provided"));
        }
        if (p.has("has_special_abilities")) {
            b.hasSpecialAbilities(GsonHelper.m_13912_((JsonObject)p, (String)"has_special_abilities"));
        }
        if (p.has("can_garrison")) {
            b.canGarrison(GsonHelper.m_13912_((JsonObject)p, (String)"can_garrison"));
        }
        if (p.has("can_mount")) {
            b.canMount(GsonHelper.m_13912_((JsonObject)p, (String)"can_mount"));
        }
        if (p.has("can_be_revived")) {
            b.canBeRevived(GsonHelper.m_13912_((JsonObject)p, (String)"can_be_revived"));
        }
        if (p.has("aggression_level")) {
            b.aggressionLevel(GsonHelper.m_13915_((JsonObject)p, (String)"aggression_level"));
        }
        if (p.has("defense_level")) {
            b.defenseLevel(GsonHelper.m_13915_((JsonObject)p, (String)"defense_level"));
        }
        if (p.has("vision_range")) {
            b.visionRange(GsonHelper.m_13927_((JsonObject)p, (String)"vision_range"));
        }
        if (p.has("attack_range")) {
            b.attackRange(GsonHelper.m_13927_((JsonObject)p, (String)"attack_range"));
        }
        return b.build();
    }
}

