/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.datapack;

import com.solegendary.reignofnether.ReignOfNether;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class UnitScriptEngine {
    private static final Map<ResourceLocation, ScriptBundle> scriptsByUnitId = new HashMap<ResourceLocation, ScriptBundle>();
    private static boolean LUA_AVAILABLE = false;

    public static void clear() {
        scriptsByUnitId.clear();
    }

    public static void loadScripts(ResourceManager resourceManager) {
        try {
            Class.forName("org.luaj.vm2.LuaValue");
            Class.forName("org.luaj.vm2.lib.jse.JsePlatform");
            LUA_AVAILABLE = true;
        }
        catch (Throwable t) {
            LUA_AVAILABLE = false;
            ReignOfNether.LOGGER.warn("LuaJ not present on classpath. Datapack unit scripts will be disabled.");
            scriptsByUnitId.clear();
            return;
        }
        int loaded = 0;
        for (ResourceLocation rl : resourceManager.m_214159_("reignofnether/scripts/units", p -> p.m_135815_().endsWith(".lua")).keySet()) {
            try {
                String source;
                Optional resOpt = resourceManager.m_213713_(rl);
                if (resOpt.isEmpty()) continue;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(((Resource)resOpt.get()).m_215507_(), StandardCharsets.UTF_8));){
                    String line;
                    StringBuilder sb = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        sb.append(line).append('\n');
                    }
                    source = sb.toString();
                }
                Class<?> jsePlatformCls = Class.forName("org.luaj.vm2.lib.jse.JsePlatform");
                Object globals = jsePlatformCls.getMethod("standardGlobals", new Class[0]).invoke(null, new Object[0]);
                Class<?> luaValueCls = Class.forName("org.luaj.vm2.LuaValue");
                Class<?> luaTableCls = Class.forName("org.luaj.vm2.LuaTable");
                Object chunk = globals.getClass().getMethod("load", String.class, String.class).invoke(globals, source, rl.toString());
                chunk.getClass().getMethod("call", new Class[0]).invoke(chunk, new Object[0]);
                Object api = globals.getClass().getMethod("get", String.class).invoke(globals, "unit_ai");
                boolean isNil = (Boolean)luaValueCls.getMethod("isnil", new Class[0]).invoke(api, new Object[0]);
                if (isNil) continue;
                ScriptBundle bundle = new ScriptBundle();
                Object onTickFn = luaValueCls.getMethod("get", String.class).invoke(api, "on_tick");
                if (!((Boolean)luaValueCls.getMethod("isnil", new Class[0]).invoke(onTickFn, new Object[0])).booleanValue()) {
                    bundle.onTick = ctx -> {
                        try {
                            String[] keys;
                            Object table = luaTableCls.getConstructor(new Class[0]).newInstance(new Object[0]);
                            Method valueOf = luaValueCls.getMethod("valueOf", String.class);
                            Method valueOfBool = luaValueCls.getMethod("valueOf", Boolean.TYPE);
                            Method valueOfDouble = luaValueCls.getMethod("valueOf", Double.TYPE);
                            for (Map.Entry e : ctx.entrySet()) {
                                Object luaV;
                                Object v = e.getValue();
                                if (v instanceof Boolean) {
                                    Boolean b = (Boolean)v;
                                    luaV = valueOfBool.invoke(null, b);
                                } else if (v instanceof Number) {
                                    Number n = (Number)v;
                                    luaV = valueOfDouble.invoke(null, n.doubleValue());
                                } else {
                                    luaV = valueOf.invoke(null, String.valueOf(v));
                                }
                                table.getClass().getMethod("set", String.class, luaValueCls).invoke(table, e.getKey(), luaV);
                            }
                            Object ret = onTickFn.getClass().getMethod("call", luaValueCls).invoke(onTickFn, table);
                            if (!((Boolean)luaValueCls.getMethod("istable", new Class[0]).invoke(ret, new Object[0])).booleanValue()) {
                                return null;
                            }
                            HashMap<String, Object> out = new HashMap<String, Object>();
                            for (String k : keys = new String[]{"cmd", "x", "y", "z", "target", "hold"}) {
                                Object v = ret.getClass().getMethod("get", String.class).invoke(ret, k);
                                boolean vNil = (Boolean)luaValueCls.getMethod("isnil", new Class[0]).invoke(v, new Object[0]);
                                if (vNil) continue;
                                if (((Boolean)luaValueCls.getMethod("isnumber", new Class[0]).invoke(v, new Object[0])).booleanValue()) {
                                    double d = (Double)luaValueCls.getMethod("todouble", new Class[0]).invoke(v, new Object[0]);
                                    out.put(k, d);
                                    continue;
                                }
                                if (((Boolean)luaValueCls.getMethod("isboolean", new Class[0]).invoke(v, new Object[0])).booleanValue()) {
                                    boolean b = (Boolean)luaValueCls.getMethod("toboolean", new Class[0]).invoke(v, new Object[0]);
                                    out.put(k, b);
                                    continue;
                                }
                                String s = (String)luaValueCls.getMethod("tojstring", new Class[0]).invoke(v, new Object[0]);
                                out.put(k, s);
                            }
                            return out;
                        }
                        catch (Throwable ex) {
                            ReignOfNether.LOGGER.error("Lua on_tick error for {}: {}", (Object)rl, (Object)ex.getMessage());
                            return null;
                        }
                    };
                }
                Object onSpawnFn = luaValueCls.getMethod("get", String.class).invoke(api, "on_spawn");
                if (!((Boolean)luaValueCls.getMethod("isnil", new Class[0]).invoke(onSpawnFn, new Object[0])).booleanValue()) {
                    bundle.onSpawn = () -> {
                        try {
                            onSpawnFn.getClass().getMethod("call", new Class[0]).invoke(onSpawnFn, new Object[0]);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    };
                }
                Object onDeathFn = luaValueCls.getMethod("get", String.class).invoke(api, "on_death");
                if (!((Boolean)luaValueCls.getMethod("isnil", new Class[0]).invoke(onDeathFn, new Object[0])).booleanValue()) {
                    bundle.onDeath = () -> {
                        try {
                            onDeathFn.getClass().getMethod("call", new Class[0]).invoke(onDeathFn, new Object[0]);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    };
                }
                String path = rl.m_135815_();
                String unitIdPath = path.substring(path.lastIndexOf(47) + 1).replace(".lua", "");
                ResourceLocation unitId = new ResourceLocation(rl.m_135827_(), unitIdPath);
                scriptsByUnitId.put(unitId, bundle);
                ++loaded;
            }
            catch (Exception ex) {
                ReignOfNether.LOGGER.error("Failed loading unit AI script {}: {}", (Object)rl, (Object)ex.getMessage());
            }
        }
        if (loaded > 0) {
            ReignOfNether.LOGGER.info("Loaded {} unit AI scripts from datapacks", (Object)loaded);
        }
    }

    public static ScriptBundle getScripts(ResourceLocation unitId) {
        return scriptsByUnitId.get(unitId);
    }

    public static class ScriptBundle {
        public Function<Map<String, Object>, Map<String, Object>> onTick;
        public Runnable onSpawn;
        public Runnable onDeath;
    }
}

