/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.faction;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.faction.FactionProperties;
import com.solegendary.reignofnether.faction.FactionRegistry;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.unit.Relationship;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FactionManager {
    private static final Map<ResourceLocation, Map<ResourceLocation, Relationship>> FACTION_RELATIONSHIPS = new ConcurrentHashMap<ResourceLocation, Map<ResourceLocation, Relationship>>();
    private static final Map<ResourceLocation, Set<ResourceLocation>> ALLIANCE_GROUPS = new ConcurrentHashMap<ResourceLocation, Set<ResourceLocation>>();
    private static final Map<String, FactionType> PLAYER_FACTIONS = new ConcurrentHashMap<String, FactionType>();
    public static final int DEFAULT_HEALING_TICKS = 100;
    public static final int MONSTER_HEALING_TICKS = 60;
    public static final int PIGLIN_HEALING_TICKS = 80;

    public static void initializeDefaultRelationships() {
        ReignOfNether.LOGGER.info("Initializing default faction relationships...");
        FactionType villagers = FactionRegistry.getVillagers();
        FactionType monsters = FactionRegistry.getMonsters();
        FactionType piglins = FactionRegistry.getPiglins();
        FactionType none = FactionRegistry.getNone();
        if (villagers != null && monsters != null && piglins != null && none != null) {
            FactionManager.setFactionRelationship(villagers.getId(), monsters.getId(), Relationship.HOSTILE);
            FactionManager.setFactionRelationship(villagers.getId(), piglins.getId(), Relationship.HOSTILE);
            FactionManager.setFactionRelationship(villagers.getId(), none.getId(), Relationship.NEUTRAL);
            FactionManager.setFactionRelationship(monsters.getId(), villagers.getId(), Relationship.HOSTILE);
            FactionManager.setFactionRelationship(monsters.getId(), piglins.getId(), Relationship.HOSTILE);
            FactionManager.setFactionRelationship(monsters.getId(), none.getId(), Relationship.NEUTRAL);
            FactionManager.setFactionRelationship(piglins.getId(), villagers.getId(), Relationship.HOSTILE);
            FactionManager.setFactionRelationship(piglins.getId(), monsters.getId(), Relationship.HOSTILE);
            FactionManager.setFactionRelationship(piglins.getId(), none.getId(), Relationship.NEUTRAL);
            FactionManager.setFactionRelationship(none.getId(), villagers.getId(), Relationship.NEUTRAL);
            FactionManager.setFactionRelationship(none.getId(), monsters.getId(), Relationship.NEUTRAL);
            FactionManager.setFactionRelationship(none.getId(), piglins.getId(), Relationship.NEUTRAL);
            ReignOfNether.LOGGER.info("Default faction relationships initialized");
        } else {
            ReignOfNether.LOGGER.error("Failed to initialize default faction relationships - some factions are null");
        }
    }

    public static void setFactionRelationship(ResourceLocation faction1, ResourceLocation faction2, Relationship relationship) {
        FACTION_RELATIONSHIPS.computeIfAbsent(faction1, k -> new ConcurrentHashMap()).put(faction2, relationship);
        if (!FACTION_RELATIONSHIPS.containsKey(faction2) || !FACTION_RELATIONSHIPS.get(faction2).containsKey(faction1)) {
            FACTION_RELATIONSHIPS.computeIfAbsent(faction2, k -> new ConcurrentHashMap()).put(faction1, relationship);
        }
        ReignOfNether.LOGGER.debug("Set faction relationship: {} -> {} = {}", (Object)faction1, (Object)faction2, (Object)relationship);
    }

    public static Relationship getFactionRelationship(ResourceLocation faction1, ResourceLocation faction2) {
        if (faction1.equals((Object)faction2)) {
            return Relationship.OWNED;
        }
        return ((Map)FACTION_RELATIONSHIPS.getOrDefault(faction1, new HashMap())).getOrDefault(faction2, Relationship.NEUTRAL);
    }

    public static Relationship getFactionRelationship(FactionType faction1, FactionType faction2) {
        if (faction1 == null || faction2 == null) {
            return Relationship.NEUTRAL;
        }
        return FactionManager.getFactionRelationship(faction1.getId(), faction2.getId());
    }

    public static void createAlliance(ResourceLocation ... factions) {
        if (factions.length < 2) {
            return;
        }
        ResourceLocation mainFaction = factions[0];
        HashSet<ResourceLocation> allianceGroup = new HashSet<ResourceLocation>(Arrays.asList(factions));
        ALLIANCE_GROUPS.put(mainFaction, allianceGroup);
        for (ResourceLocation faction1 : factions) {
            for (ResourceLocation faction2 : factions) {
                if (faction1.equals((Object)faction2)) continue;
                FactionManager.setFactionRelationship(faction1, faction2, Relationship.FRIENDLY);
            }
        }
        ReignOfNether.LOGGER.info("Created alliance between factions: {}", (Object)Arrays.toString(factions));
    }

    public static void breakAlliance(ResourceLocation allianceLeader) {
        Set<ResourceLocation> alliance = ALLIANCE_GROUPS.remove(allianceLeader);
        if (alliance != null) {
            for (ResourceLocation faction1 : alliance) {
                for (ResourceLocation faction2 : alliance) {
                    if (faction1.equals((Object)faction2)) continue;
                    FactionManager.setFactionRelationship(faction1, faction2, Relationship.NEUTRAL);
                }
            }
            ReignOfNether.LOGGER.info("Broke alliance led by: {}", (Object)allianceLeader);
        }
    }

    public static boolean areAllied(ResourceLocation faction1, ResourceLocation faction2) {
        return FactionManager.getFactionRelationship(faction1, faction2) == Relationship.FRIENDLY;
    }

    public static boolean areHostile(ResourceLocation faction1, ResourceLocation faction2) {
        return FactionManager.getFactionRelationship(faction1, faction2) == Relationship.HOSTILE;
    }

    public static void setPlayerFaction(String playerName, FactionType faction) {
        if (faction != null) {
            PLAYER_FACTIONS.put(playerName, faction);
            ReignOfNether.LOGGER.debug("Set player {} to faction {}", (Object)playerName, (Object)faction.getDisplayName());
        }
    }

    public static FactionType getPlayerFaction(String playerName) {
        return PLAYER_FACTIONS.get(playerName);
    }

    public static void applyFactionHealing(LivingEntity entity, FactionType faction, Level level) {
        if (faction == null || entity == null || level == null) {
            return;
        }
        FactionProperties properties = faction.getProperties();
        boolean shouldHeal = false;
        int healingTicks = properties.getHealingTicks();
        if (properties.hasNightHealing() && !level.m_46461_()) {
            shouldHeal = entity.f_19797_ % healingTicks == 0;
        } else if (properties.hasNightSourceHealing() && FactionManager.isNearNightSource(entity, level)) {
            shouldHeal = (entity.f_19797_ + healingTicks / 2) % healingTicks == 0;
        } else if (properties.hasNetherHealing() && level.m_46472_() == Level.f_46429_) {
            boolean bl = shouldHeal = entity.f_19797_ % healingTicks == 0;
        }
        if (shouldHeal) {
            entity.m_5634_(properties.getHealingAmount());
        }
    }

    public static void applyFactionImmunities(LivingEntity entity, FactionType faction) {
        if (faction == null || entity == null) {
            return;
        }
        FactionProperties properties = faction.getProperties();
        if (properties.isFireImmune()) {
            entity.m_7311_(0);
        }
    }

    public static float getFactionDamageMultiplier(FactionType faction) {
        if (faction == null) {
            return 1.0f;
        }
        return faction.getProperties().getDamageMultiplier();
    }

    public static float getFactionArmorMultiplier(FactionType faction) {
        if (faction == null) {
            return 1.0f;
        }
        return faction.getProperties().getArmorMultiplier();
    }

    public static float getFactionSpeedMultiplier(FactionType faction) {
        if (faction == null) {
            return 1.0f;
        }
        return faction.getProperties().getSpeedMultiplier();
    }

    public static Set<ResourceLocation> getHostileFactions(ResourceLocation faction) {
        HashSet<ResourceLocation> hostiles = new HashSet<ResourceLocation>();
        Map<ResourceLocation, Relationship> relationships = FACTION_RELATIONSHIPS.get(faction);
        if (relationships != null) {
            relationships.entrySet().stream().filter(entry -> entry.getValue() == Relationship.HOSTILE).forEach(entry -> hostiles.add((ResourceLocation)entry.getKey()));
        }
        return hostiles;
    }

    public static Set<ResourceLocation> getAlliedFactions(ResourceLocation faction) {
        HashSet<ResourceLocation> allies = new HashSet<ResourceLocation>();
        Map<ResourceLocation, Relationship> relationships = FACTION_RELATIONSHIPS.get(faction);
        if (relationships != null) {
            relationships.entrySet().stream().filter(entry -> entry.getValue() == Relationship.FRIENDLY).forEach(entry -> allies.add((ResourceLocation)entry.getKey()));
        }
        return allies;
    }

    private static boolean isNearNightSource(LivingEntity entity, Level level) {
        try {
            Class<?> nightUtils = Class.forName("com.solegendary.reignofnether.time.NightUtils");
            Method method = nightUtils.getMethod("isInRangeOfNightSource", Vec3.class, Boolean.TYPE);
            return (Boolean)method.invoke(null, entity.m_20182_(), level.m_5776_());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void clear() {
        FACTION_RELATIONSHIPS.clear();
        ALLIANCE_GROUPS.clear();
        PLAYER_FACTIONS.clear();
    }
}

