/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.faction;

public class FactionProperties {
    private final boolean hasNightHealing;
    private final boolean hasNightSourceHealing;
    private final boolean hasNetherHealing;
    private final int healingTicks;
    private final float healingAmount;
    private final boolean fireImmune;
    private final boolean drownImmune;
    private final boolean freezeImmune;
    private final boolean poisonImmune;
    private final float damageMultiplier;
    private final float armorMultiplier;
    private final float speedMultiplier;
    private final float resourceProductionMultiplier;
    private final float buildTimeMultiplier;
    private final float recruitmentCostMultiplier;
    private final boolean aggressive;
    private final boolean defensive;
    private final boolean expansionist;
    private final float aiDifficultyMultiplier;

    private FactionProperties(Builder builder) {
        this.hasNightHealing = builder.hasNightHealing;
        this.hasNightSourceHealing = builder.hasNightSourceHealing;
        this.hasNetherHealing = builder.hasNetherHealing;
        this.healingTicks = builder.healingTicks;
        this.healingAmount = builder.healingAmount;
        this.fireImmune = builder.fireImmune;
        this.drownImmune = builder.drownImmune;
        this.freezeImmune = builder.freezeImmune;
        this.poisonImmune = builder.poisonImmune;
        this.damageMultiplier = builder.damageMultiplier;
        this.armorMultiplier = builder.armorMultiplier;
        this.speedMultiplier = builder.speedMultiplier;
        this.resourceProductionMultiplier = builder.resourceProductionMultiplier;
        this.buildTimeMultiplier = builder.buildTimeMultiplier;
        this.recruitmentCostMultiplier = builder.recruitmentCostMultiplier;
        this.aggressive = builder.aggressive;
        this.defensive = builder.defensive;
        this.expansionist = builder.expansionist;
        this.aiDifficultyMultiplier = builder.aiDifficultyMultiplier;
    }

    public static FactionProperties defaultProperties() {
        return new Builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean hasNightHealing() {
        return this.hasNightHealing;
    }

    public boolean hasNightSourceHealing() {
        return this.hasNightSourceHealing;
    }

    public boolean hasNetherHealing() {
        return this.hasNetherHealing;
    }

    public int getHealingTicks() {
        return this.healingTicks;
    }

    public float getHealingAmount() {
        return this.healingAmount;
    }

    public boolean isFireImmune() {
        return this.fireImmune;
    }

    public boolean isDrownImmune() {
        return this.drownImmune;
    }

    public boolean isFreezeImmune() {
        return this.freezeImmune;
    }

    public boolean isPoisonImmune() {
        return this.poisonImmune;
    }

    public float getDamageMultiplier() {
        return this.damageMultiplier;
    }

    public float getArmorMultiplier() {
        return this.armorMultiplier;
    }

    public float getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    public float getResourceProductionMultiplier() {
        return this.resourceProductionMultiplier;
    }

    public float getBuildTimeMultiplier() {
        return this.buildTimeMultiplier;
    }

    public float getRecruitmentCostMultiplier() {
        return this.recruitmentCostMultiplier;
    }

    public boolean isAggressive() {
        return this.aggressive;
    }

    public boolean isDefensive() {
        return this.defensive;
    }

    public boolean isExpansionist() {
        return this.expansionist;
    }

    public float getAiDifficultyMultiplier() {
        return this.aiDifficultyMultiplier;
    }

    public static class Builder {
        private boolean hasNightHealing = false;
        private boolean hasNightSourceHealing = false;
        private boolean hasNetherHealing = false;
        private int healingTicks = 100;
        private float healingAmount = 1.0f;
        private boolean fireImmune = false;
        private boolean drownImmune = false;
        private boolean freezeImmune = false;
        private boolean poisonImmune = false;
        private float damageMultiplier = 1.0f;
        private float armorMultiplier = 1.0f;
        private float speedMultiplier = 1.0f;
        private float resourceProductionMultiplier = 1.0f;
        private float buildTimeMultiplier = 1.0f;
        private float recruitmentCostMultiplier = 1.0f;
        private boolean aggressive = false;
        private boolean defensive = false;
        private boolean expansionist = false;
        private float aiDifficultyMultiplier = 1.0f;

        public Builder nightHealing(boolean enabled) {
            this.hasNightHealing = enabled;
            return this;
        }

        public Builder nightSourceHealing(boolean enabled) {
            this.hasNightSourceHealing = enabled;
            return this;
        }

        public Builder netherHealing(boolean enabled) {
            this.hasNetherHealing = enabled;
            return this;
        }

        public Builder healingTicks(int ticks) {
            this.healingTicks = ticks;
            return this;
        }

        public Builder healingAmount(float amount) {
            this.healingAmount = amount;
            return this;
        }

        public Builder fireImmune(boolean immune) {
            this.fireImmune = immune;
            return this;
        }

        public Builder drownImmune(boolean immune) {
            this.drownImmune = immune;
            return this;
        }

        public Builder freezeImmune(boolean immune) {
            this.freezeImmune = immune;
            return this;
        }

        public Builder poisonImmune(boolean immune) {
            this.poisonImmune = immune;
            return this;
        }

        public Builder damageMultiplier(float multiplier) {
            this.damageMultiplier = multiplier;
            return this;
        }

        public Builder armorMultiplier(float multiplier) {
            this.armorMultiplier = multiplier;
            return this;
        }

        public Builder speedMultiplier(float multiplier) {
            this.speedMultiplier = multiplier;
            return this;
        }

        public Builder resourceProductionMultiplier(float multiplier) {
            this.resourceProductionMultiplier = multiplier;
            return this;
        }

        public Builder buildTimeMultiplier(float multiplier) {
            this.buildTimeMultiplier = multiplier;
            return this;
        }

        public Builder recruitmentCostMultiplier(float multiplier) {
            this.recruitmentCostMultiplier = multiplier;
            return this;
        }

        public Builder aggressive(boolean aggressive) {
            this.aggressive = aggressive;
            return this;
        }

        public Builder defensive(boolean defensive) {
            this.defensive = defensive;
            return this;
        }

        public Builder expansionist(boolean expansionist) {
            this.expansionist = expansionist;
            return this;
        }

        public Builder aiDifficultyMultiplier(float multiplier) {
            this.aiDifficultyMultiplier = multiplier;
            return this;
        }

        public FactionProperties build() {
            return new FactionProperties(this);
        }
    }
}

