/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.fogofwar2;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.solegendary.reignofnether.fogofwar2.FogManager;
import com.solegendary.reignofnether.fogofwar2.anticheat.FogAntiCheat;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.player.PlayerClientEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FogClientEvents {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static boolean warningShown = false;
    private static final int UPDATE_INTERVAL_TICKS = 5;
    private static int tickCounter = 0;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END || FogClientEvents.MC.f_91073_ == null || FogClientEvents.MC.f_91074_ == null) {
            return;
        }
        FogManager.tick();
        if (++tickCounter >= 5) {
            tickCounter = 0;
            if (FogManager.isEnabled()) {
                FogManager.quickUpdate();
            }
        }
        FogManager.onPlayerChanged();
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key evt) {
        if (evt.getAction() == 1 && FogClientEvents.MC.f_91074_ != null && evt.getKey() == Keybindings.getFnum((int)8).key && FogManager.isEnabled() && FogManager.isDebugMode()) {
            FogManager.forceUpdate();
            FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"Fog of war system reset"));
        }
    }

    @SubscribeEvent
    public static void onRenderLivingEntity(RenderLivingEvent.Pre<? extends LivingEntity, ? extends Model> evt) {
        if (FogClientEvents.MC.f_91073_ != null && !FogClientEvents.MC.f_91073_.m_6857_().m_61937_(evt.getEntity().m_20097_())) {
            evt.setCanceled(true);
            return;
        }
        if (!FogManager.isEntityVisible((Entity)evt.getEntity())) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRegisterClientCommands(RegisterClientCommandsEvent evt) {
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-fog2").then(Commands.m_82127_((String)"enable").executes(command -> {
            if (FogClientEvents.MC.f_91074_ == null || !FogClientEvents.MC.f_91074_.m_20310_(4)) {
                return -1;
            }
            if (!PlayerClientEvents.isRTSPlayer) {
                FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"Fog of war is only available in RTS mode"));
                return -1;
            }
            if (!warningShown) {
                FogClientEvents.showFogWarning();
                warningShown = true;
            } else {
                FogClientEvents.enableFog();
            }
            return 1;
        })));
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-fog2").then(Commands.m_82127_((String)"disable").executes(command -> {
            if (FogClientEvents.MC.f_91074_ == null || !FogClientEvents.MC.f_91074_.m_20310_(4)) {
                return -1;
            }
            FogManager.setEnabled(false);
            FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"Improved fog of war disabled"));
            return 1;
        })));
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-fog2").then(Commands.m_82127_((String)"status").executes(command -> {
            if (FogClientEvents.MC.f_91074_ == null) {
                return -1;
            }
            boolean enabled = FogManager.isEnabled();
            String status = enabled ? "enabled" : "disabled";
            FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)("Improved fog of war: " + status)));
            if (enabled && FogManager.isDebugMode()) {
                FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)FogManager.getPerformanceStats()));
                FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)FogAntiCheat.getStatistics()));
            }
            return 1;
        })));
        evt.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-fog2-anticheat").then(Commands.m_82127_((String)"enable").executes(command -> {
            if (FogClientEvents.MC.f_91074_ == null || !FogClientEvents.MC.f_91074_.m_20310_(4)) {
                return -1;
            }
            FogAntiCheat.setEnabled(true);
            FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7aFog of war anti-cheat enabled"));
            return 1;
        }))).then(Commands.m_82127_((String)"disable").executes(command -> {
            if (FogClientEvents.MC.f_91074_ == null || !FogClientEvents.MC.f_91074_.m_20310_(4)) {
                return -1;
            }
            FogAntiCheat.setEnabled(false);
            FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7cFog of war anti-cheat disabled"));
            return 1;
        }))).then(Commands.m_82127_((String)"status").executes(command -> {
            if (FogClientEvents.MC.f_91074_ == null) {
                return -1;
            }
            boolean enabled = FogAntiCheat.isEnabled();
            String status = enabled ? "\u00a7aenabled" : "\u00a7cdisabled";
            FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)("Anti-cheat: " + status)));
            if (enabled && FogManager.isDebugMode()) {
                FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)FogAntiCheat.getStatistics()));
            }
            return 1;
        })));
    }

    private static void showFogWarning() {
        if (FogClientEvents.MC.f_91074_ == null) {
            return;
        }
        FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)""));
        FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"=== IMPROVED FOG OF WAR ===").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
        FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"This is an improved version of the fog of war system."));
        FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)""));
        FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"Key improvements:"));
        FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u2022 Much better performance"));
        FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u2022 Reduced CPU usage"));
        FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u2022 More stable rendering"));
        FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)""));
        FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"Run the command again to confirm and enable."));
        FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)""));
    }

    private static void enableFog() {
        FogManager.setEnabled(true);
        if (FogClientEvents.MC.f_91074_ != null) {
            FogClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"Improved fog of war enabled!"));
        }
    }

    public static void addTemporaryVision(BlockPos pos, int range, int durationTicks) {
        FogManager.addTemporaryVision(pos, range, durationTicks);
    }

    public static void forceUpdate() {
        FogManager.forceUpdate();
    }

    public static boolean isEnabled() {
        return FogManager.isEnabled();
    }
}

