/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.fogofwar2;

import com.solegendary.reignofnether.fogofwar2.VisibilityCache;
import com.solegendary.reignofnether.fogofwar2.VisionTracker;
import com.solegendary.reignofnether.fogofwar2.anticheat.FogAntiCheat;
import com.solegendary.reignofnether.player.PlayerClientEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;

public class FogManager {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final VisibilityCache visibilityCache = new VisibilityCache();
    private static final VisionTracker visionTracker = new VisionTracker();
    private static boolean enabled = false;
    private static String playerName = "";
    public static final float BRIGHT = 1.0f;
    public static final float DARK = 0.35f;
    public static final float EXTRA_DARK = 0.1f;

    public static void initialize() {
        if (FogManager.MC.f_91074_ != null) {
            playerName = FogManager.MC.f_91074_.m_7755_().getString();
        }
        visibilityCache.clear();
        visionTracker.clear();
    }

    public static void setEnabled(boolean enable) {
        if (enabled != enable) {
            enabled = enable;
            if (enable) {
                FogManager.initialize();
                FogManager.forceUpdate();
                if (FogManager.MC.f_91074_ != null) {
                    FogManager.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)("[FOG2] System enabled. Visible chunks: " + visibilityCache.getVisibleChunkCount())));
                }
            } else {
                visibilityCache.clear();
                visionTracker.clear();
                FogAntiCheat.setEnabled(false);
                if (FogManager.MC.f_91074_ != null) {
                    FogManager.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"[FOG2] System disabled"));
                }
            }
        }
    }

    public static boolean isEnabled() {
        return enabled && PlayerClientEvents.isRTSPlayer;
    }

    public static float getPositionBrightness(BlockPos pos) {
        if (!FogManager.isEnabled() || FogManager.MC.f_91073_ == null) {
            return 1.0f;
        }
        if (!FogManager.MC.f_91073_.m_6857_().m_61937_(pos)) {
            return 0.1f;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        float brightness = visibilityCache.getChunkBrightness(chunkPos);
        if (FogAntiCheat.isEnabled() && Math.random() < 1.0E-6) {
            FogAntiCheat.validatePosition(pos);
        }
        return brightness;
    }

    public static boolean isEntityVisible(Entity entity) {
        if (!FogManager.isEnabled() || FogManager.MC.f_91073_ == null) {
            return true;
        }
        if (!FogManager.MC.f_91073_.m_6857_().m_61937_(entity.m_20097_())) {
            return false;
        }
        ChunkPos chunkPos = new ChunkPos(entity.m_20097_());
        return visibilityCache.isChunkVisible(chunkPos);
    }

    public static boolean isChunkVisible(ChunkPos chunkPos) {
        if (!FogManager.isEnabled()) {
            return true;
        }
        return visibilityCache.isChunkVisible(chunkPos);
    }

    public static void updateVision() {
        if (!FogManager.isEnabled()) {
            return;
        }
        visionTracker.clear();
        visionTracker.scanForVisionSources(playerName);
        visibilityCache.updateFromVision(visionTracker);
        if (FogManager.isDebugMode() && FogManager.MC.f_91074_ != null) {
            FogManager.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)("[FOG2] Updated: " + visionTracker.getVisionSourceCount() + " sources, " + visibilityCache.getVisibleChunkCount() + " visible chunks")));
        }
    }

    public static void forceUpdate() {
        if (!FogManager.isEnabled()) {
            return;
        }
        FogManager.updateVision();
        if (FogManager.MC.f_91060_ != null) {
            FogManager.MC.f_91060_.m_109818_();
        }
    }

    public static void addTemporaryVision(BlockPos pos, int range, int durationTicks) {
        if (!FogManager.isEnabled()) {
            return;
        }
        visionTracker.addTemporaryVision(pos, range, durationTicks);
        visibilityCache.updateFromVision(visionTracker);
    }

    public static void tick() {
        if (!FogManager.isEnabled()) {
            return;
        }
        boolean visionsChanged = visionTracker.tickTemporaryVisions();
        if (visionsChanged) {
            visibilityCache.updateFromVision(visionTracker);
        }
        FogAntiCheat.tick();
    }

    public static void quickUpdate() {
        if (!FogManager.isEnabled()) {
            return;
        }
        if (FogManager.MC.f_91074_ != null) {
            String playerName = FogManager.MC.f_91074_.m_7755_().getString();
            visionTracker.scanForVisionSources(playerName);
            visibilityCache.updateFromVision(visionTracker);
        }
    }

    public static void onPlayerChanged() {
        String newPlayerName;
        if (FogManager.MC.f_91074_ != null && !(newPlayerName = FogManager.MC.f_91074_.m_7755_().getString()).equals(playerName)) {
            playerName = newPlayerName;
            if (FogManager.isEnabled()) {
                FogManager.forceUpdate();
            }
        }
    }

    public static String getPerformanceStats() {
        return String.format("Fog of War Stats - Visible Chunks: %d, Vision Sources: %d, Temp Visions: %d", visibilityCache.getVisibleChunkCount(), visionTracker.getVisionSourceCount(), visionTracker.getTemporaryVisionCount());
    }

    public static boolean isDebugMode() {
        return FogManager.MC.f_91074_ != null && FogManager.MC.f_91074_.m_20310_(4);
    }
}

