/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.fogofwar2;

import com.solegendary.reignofnether.fogofwar2.FogManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class FogNetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("reignofnether", "fog2"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    public static void registerPackets() {
        INSTANCE.messageBuilder(FogStatePacket.class, packetId++, NetworkDirection.PLAY_TO_CLIENT).decoder(FogStatePacket::decode).encoder(FogStatePacket::encode).consumerMainThread(FogStatePacket::handle).add();
        INSTANCE.messageBuilder(TemporaryVisionPacket.class, packetId++, NetworkDirection.PLAY_TO_CLIENT).decoder(TemporaryVisionPacket::decode).encoder(TemporaryVisionPacket::encode).consumerMainThread(TemporaryVisionPacket::handle).add();
    }

    public static void syncFogState(ServerPlayer player, boolean enabled) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new FogStatePacket(enabled));
    }

    public static void syncFogStateToAll(boolean enabled) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new FogStatePacket(enabled));
    }

    public static void sendTemporaryVision(BlockPos pos, int range, int duration) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new TemporaryVisionPacket(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), range, duration));
    }

    public static class FogStatePacket {
        private final boolean enabled;

        public FogStatePacket(boolean enabled) {
            this.enabled = enabled;
        }

        public static void encode(FogStatePacket packet, FriendlyByteBuf buf) {
            buf.writeBoolean(packet.enabled);
        }

        public static FogStatePacket decode(FriendlyByteBuf buf) {
            return new FogStatePacket(buf.readBoolean());
        }

        public static void handle(FogStatePacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> FogManager.setEnabled(packet.enabled));
            context.get().setPacketHandled(true);
        }
    }

    public static class TemporaryVisionPacket {
        private final int x;
        private final int y;
        private final int z;
        private final int range;
        private final int duration;

        public TemporaryVisionPacket(int x, int y, int z, int range, int duration) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.range = range;
            this.duration = duration;
        }

        public static void encode(TemporaryVisionPacket packet, FriendlyByteBuf buf) {
            buf.writeInt(packet.x);
            buf.writeInt(packet.y);
            buf.writeInt(packet.z);
            buf.writeInt(packet.range);
            buf.writeInt(packet.duration);
        }

        public static TemporaryVisionPacket decode(FriendlyByteBuf buf) {
            return new TemporaryVisionPacket(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
        }

        public static void handle(TemporaryVisionPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                BlockPos pos = new BlockPos(packet.x, packet.y, packet.z);
                FogManager.addTemporaryVision(pos, packet.range, packet.duration);
            });
            context.get().setPacketHandled(true);
        }
    }
}

