/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.fogofwar2;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.solegendary.reignofnether.fogofwar2.FogNetworkHandler;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FogServerEvents {
    private static boolean enabled = false;

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        Player player = evt.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            FogNetworkHandler.syncFogState(player2, enabled);
        }
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent evt) {
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-fog2").then(Commands.m_82127_((String)"enable").executes(command -> {
            FogServerEvents.setEnabled(true);
            return 1;
        })));
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-fog2").then(Commands.m_82127_((String)"disable").executes(command -> {
            FogServerEvents.setEnabled(false);
            return 1;
        })));
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-fog2").then(Commands.m_82127_((String)"status").executes(command -> {
            String status = enabled ? "enabled" : "disabled";
            ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237113_((String)("Server fog of war: " + status)), false);
            return 1;
        })));
    }

    public static void setEnabled(boolean enable) {
        if (enabled != enable) {
            enabled = enable;
            if (enable) {
                PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.enabled_fog_of_war_improved", true, new Object[0]);
            } else {
                PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.disabled_fog_of_war_improved", true, new Object[0]);
            }
            FogNetworkHandler.syncFogStateToAll(enable);
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }
}

