/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.fogofwar2;

import com.solegendary.reignofnether.fogofwar2.FogManager;
import com.solegendary.reignofnether.fogofwar2.TemporaryVision;
import com.solegendary.reignofnether.fogofwar2.VisionSource;
import com.solegendary.reignofnether.fogofwar2.VisionTracker;
import com.solegendary.reignofnether.fogofwar2.VisionType;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;

public class VisibilityCache {
    private final Set<ChunkPos> visibleChunks = ConcurrentHashMap.newKeySet();
    private final Set<ChunkPos> partiallyVisibleChunks = ConcurrentHashMap.newKeySet();
    private final Set<ChunkPos> previousVisibleChunks = ConcurrentHashMap.newKeySet();
    private final Set<ChunkPos> previousPartiallyVisibleChunks = ConcurrentHashMap.newKeySet();
    private int lastUpdateChunkCount = 0;

    public void clear() {
        this.visibleChunks.clear();
        this.partiallyVisibleChunks.clear();
        this.lastUpdateChunkCount = 0;
    }

    public boolean isChunkVisible(ChunkPos chunkPos) {
        return this.visibleChunks.contains(chunkPos);
    }

    public boolean isChunkPartiallyVisible(ChunkPos chunkPos) {
        return this.partiallyVisibleChunks.contains(chunkPos);
    }

    public float getChunkBrightness(ChunkPos chunkPos) {
        if (this.visibleChunks.contains(chunkPos)) {
            return 1.0f;
        }
        if (this.partiallyVisibleChunks.contains(chunkPos)) {
            return 0.675f;
        }
        return 0.35f;
    }

    public void updateFromVision(VisionTracker visionTracker) {
        this.previousVisibleChunks.clear();
        this.previousVisibleChunks.addAll(this.visibleChunks);
        this.previousPartiallyVisibleChunks.clear();
        this.previousPartiallyVisibleChunks.addAll(this.partiallyVisibleChunks);
        this.visibleChunks.clear();
        this.partiallyVisibleChunks.clear();
        for (VisionSource visionSource : visionTracker.getVisionSources()) {
            this.addVisionCircle(visionSource.getPosition(), visionSource.getRange(), visionSource.getType());
        }
        for (TemporaryVision tempVision : visionTracker.getTemporaryVisions()) {
            this.addVisionCircle(tempVision.getPosition(), tempVision.getRange(), VisionType.NORMAL);
        }
        this.lastUpdateChunkCount = this.visibleChunks.size();
        if (this.hasVisibilityChanged()) {
            this.invalidateChangedChunks();
        }
    }

    private void addVisionCircle(BlockPos center, int range, VisionType visionType) {
        ChunkPos centerChunk = new ChunkPos(center);
        int chunkRange = range / 16 + 1;
        if (visionType == VisionType.EXTENDED) {
            chunkRange = Math.max(chunkRange, 2);
        }
        for (int x = -chunkRange; x <= chunkRange; ++x) {
            for (int z = -chunkRange; z <= chunkRange; ++z) {
                ChunkPos chunkPos = new ChunkPos(centerChunk.f_45578_ + x, centerChunk.f_45579_ + z);
                double chunkCenterDistance = this.getChunkCenterDistance(center, chunkPos);
                if (chunkCenterDistance <= (double)range) {
                    this.visibleChunks.add(chunkPos);
                    continue;
                }
                if (!(chunkCenterDistance <= (double)(range + 16))) continue;
                this.partiallyVisibleChunks.add(chunkPos);
            }
        }
    }

    private double getChunkCenterDistance(BlockPos blockPos, ChunkPos chunkPos) {
        int chunkCenterX = chunkPos.m_45615_().m_123341_() + 8;
        int chunkCenterZ = chunkPos.m_45615_().m_123343_() + 8;
        double dx = blockPos.m_123341_() - chunkCenterX;
        double dz = blockPos.m_123343_() - chunkCenterZ;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public Set<ChunkPos> getVisibleChunks() {
        return Set.copyOf(this.visibleChunks);
    }

    public Set<ChunkPos> getPartiallyVisibleChunks() {
        return Set.copyOf(this.partiallyVisibleChunks);
    }

    public int getVisibleChunkCount() {
        return this.visibleChunks.size();
    }

    private boolean hasVisibilityChanged() {
        return !this.visibleChunks.equals(this.previousVisibleChunks) || !this.partiallyVisibleChunks.equals(this.previousPartiallyVisibleChunks);
    }

    private void invalidateChangedChunks() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91060_ == null) {
            return;
        }
        HashSet<ChunkPos> changedChunks = new HashSet<ChunkPos>();
        for (ChunkPos chunk : this.visibleChunks) {
            if (this.previousVisibleChunks.contains(chunk)) continue;
            changedChunks.add(chunk);
        }
        for (ChunkPos chunk : this.previousVisibleChunks) {
            if (this.visibleChunks.contains(chunk)) continue;
            changedChunks.add(chunk);
        }
        for (ChunkPos chunk : this.partiallyVisibleChunks) {
            if (this.previousPartiallyVisibleChunks.contains(chunk)) continue;
            changedChunks.add(chunk);
        }
        for (ChunkPos chunk : this.previousPartiallyVisibleChunks) {
            if (this.partiallyVisibleChunks.contains(chunk)) continue;
            changedChunks.add(chunk);
        }
        for (ChunkPos chunkPos : changedChunks) {
            int startX = chunkPos.m_45604_();
            int startZ = chunkPos.m_45605_();
            int endX = chunkPos.m_45608_();
            int endZ = chunkPos.m_45609_();
            mc.f_91060_.m_109494_(startX, 0, startZ, endX, 320, endZ);
        }
        if (changedChunks.size() > 0 && FogManager.isDebugMode()) {
            System.out.println("[FOG2] Invalidated " + changedChunks.size() + " chunks for re-rendering");
        }
    }

    public String getPerformanceInfo() {
        return String.format("VisibilityCache: %d visible, %d partial, last update: %d chunks", this.visibleChunks.size(), this.partiallyVisibleChunks.size(), this.lastUpdateChunkCount);
    }
}

