/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.gamerules;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.gamerules.GameruleAction;
import com.solegendary.reignofnether.gamerules.GameruleClientboundPacket;
import com.solegendary.reignofnether.registrars.GameRuleRegistrar;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.network.NetworkEvent;

public class GameruleServerboundPacket {
    GameruleAction action;
    String playerName;
    Long value;

    public static void setLogFalling(boolean logFalling) {
        PacketHandler.INSTANCE.sendToServer((Object)new GameruleServerboundPacket(GameruleAction.SET_LOG_FALLING, "", logFalling ? 1L : 0L));
    }

    public static void setNeutralAggro(boolean neutralAggro) {
        PacketHandler.INSTANCE.sendToServer((Object)new GameruleServerboundPacket(GameruleAction.SET_NEUTRAL_AGGRO, "", neutralAggro ? 1L : 0L));
    }

    public static void setMaxPopulation(long maxPopulation) {
        PacketHandler.INSTANCE.sendToServer((Object)new GameruleServerboundPacket(GameruleAction.SET_MAX_POPULATION, "", maxPopulation));
    }

    public static void setUnitGriefing(boolean unitGriefing) {
        PacketHandler.INSTANCE.sendToServer((Object)new GameruleServerboundPacket(GameruleAction.SET_UNIT_GRIEFING, "", unitGriefing ? 1L : 0L));
    }

    public static void setPlayerGriefing(boolean playerGriefing) {
        PacketHandler.INSTANCE.sendToServer((Object)new GameruleServerboundPacket(GameruleAction.SET_PLAYER_GRIEFING, "", playerGriefing ? 1L : 0L));
    }

    public static void setImprovedPathfinding(boolean improvedPathfinding) {
        PacketHandler.INSTANCE.sendToServer((Object)new GameruleServerboundPacket(GameruleAction.SET_IMPROVED_PATHFINDING, "", improvedPathfinding ? 1L : 0L));
    }

    public static void setGroundYLevel(long groundYLevel) {
        PacketHandler.INSTANCE.sendToServer((Object)new GameruleServerboundPacket(GameruleAction.SET_GROUND_Y_LEVEL, "", groundYLevel));
    }

    public static void setFlyingMaxYLevel(long flyingMaxYLevel) {
        PacketHandler.INSTANCE.sendToServer((Object)new GameruleServerboundPacket(GameruleAction.SET_FLYING_MAX_Y_LEVEL, "", flyingMaxYLevel));
    }

    public static void setAllowBeacons(boolean allowBeacons) {
        PacketHandler.INSTANCE.sendToServer((Object)new GameruleServerboundPacket(GameruleAction.SET_ALLOW_BEACONS, "", allowBeacons ? 1L : 0L));
    }

    public static void setPvpModesOnly(boolean pvpModesOnly) {
        PacketHandler.INSTANCE.sendToServer((Object)new GameruleServerboundPacket(GameruleAction.SET_PVP_MODES_ONLY, "", pvpModesOnly ? 1L : 0L));
    }

    public static void setBeaconWinMinutes(long beaconWinMinutes) {
        PacketHandler.INSTANCE.sendToServer((Object)new GameruleServerboundPacket(GameruleAction.SET_BEACON_WIN_MINUTES, "", beaconWinMinutes));
    }

    public static void setSlantedBuilding(boolean slantedBuilding) {
        PacketHandler.INSTANCE.sendToServer((Object)new GameruleServerboundPacket(GameruleAction.SET_SLANTED_BUILDING, "", slantedBuilding ? 1L : 0L));
    }

    public static void setAllowHeroes(boolean allowHeroes) {
        PacketHandler.INSTANCE.sendToServer((Object)new GameruleServerboundPacket(GameruleAction.SET_ALLOW_HEROES, "", allowHeroes ? 1L : 0L));
    }

    public GameruleServerboundPacket(GameruleAction action, String playerName, Long value) {
        this.action = action;
        this.playerName = playerName;
        this.value = value;
    }

    public GameruleServerboundPacket(FriendlyByteBuf buffer) {
        this.action = (GameruleAction)buffer.m_130066_(GameruleAction.class);
        this.playerName = buffer.m_130277_();
        this.value = buffer.readLong();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.m_130070_(this.playerName);
        buffer.writeLong(this.value.longValue());
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                ReignOfNether.LOGGER.warn("GameruleServerboundPacket: Sender was null");
                success.set(false);
                return;
            }
            if (!player.m_20310_(4)) {
                ReignOfNether.LOGGER.warn("GameruleServerboundPacket: Tried to process packet from " + String.valueOf(player.m_7755_()) + " with insufficient permissions");
                success.set(false);
                return;
            }
            MinecraftServer server = player.m_9236_().m_7654_();
            GameRules gameRules = player.m_9236_().m_46469_();
            boolean booleanValue = this.value == 1L;
            switch (this.action) {
                case SET_LOG_FALLING: {
                    ((GameRules.BooleanValue)gameRules.m_46170_(GameRuleRegistrar.LOG_FALLING)).m_46246_(booleanValue, server);
                    GameruleClientboundPacket.setLogFalling(booleanValue);
                    break;
                }
                case SET_NEUTRAL_AGGRO: {
                    ((GameRules.BooleanValue)gameRules.m_46170_(GameRuleRegistrar.NEUTRAL_AGGRO)).m_46246_(booleanValue, server);
                    GameruleClientboundPacket.setNeutralAggro(booleanValue);
                    break;
                }
                case SET_MAX_POPULATION: {
                    UnitServerEvents.maxPopulation = Math.toIntExact(this.value);
                    ((GameRules.IntegerValue)gameRules.m_46170_(GameRuleRegistrar.MAX_POPULATION)).m_151489_(UnitServerEvents.maxPopulation, server);
                    GameruleClientboundPacket.setMaxPopulation(UnitServerEvents.maxPopulation);
                    break;
                }
                case SET_UNIT_GRIEFING: {
                    ((GameRules.BooleanValue)gameRules.m_46170_(GameRuleRegistrar.DO_UNIT_GRIEFING)).m_46246_(booleanValue, server);
                    GameruleClientboundPacket.setUnitGriefing(booleanValue);
                    break;
                }
                case SET_PLAYER_GRIEFING: {
                    ((GameRules.BooleanValue)gameRules.m_46170_(GameRuleRegistrar.DO_PLAYER_GRIEFING)).m_46246_(booleanValue, server);
                    GameruleClientboundPacket.setPlayerGriefing(booleanValue);
                    break;
                }
                case SET_IMPROVED_PATHFINDING: {
                    ((GameRules.BooleanValue)gameRules.m_46170_(GameRuleRegistrar.IMPROVED_PATHFINDING)).m_46246_(booleanValue, server);
                    for (LivingEntity le : UnitServerEvents.getAllUnits()) {
                        UnitServerEvents.improvedPathfinding = booleanValue;
                        AttributeInstance ai = le.m_21051_(Attributes.f_22277_);
                        if (ai == null) continue;
                        ai.m_22100_((double)Unit.getFollowRange());
                    }
                    GameruleClientboundPacket.setImprovedPathfinding(booleanValue);
                    break;
                }
                case SET_GROUND_Y_LEVEL: {
                    ((GameRules.IntegerValue)gameRules.m_46170_(GameRuleRegistrar.GROUND_Y_LEVEL)).m_151489_(Math.toIntExact(this.value), server);
                    GameruleClientboundPacket.setGroundYLevel(this.value);
                    break;
                }
                case SET_FLYING_MAX_Y_LEVEL: {
                    ((GameRules.IntegerValue)gameRules.m_46170_(GameRuleRegistrar.FLYING_MAX_Y_LEVEL)).m_151489_(Math.toIntExact(this.value), server);
                    GameruleClientboundPacket.setFlyingMaxYLevel(this.value);
                    break;
                }
                case SET_ALLOW_BEACONS: {
                    ((GameRules.BooleanValue)gameRules.m_46170_(GameRuleRegistrar.ALLOW_BEACONS)).m_46246_(booleanValue, server);
                    GameruleClientboundPacket.setAllowBeacons(booleanValue);
                    break;
                }
                case SET_PVP_MODES_ONLY: {
                    ((GameRules.BooleanValue)gameRules.m_46170_(GameRuleRegistrar.PVP_MODES_ONLY)).m_46246_(booleanValue, server);
                    GameruleClientboundPacket.setPvpModesOnly(booleanValue);
                    break;
                }
                case SET_BEACON_WIN_MINUTES: {
                    ((GameRules.IntegerValue)gameRules.m_46170_(GameRuleRegistrar.BEACON_WIN_MINUTES)).m_151489_(Math.toIntExact(this.value), server);
                    GameruleClientboundPacket.setBeaconWinMinutes(this.value);
                    break;
                }
                case SET_SLANTED_BUILDING: {
                    ((GameRules.BooleanValue)gameRules.m_46170_(GameRuleRegistrar.SLANTED_BUILDING)).m_46246_(booleanValue, server);
                    GameruleClientboundPacket.setSlantedBuilding(booleanValue);
                    break;
                }
                case SET_ALLOW_HEROES: {
                    ((GameRules.BooleanValue)gameRules.m_46170_(GameRuleRegistrar.ALLOW_HEROES)).m_46246_(booleanValue, server);
                    GameruleClientboundPacket.setAllowHeroes(booleanValue);
                }
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

