/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.guiscreen;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.registrars.PacketHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class TopdownGuiServerboundPacket {
    public boolean topdownGuiOpen = false;
    public int playerId = -1;

    public static void openTopdownGui(int playerId) {
        PacketHandler.INSTANCE.sendToServer((Object)new TopdownGuiServerboundPacket(true, playerId));
    }

    public static void closeTopdownGui(int playerId) {
        Minecraft.m_91087_().popGuiLayer();
        PacketHandler.INSTANCE.sendToServer((Object)new TopdownGuiServerboundPacket(false, playerId));
    }

    public TopdownGuiServerboundPacket(Boolean pos, int playerId) {
        this.topdownGuiOpen = pos;
        this.playerId = playerId;
    }

    public TopdownGuiServerboundPacket(FriendlyByteBuf buffer) {
        this.topdownGuiOpen = buffer.readBoolean();
        this.playerId = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.topdownGuiOpen);
        buffer.writeInt(this.playerId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                ReignOfNether.LOGGER.warn("TopdownGuiServerboundPacket: Sender was null");
                success.set(false);
                return;
            }
            if (player.m_19879_() != this.playerId) {
                ReignOfNether.LOGGER.warn("TopdownGuiServerboundPacket: Tried to process packet from " + String.valueOf(player.m_7755_()) + " for id: " + this.playerId);
                success.set(false);
                return;
            }
            if (this.topdownGuiOpen) {
                PlayerServerEvents.openTopdownGui(this.playerId);
            } else {
                PlayerServerEvents.closeTopdownGui(this.playerId);
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

