/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud;

import com.solegendary.reignofnether.team.Team;
import com.solegendary.reignofnether.team.TeamClientEvents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class DonateSuppliesScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("minecraft", "textures/gui/options_background.png");
    private static final int BACKGROUND_WIDTH = 400;
    private static final int BACKGROUND_HEIGHT = 280;
    private static final int BUTTON_WIDTH = 80;
    private static final int BUTTON_HEIGHT = 20;
    private static final int PADDING = 15;
    private Button foodButton;
    private Button woodButton;
    private Button oreButton;
    private Button goldButton;
    private EditBox amountInput;
    private EditBox playerInput;
    private Button donateButton;
    private Button backButton;
    private final String initialTargetName;
    private String selectedResource = "food";
    private String selectedPlayer = null;
    private Team currentTeam;
    private List<String> teamMembers = new ArrayList<String>();

    public DonateSuppliesScreen() {
        super((Component)Component.m_237115_((String)"gui.reignofnether.donate_supplies"));
        this.initialTargetName = null;
    }

    public DonateSuppliesScreen(String preselectedPlayerName) {
        super((Component)Component.m_237115_((String)"gui.reignofnether.donate_supplies"));
        this.initialTargetName = preselectedPlayerName;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.updateTeamData();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int guiLeft = centerX - 200;
        int guiTop = centerY - 140;
        this.foodButton = Button.m_253074_((Component)Component.m_237113_((String)"Food"), button -> {
            this.selectedResource = "food";
            this.updateResourceButtons();
        }).m_252987_(guiLeft + 15, guiTop + 50, 80, 20).m_253136_();
        this.woodButton = Button.m_253074_((Component)Component.m_237113_((String)"Wood"), button -> {
            this.selectedResource = "wood";
            this.updateResourceButtons();
        }).m_252987_(guiLeft + 15 + 80 + 10, guiTop + 50, 80, 20).m_253136_();
        this.oreButton = Button.m_253074_((Component)Component.m_237113_((String)"Ore"), button -> {
            this.selectedResource = "ore";
            this.updateResourceButtons();
        }).m_252987_(guiLeft + 15 + 180, guiTop + 50, 80, 20).m_253136_();
        this.goldButton = Button.m_253074_((Component)Component.m_237113_((String)"Gold"), button -> {
            this.selectedResource = "gold";
            this.updateResourceButtons();
        }).m_252987_(guiLeft + 15 + 270, guiTop + 50, 80, 20).m_253136_();
        this.amountInput = new EditBox(this.f_96547_, guiLeft + 15, guiTop + 100, 150, 20, (Component)Component.m_237115_((String)"gui.reignofnether.amount"));
        this.donateButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.reignofnether.donate"), button -> {
            String amount = this.amountInput.m_94155_().trim();
            if (!amount.isEmpty() && this.selectedPlayer != null) {
                try {
                    int amountInt = Integer.parseInt(amount);
                    if (amountInt > 0) {
                        String cmd = switch (this.selectedResource) {
                            case "food" -> "sendfood";
                            case "wood" -> "sendwood";
                            case "ore" -> "sendore";
                            default -> null;
                        };
                        if (cmd != null) {
                            String command = cmd + " " + this.selectedPlayer + " " + amountInt;
                            Minecraft.m_91087_().f_91074_.f_108617_.m_246623_(command);
                        }
                        this.amountInput.m_94144_("");
                        this.selectedPlayer = null;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }).m_252987_(guiLeft + 15 + 160, guiTop + 100, 80, 20).m_253136_();
        this.backButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.reignofnether.back"), button -> Minecraft.m_91087_().m_91152_(null)).m_252987_(guiLeft + 400 - 80 - 15, guiTop + 280 - 20 - 15, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.foodButton);
        this.m_142416_((GuiEventListener)this.woodButton);
        this.m_142416_((GuiEventListener)this.oreButton);
        this.m_142416_((GuiEventListener)this.amountInput);
        this.m_142416_((GuiEventListener)this.donateButton);
        this.m_142416_((GuiEventListener)this.backButton);
        this.updateResourceButtons();
        this.donateButton.f_93623_ = false;
        if (this.initialTargetName != null) {
            if (this.teamMembers.contains(this.initialTargetName)) {
                this.selectedPlayer = this.initialTargetName;
                this.updateResourceButtons();
            } else {
                this.selectedPlayer = this.initialTargetName;
                this.updateResourceButtons();
            }
        }
    }

    private void updateTeamData() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            String playerName = mc.f_91074_.m_7755_().getString();
            this.currentTeam = TeamClientEvents.getPlayerTeam(playerName);
            if (this.currentTeam != null) {
                ArrayList<String> members = new ArrayList<String>(this.currentTeam.getMembers());
                members.remove(playerName);
                ArrayList<String> online = new ArrayList<String>();
                if (mc.f_91073_ != null) {
                    for (Player p : mc.f_91073_.m_6907_()) {
                        online.add(p.m_7755_().getString());
                    }
                }
                this.teamMembers.clear();
                for (String m : members) {
                    if (!online.contains(m)) continue;
                    this.teamMembers.add(m);
                }
            } else {
                this.teamMembers.clear();
            }
        }
    }

    private void updateResourceButtons() {
        this.foodButton.m_93666_((Component)Component.m_237113_((String)(this.selectedResource.equals("food") ? "\u00a7aFood" : "Food")));
        this.woodButton.m_93666_((Component)Component.m_237113_((String)(this.selectedResource.equals("wood") ? "\u00a7aWood" : "Wood")));
        this.oreButton.m_93666_((Component)Component.m_237113_((String)(this.selectedResource.equals("ore") ? "\u00a7aOre" : "Ore")));
        this.donateButton.f_93623_ = this.selectedPlayer != null;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int guiLeft = centerX - 200;
        int guiTop = centerY - 140;
        guiGraphics.m_280163_(BACKGROUND_TEXTURE, guiLeft, guiTop, 0.0f, 0.0f, 400, 280, 32, 32);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, centerX, guiTop + 10, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, "\u00a7eSelect Resource:", guiLeft + 15, guiTop + 35, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, "\u00a7eEnter Amount:", guiLeft + 15, guiTop + 85, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, "\u00a7eSelect Team Member:", guiLeft + 15, guiTop + 125, 0xFFFFFF);
        if (!this.teamMembers.isEmpty()) {
            guiGraphics.m_280488_(this.f_96547_, "\u00a76Team Members:", guiLeft + 400 - 180, guiTop + 35, 0xFFFFFF);
            for (int i = 0; i < Math.min(this.teamMembers.size(), 10); ++i) {
                String member = this.teamMembers.get(i);
                boolean isSelected = member.equals(this.selectedPlayer);
                String displayText = (isSelected ? "\u00a7a\u25ba " : "\u00a77\u2022 ") + member;
                int color = isSelected ? 0xFFFFFF : 0xCCCCCC;
                guiGraphics.m_280488_(this.f_96547_, displayText, guiLeft + 400 - 170, guiTop + 50 + i * 12, color);
            }
        }
        if (this.selectedPlayer != null) {
            guiGraphics.m_280488_(this.f_96547_, "\u00a7aSelected: \u00a7f" + this.selectedPlayer, guiLeft + 15, guiTop + 145, 0xFFFFFF);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int centerX = this.f_96543_ / 2;
            int centerY = this.f_96544_ / 2;
            int guiLeft = centerX - 200;
            int guiTop = centerY - 140;
            for (int i = 0; i < Math.min(this.teamMembers.size(), 10); ++i) {
                int memberY = guiTop + 50 + i * 12;
                if (!(mouseX >= (double)(guiLeft + 400 - 170)) || !(mouseX <= (double)(guiLeft + 400 - 20)) || !(mouseY >= (double)memberY) || !(mouseY <= (double)(memberY + 10))) continue;
                this.selectedPlayer = this.teamMembers.get(i);
                this.updateResourceButtons();
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

