/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.solegendary.reignofnether.team.Team;
import com.solegendary.reignofnether.team.TeamClientEvents;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;

public class TeamHud {
    private static final int HEAD_SIZE = 16;
    private static final int HEAD_SPACING = 4;
    private static final int BACKGROUND_PADDING = 8;
    private static final int BACKGROUND_ALPHA = Integer.MIN_VALUE;

    public static void render(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.m_91268_() == null) {
            return;
        }
        String playerName = mc.f_91074_.m_7755_().getString();
        Team playerTeam = TeamClientEvents.getPlayerTeam(playerName);
        if (playerTeam == null) {
            Set<String> invites = TeamClientEvents.getPendingInvites();
            if (!invites.isEmpty()) {
                TeamHud.renderTeamInvites(guiGraphics, invites);
            }
            return;
        }
        TeamHud.renderTeamInfo(guiGraphics, playerTeam);
    }

    private static void renderTeamInfo(GuiGraphics guiGraphics, Team team) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        int screenWidth = mc.m_91268_().m_85445_();
        int totalWidth = TeamHud.calculateTeamWidth(team);
        int x = (screenWidth - totalWidth) / 2;
        int y = 10;
        guiGraphics.m_280509_(x - 8, y - 8, x + totalWidth + 8, y + 16 + 8 + 12, Integer.MIN_VALUE);
        String teamName = "\u00a76" + team.getName();
        int teamNameWidth = font.m_92895_(teamName);
        guiGraphics.m_280488_(font, teamName, x + (totalWidth - teamNameWidth) / 2, y, 0xFFFFFF);
        int headX = x;
        y += 12;
        int mouseX = -1;
        int mouseY = -1;
        try {
            Window window = mc.m_91268_();
            mouseX = (int)Math.floor(mc.f_91067_.m_91589_() * (double)window.m_85445_() / (double)window.m_85443_());
            mouseY = (int)Math.floor(mc.f_91067_.m_91594_() * (double)window.m_85446_() / (double)window.m_85444_());
        }
        catch (Throwable window) {
            // empty catch block
        }
        String hoveredName = null;
        for (String member : team.getMembers()) {
            TeamHud.renderPlayerHead(guiGraphics, member, headX, y, team.getLeader().equals(member));
            if (mouseX >= headX && mouseX <= headX + 16 && mouseY >= y && mouseY <= y + 16) {
                hoveredName = member;
            }
            headX += 20;
        }
        if (hoveredName != null) {
            TeamHud.drawTooltip(guiGraphics, hoveredName, mouseX, mouseY);
        }
    }

    private static int calculateTeamWidth(Team team) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        String teamName = "\u00a76" + team.getName();
        int teamNameWidth = font.m_92895_(teamName);
        int headsWidth = team.getSize() * 16 + (team.getSize() - 1) * 4;
        return Math.max(teamNameWidth, headsWidth);
    }

    private static void renderPlayerHead(GuiGraphics guiGraphics, String playerName, int x, int y, boolean isLeader) {
        Font font;
        Minecraft mc = Minecraft.m_91087_();
        ResourceLocation skinTexture = TeamHud.getPlayerSkinTexture(playerName);
        boolean playerDefeatedOrLeft = TeamClientEvents.isPlayerDefeatedOrLeft(playerName);
        if (playerDefeatedOrLeft && mc.f_91073_ != null) {
            for (AbstractClientPlayer p : mc.f_91073_.m_6907_()) {
                if (!p.m_7755_().getString().equals(playerName)) continue;
                TeamClientEvents.markPlayerOnline(playerName);
                playerDefeatedOrLeft = false;
                break;
            }
        }
        int bgColor = isLeader ? -1862281472 : -1879048192;
        guiGraphics.m_280509_(x - 1, y - 1, x + 16 + 1, y + 16 + 1, bgColor);
        if (skinTexture != null) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)skinTexture);
            if (playerDefeatedOrLeft) {
                RenderSystem.setShaderColor((float)1.0f, (float)0.3f, (float)0.3f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            guiGraphics.m_280411_(skinTexture, x, y, 16, 16, 8.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            int fallbackColor = playerDefeatedOrLeft ? -8388608 : -8355712;
            guiGraphics.m_280509_(x, y, x + 16, y + 16, fallbackColor);
        }
        if (playerDefeatedOrLeft) {
            font = mc.f_91062_;
            guiGraphics.m_280488_(font, "\u00a7c\u2717", x + 2, y - 1, 0xFFFFFF);
        }
        if (isLeader) {
            font = mc.f_91062_;
            guiGraphics.m_280488_(font, "\u00a7e\u2605", x + 16 - 6, y - 1, 0xFFFFFF);
        }
    }

    private static ResourceLocation getPlayerSkinTexture(String playerName) {
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.m_91109_() == null) {
                return null;
            }
            GameProfile profile = new GameProfile(UUID.nameUUIDFromBytes(playerName.getBytes()), playerName);
            Map skinInfo = mc.m_91109_().m_118815_(profile);
            if (skinInfo.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                return mc.m_91109_().m_118825_((MinecraftProfileTexture)skinInfo.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
            }
            return DefaultPlayerSkin.m_118627_((UUID)profile.getId());
        }
        catch (Exception e) {
            return new ResourceLocation("minecraft", "textures/entity/steve.png");
        }
    }

    private static void drawTooltip(GuiGraphics guiGraphics, String text, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        int padding = 4;
        int width = font.m_92895_(text) + padding * 2;
        int height = 10 + padding * 2;
        int x = mouseX + 8;
        int y = mouseY + 8;
        guiGraphics.m_280509_(x, y, x + width, y + height, -1073741824);
        guiGraphics.m_280488_(font, text, x + padding, y + padding, 0xFFFFFF);
    }

    private static void renderTeamInvites(GuiGraphics guiGraphics, Set<String> invites) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        int screenWidth = mc.m_91268_().m_85445_();
        String inviteText = "\u00a7aTeam Invites:";
        int textWidth = font.m_92895_(inviteText);
        int x = (screenWidth - textWidth) / 2;
        int y = 10;
        guiGraphics.m_280509_(x - 8, y - 8, x + textWidth + 8, y + 12 + 8, Integer.MIN_VALUE);
        guiGraphics.m_280488_(font, inviteText, x, y, 0xFFFFFF);
        y += 12;
        for (String teamName : invites) {
            String displayText = "\u00a76" + teamName;
            int teamTextWidth = font.m_92895_(displayText);
            int teamX = (screenWidth - teamTextWidth) / 2;
            guiGraphics.m_280488_(font, displayText, teamX, y, 0xFFFFFF);
            y += 10;
        }
    }
}

