/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.solegendary.reignofnether.hud.DonateSuppliesScreen;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientEvents;
import com.solegendary.reignofnether.team.Team;
import com.solegendary.reignofnether.team.TeamClientEvents;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class TeamManagementScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("minecraft", "textures/gui/options_background.png");
    private static final int BACKGROUND_WIDTH = 320;
    private static final int BACKGROUND_HEIGHT = 240;
    private static final int BUTTON_WIDTH = 140;
    private static final int BUTTON_HEIGHT = 20;
    private static final int PADDING = 10;
    private Button createTeamButton;
    private Button leaveTeamButton;
    private Button invitePlayerButton;
    private Button donateSuppliesButton;
    private Button viewMembersButton;
    private Button closeButton;
    private EditBox teamNameInput;
    private EditBox invitePlayerInput;
    private Team currentTeam;
    private List<String> teamMembers = new ArrayList<String>();
    private List<String> pendingInvites = new ArrayList<String>();
    private boolean showCreateTeam = false;
    private boolean showInvitePlayer = false;
    private boolean showMembers = false;
    private String selectedPlayerForInvite = null;
    private int membersScroll = 0;
    private String selectedMemberForDetails = null;

    public TeamManagementScreen() {
        super((Component)Component.m_237115_((String)"gui.reignofnether.team_management"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.updateTeamData();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int guiLeft = centerX - 160;
        int guiTop = centerY - 120;
        this.createTeamButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.reignofnether.create_team"), button -> {
            this.showCreateTeam = !this.showCreateTeam;
            this.showInvitePlayer = false;
            this.showMembers = false;
            this.updateButtons();
        }).m_252987_(guiLeft + 10, guiTop + 40, 140, 20).m_253136_();
        this.leaveTeamButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.reignofnether.leave_team"), button -> {
            if (this.currentTeam != null) {
                Minecraft.m_91087_().f_91074_.f_108617_.m_246623_("team leave");
                this.updateTeamData();
            }
        }).m_252987_(guiLeft + 320 - 140 - 10, guiTop + 40, 140, 20).m_253136_();
        this.invitePlayerButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.reignofnether.invite_player"), button -> {
            this.showInvitePlayer = !this.showInvitePlayer;
            this.showCreateTeam = false;
            this.showMembers = false;
            this.updateButtons();
        }).m_252987_(guiLeft + 10, guiTop + 70, 140, 20).m_253136_();
        this.donateSuppliesButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.reignofnether.donate_supplies"), button -> Minecraft.m_91087_().m_91152_((Screen)new DonateSuppliesScreen())).m_252987_(guiLeft + 320 - 140 - 10, guiTop + 70, 140, 20).m_253136_();
        this.viewMembersButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.reignofnether.view_members"), button -> {
            this.showMembers = !this.showMembers;
            this.showCreateTeam = false;
            this.showInvitePlayer = false;
            this.updateButtons();
        }).m_252987_(guiLeft + 10, guiTop + 100, 140, 20).m_253136_();
        this.closeButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), button -> Minecraft.m_91087_().m_91152_(null)).m_252987_(guiLeft + 320 - 140 - 10, guiTop + 240 - 20 - 10, 140, 20).m_253136_();
        this.teamNameInput = new EditBox(this.f_96547_, guiLeft + 10, guiTop + 130, 140, 20, (Component)Component.m_237115_((String)"gui.reignofnether.team_name"));
        this.invitePlayerInput = new EditBox(this.f_96547_, guiLeft + 10, guiTop + 160, 140, 20, (Component)Component.m_237115_((String)"gui.reignofnether.player_name"));
        this.m_142416_((GuiEventListener)this.createTeamButton);
        this.m_142416_((GuiEventListener)this.leaveTeamButton);
        this.m_142416_((GuiEventListener)this.invitePlayerButton);
        this.m_142416_((GuiEventListener)this.donateSuppliesButton);
        this.m_142416_((GuiEventListener)this.viewMembersButton);
        this.m_142416_((GuiEventListener)this.closeButton);
        this.m_142416_((GuiEventListener)this.teamNameInput);
        this.m_142416_((GuiEventListener)this.invitePlayerInput);
        this.teamNameInput.m_94194_(false);
        this.invitePlayerInput.m_94194_(false);
        this.teamNameInput.m_94199_(32);
        this.invitePlayerInput.m_94199_(32);
        this.updateButtons();
    }

    private void updateTeamData() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            String playerName = mc.f_91074_.m_7755_().getString();
            this.currentTeam = TeamClientEvents.getPlayerTeam(playerName);
            this.pendingInvites = new ArrayList<String>(TeamClientEvents.getPendingInvites());
            if (this.currentTeam != null) {
                this.teamMembers = new ArrayList<String>(this.currentTeam.getMembers());
            } else {
                this.teamMembers.clear();
            }
        }
    }

    private void updateButtons() {
        this.createTeamButton.m_93666_((Component)(this.showCreateTeam ? Component.m_237115_((String)"gui.reignofnether.cancel") : Component.m_237115_((String)"gui.reignofnether.create_team")));
        boolean bl = this.createTeamButton.f_93623_ = this.currentTeam == null;
        if (this.currentTeam != null) {
            this.showCreateTeam = false;
        }
        this.leaveTeamButton.f_93623_ = this.currentTeam != null;
        this.invitePlayerButton.m_93666_((Component)(this.showInvitePlayer ? Component.m_237115_((String)"gui.reignofnether.cancel") : Component.m_237115_((String)"gui.reignofnether.invite_player")));
        this.invitePlayerButton.f_93623_ = this.currentTeam != null && this.currentTeam.getLeader().equals(Minecraft.m_91087_().f_91074_.m_7755_().getString());
        this.donateSuppliesButton.f_93623_ = this.currentTeam != null;
        this.viewMembersButton.m_93666_((Component)(this.showMembers ? Component.m_237115_((String)"gui.reignofnether.cancel") : Component.m_237115_((String)"gui.reignofnether.view_members")));
        this.viewMembersButton.f_93623_ = this.currentTeam != null;
        this.teamNameInput.m_94194_(this.showCreateTeam);
        this.invitePlayerInput.m_94194_(this.showInvitePlayer);
        if (this.showCreateTeam) {
            this.m_7522_((GuiEventListener)this.teamNameInput);
        } else if (this.showInvitePlayer) {
            this.m_7522_((GuiEventListener)this.invitePlayerInput);
        } else {
            this.m_7522_(null);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int guiLeft = centerX - 160;
        int guiTop = centerY - 120;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280163_(BACKGROUND_TEXTURE, guiLeft, guiTop, 0.0f, 0.0f, 320, 240, 32, 32);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, centerX, guiTop + 10, 0xFFFFFF);
        String teamStatus = this.currentTeam != null ? String.format("\u00a76Team: \u00a7f%s", this.currentTeam.getName()) : "\u00a77No Team";
        guiGraphics.m_280488_(this.f_96547_, teamStatus, guiLeft + 10, guiTop + 25, 0xFFFFFF);
        if (!this.pendingInvites.isEmpty()) {
            int headerColor = this.currentTeam == null ? 0xFFFFFF : 0xAAAAAA;
            int invitesHeaderY = guiTop + 150;
            guiGraphics.m_280488_(this.f_96547_, this.currentTeam == null ? "\u00a7aPending Invites:" : "\u00a77Invites (while in a team)", guiLeft + 10, invitesHeaderY, headerColor);
            if (this.currentTeam == null) {
                Button acceptAll = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7aAccept All"), b -> {
                    for (String teamId : this.pendingInvites) {
                        Minecraft.m_91087_().f_91074_.f_108617_.m_246623_("team accept " + teamId);
                    }
                }).m_252987_(guiLeft + 10 + 180, invitesHeaderY - 4, 90, 18).m_253136_();
                this.m_142416_((GuiEventListener)acceptAll);
            }
            int baseY = guiTop + 168;
            for (int i = 0; i < Math.min(this.pendingInvites.size(), 3); ++i) {
                String teamId = this.pendingInvites.get(i);
                int y = baseY + i * 22;
                guiGraphics.m_280488_(this.f_96547_, "\u00a77\u2022 \u00a7f" + teamId, guiLeft + 10 + 10, y, 0xFFFFFF);
                Button acceptBtn = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7aAccept"), b -> Minecraft.m_91087_().f_91074_.f_108617_.m_246623_("team accept " + teamId)).m_252987_(guiLeft + 10 + 160, y - 6, 60, 18).m_253136_();
                Button declineBtn = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7cDecline"), b -> Minecraft.m_91087_().f_91074_.f_108617_.m_246623_("team decline " + teamId)).m_252987_(guiLeft + 10 + 225, y - 6, 60, 18).m_253136_();
                acceptBtn.f_93623_ = this.currentTeam == null;
                this.m_142416_((GuiEventListener)acceptBtn);
                this.m_142416_((GuiEventListener)declineBtn);
            }
        }
        if (this.showCreateTeam) {
            this.renderCreateTeamInterface(guiGraphics, guiLeft, guiTop);
        }
        if (this.showInvitePlayer) {
            this.renderInvitePlayerInterface(guiGraphics, guiLeft, guiTop);
        }
        if (this.showMembers) {
            this.renderMembersInterface(guiGraphics, guiLeft, guiTop);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderCreateTeamInterface(GuiGraphics guiGraphics, int guiLeft, int guiTop) {
        guiGraphics.m_280488_(this.f_96547_, "\u00a7eEnter team name:", guiLeft + 10, guiTop + 115, 0xFFFFFF);
        Button createButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.reignofnether.create"), button -> {
            String teamName = this.teamNameInput.m_94155_().trim();
            if (!teamName.isEmpty()) {
                Minecraft.m_91087_().f_91074_.f_108617_.m_246623_("team create " + teamName);
                this.showCreateTeam = false;
                this.teamNameInput.m_94144_("");
                this.updateTeamData();
                this.updateButtons();
            }
        }).m_252987_(guiLeft + 320 - 140 - 10, guiTop + 130, 140, 20).m_253136_();
        this.m_142416_((GuiEventListener)createButton);
    }

    private void renderInvitePlayerInterface(GuiGraphics guiGraphics, int guiLeft, int guiTop) {
        guiGraphics.m_280488_(this.f_96547_, "\u00a7eSelect player to invite:", guiLeft + 10, guiTop + 145, 0xFFFFFF);
        List<String> availablePlayers = this.getAvailablePlayers();
        int playerListY = guiTop + 165;
        for (int i = 0; i < Math.min(availablePlayers.size(), 8); ++i) {
            String player = availablePlayers.get(i);
            boolean isSelected = player.equals(this.selectedPlayerForInvite);
            String displayText = (isSelected ? "\u00a7a\u25ba " : "\u00a77\u2022 ") + player;
            int color = isSelected ? 0xFFFFFF : 0xCCCCCC;
            guiGraphics.m_280488_(this.f_96547_, displayText, guiLeft + 10 + 10, playerListY + i * 12, color);
        }
        Button inviteButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.reignofnether.invite"), button -> {
            if (this.selectedPlayerForInvite != null) {
                Minecraft.m_91087_().f_91074_.f_108617_.m_246623_("team invite " + this.selectedPlayerForInvite);
                this.showInvitePlayer = false;
                this.selectedPlayerForInvite = null;
                this.updateButtons();
            }
        }).m_252987_(guiLeft + 320 - 140 - 10, guiTop + 160, 140, 20).m_253136_();
        inviteButton.f_93623_ = this.selectedPlayerForInvite != null;
        this.m_142416_((GuiEventListener)inviteButton);
    }

    private List<String> getAvailablePlayers() {
        ArrayList<String> players = new ArrayList<String>();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91074_ != null) {
            String currentPlayer = mc.f_91074_.m_7755_().getString();
            for (Player player : mc.f_91073_.m_6907_()) {
                String playerName = player.m_7755_().getString();
                if (playerName.equals(currentPlayer) || this.currentTeam != null && this.currentTeam.getMembers().contains(playerName)) continue;
                players.add(playerName);
            }
        }
        return players;
    }

    private void renderMembersInterface(GuiGraphics guiGraphics, int guiLeft, int guiTop) {
        int idx;
        guiGraphics.m_280488_(this.f_96547_, "\u00a76Team Members:", guiLeft + 10, guiTop + 115, 0xFFFFFF);
        Set<String> online = this.getOnlinePlayerNames();
        int listTop = guiTop + 130;
        int visible = 8;
        for (int i = 0; i < Math.min(visible, Math.max(0, this.teamMembers.size() - this.membersScroll)) && (idx = i + this.membersScroll) < this.teamMembers.size(); ++i) {
            String member = this.teamMembers.get(idx);
            boolean isLeader = this.currentTeam != null && this.currentTeam.getLeader().equals(member);
            int y = listTop + i * 22;
            boolean isSelected = member.equals(this.selectedMemberForDetails);
            this.drawMemberRow(guiGraphics, guiLeft + 10, y, member, isLeader, online.contains(member), isSelected);
        }
    }

    private void drawMemberRow(GuiGraphics g, int x, int y, String name, boolean leader, boolean online, boolean selected) {
        Resources r;
        this.drawPlayerHead(g, x, y, name, 16, 16);
        int color = leader ? 0xFFFF00 : (selected ? 10543359 : 0xFFFFFF);
        g.m_280488_(this.f_96547_, name + (leader ? " (Leader)" : ""), x + 20, y + 4, color);
        if (!online || TeamClientEvents.isPlayerDefeatedOrLeft(name)) {
            g.m_280509_(x, y, x + 16, y + 16, 0x60FF0000);
            g.m_280488_(this.f_96547_, "X", x + 5, y + 3, -1);
        }
        if ((r = ResourcesClientEvents.getResources(name)) != null) {
            String res = r.food + "F  " + r.wood + "W  " + r.ore + "O";
            g.m_280488_(this.f_96547_, res, x + 140, y + 4, 0xCCCCCC);
        }
        if (selected) {
            TeamClientEvents.PlayerTeamStats stats = TeamClientEvents.getStats(name);
            String statsLine = "K:" + stats.kills + " L:" + stats.losses + " Dv:" + stats.couriersDelivered + " In:" + stats.couriersIntercepted;
            g.m_280488_(this.f_96547_, statsLine, x + 140, y + 12, 0x88FFFF);
        }
        int bx = x + 200;
        Button f = Button.m_253074_((Component)Component.m_237113_((String)"F+50"), b -> Minecraft.m_91087_().f_91074_.f_108617_.m_246623_("sendfood " + name + " 50")).m_252987_(bx, y, 34, 18).m_253136_();
        Button w = Button.m_253074_((Component)Component.m_237113_((String)"W+50"), b -> Minecraft.m_91087_().f_91074_.f_108617_.m_246623_("sendwood " + name + " 50")).m_252987_(bx + 36, y, 34, 18).m_253136_();
        Button o = Button.m_253074_((Component)Component.m_237113_((String)"O+50"), b -> Minecraft.m_91087_().f_91074_.f_108617_.m_246623_("sendore " + name + " 50")).m_252987_(bx + 72, y, 34, 18).m_253136_();
        this.m_142416_((GuiEventListener)f);
        this.m_142416_((GuiEventListener)w);
        this.m_142416_((GuiEventListener)o);
    }

    private void drawPlayerHead(GuiGraphics g, int x, int y, String playerName, int w, int h) {
        Minecraft mc = Minecraft.m_91087_();
        ResourceLocation skin = null;
        if (mc.f_91073_ != null) {
            for (AbstractClientPlayer p : mc.f_91073_.m_6907_()) {
                if (!p.m_7755_().getString().equals(playerName) || !(p instanceof AbstractClientPlayer)) continue;
                try {
                    skin = p.m_108560_();
                }
                catch (Throwable throwable) {}
                break;
            }
        }
        if (skin == null) {
            skin = DefaultPlayerSkin.m_118626_();
        }
        g.m_280411_(skin, x, y, w, h, 8.0f, 8.0f, 8, 8, 64, 64);
        g.m_280411_(skin, x, y, w, h, 40.0f, 8.0f, 8, 8, 64, 64);
    }

    private Set<String> getOnlinePlayerNames() {
        HashSet<String> set = new HashSet<String>();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            for (AbstractClientPlayer p : mc.f_91073_.m_6907_()) {
                set.add(p.m_7755_().getString());
            }
        }
        return set;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int guiTop;
        int guiLeft;
        int centerY;
        int centerX;
        if (this.showInvitePlayer && button == 0) {
            centerX = this.f_96543_ / 2;
            centerY = this.f_96544_ / 2;
            guiLeft = centerX - 160;
            guiTop = centerY - 120;
            List<String> availablePlayers = this.getAvailablePlayers();
            int playerListY = guiTop + 165;
            for (int i = 0; i < Math.min(availablePlayers.size(), 8); ++i) {
                int playerY = playerListY + i * 12;
                if (!(mouseX >= (double)(guiLeft + 10 + 10)) || !(mouseX <= (double)(guiLeft + 10 + 200)) || !(mouseY >= (double)playerY) || !(mouseY <= (double)(playerY + 10))) continue;
                this.selectedPlayerForInvite = availablePlayers.get(i);
                return true;
            }
        }
        if (this.showMembers && button == 0) {
            int idx;
            centerX = this.f_96543_ / 2;
            centerY = this.f_96544_ / 2;
            guiLeft = centerX - 160;
            guiTop = centerY - 120;
            int listTop = guiTop + 130;
            for (int i = 0; i < 8 && (idx = i + this.membersScroll) < this.teamMembers.size(); ++i) {
                int y = listTop + i * 22;
                if (!(mouseX >= (double)(guiLeft + 10)) || !(mouseX <= (double)(guiLeft + 10 + 200)) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + 18))) continue;
                this.selectedMemberForDetails = this.teamMembers.get(idx);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.m_7222_() instanceof EditBox) {
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        GuiEventListener guiEventListener = this.m_7222_();
        if (guiEventListener instanceof EditBox) {
            EditBox editBox = (EditBox)guiEventListener;
            return editBox.m_5534_(codePoint, modifiers) || super.m_5534_(codePoint, modifiers);
        }
        return super.m_5534_(codePoint, modifiers);
    }
}

