/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud.buttons;

import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.faction.FactionRegistry;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class DynamicStartButtons {
    private static List<Button> cached = new ArrayList<Button>();
    private static int lastFactionCount = -1;

    public static List<Button> getButtons() {
        List<FactionType> all = FactionRegistry.getAllFactions();
        if (lastFactionCount != all.size()) {
            DynamicStartButtons.rebuild();
        }
        return cached;
    }

    private static boolean isBuiltInPath(String path) {
        return Objects.equals(path, "villagers") || Objects.equals(path, "monsters") || Objects.equals(path, "piglins") || Objects.equals(path, "none");
    }

    private static void rebuild() {
        cached = new ArrayList<Button>();
        List<FactionType> factions = FactionRegistry.getAllFactions();
        lastFactionCount = factions.size();
        for (FactionType ft : factions) {
            String path;
            if (ft == null || DynamicStartButtons.isBuiltInPath(path = ft.getId().m_135815_()) || UnitRegistry.getUnitsForFaction(ft).isEmpty()) continue;
            ResourceLocation icon = ft.getIcon() != null ? ft.getIcon() : new ResourceLocation("reignofnether", "textures/mobheads/villager.png");
            Button b = new Button(ft.getDisplayName(), 14, icon, (Keybinding)null, () -> {
                ResourceLocation sel = CursorClientEvents.getSelectedStartFactionId();
                return sel != null && sel.equals((Object)ft.getId());
            }, () -> false, () -> true, () -> {
                CursorClientEvents.setSelectedStartFactionId(ft.getId());
                CursorClientEvents.setLeftClickAction(UnitAction.STARTRTS_CUSTOM);
            }, null, List.of(FormattedCharSequence.m_13714_((String)ft.getDisplayName(), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)ft.getId().toString(), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.startbuttons.reignofnether.click_to_start", (Object[])new Object[0]), (Style)Style.f_131099_)));
            cached.add(b);
        }
    }
}

