/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.mapmaker;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.solegendary.reignofnether.mapmaker.MapmakerCommand;
import com.solegendary.reignofnether.mapmaker.commands.CreateBuildingCommand;
import com.solegendary.reignofnether.mapmaker.commands.DestroyBuildingCommand;
import com.solegendary.reignofnether.mapmaker.commands.HelpCommand;
import com.solegendary.reignofnether.mapmaker.commands.LoseCommand;
import com.solegendary.reignofnether.mapmaker.commands.SetBuildingOwnerCommand;
import com.solegendary.reignofnether.mapmaker.commands.SetUnitOwnerCommand;
import com.solegendary.reignofnether.mapmaker.commands.TeamAdminCommand;
import com.solegendary.reignofnether.mapmaker.commands.WinCommand;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class MapmakerCommands {
    private static final List<MapmakerCommand> COMMANDS = new ArrayList<MapmakerCommand>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder mapmakerCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"rts-mapmaker").then(Commands.m_82127_((String)"help").executes(context -> {
            MapmakerCommands.showHelp((CommandSourceStack)context.getSource());
            return 1;
        }));
        for (MapmakerCommand command : COMMANDS) {
            command.registerArguments(dispatcher);
        }
        dispatcher.register(mapmakerCommand);
    }

    private static void showHelp(CommandSourceStack source) {
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76=== RTS Mapmaker Commands ==="), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7eThese commands are designed for map creators and scenario builders."), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7eAll commands can be used in Command Blocks."), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        for (MapmakerCommand command : COMMANDS) {
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7b/rts-" + command.getCommandName() + "\u00a7r - " + command.getDescription())), false);
        }
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a77Use individual commands for detailed syntax help."), false);
    }

    public static List<MapmakerCommand> getCommands() {
        return new ArrayList<MapmakerCommand>(COMMANDS);
    }

    public static MapmakerCommand getCommand(String name) {
        return COMMANDS.stream().filter(cmd -> cmd.getCommandName().equals(name)).findFirst().orElse(null);
    }

    static {
        COMMANDS.add(new SetUnitOwnerCommand());
        COMMANDS.add(new WinCommand());
        COMMANDS.add(new LoseCommand());
        COMMANDS.add(new DestroyBuildingCommand());
        COMMANDS.add(new CreateBuildingCommand());
        COMMANDS.add(new SetBuildingOwnerCommand());
        COMMANDS.add(new TeamAdminCommand());
        COMMANDS.add(new HelpCommand());
    }
}

