/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.mapmaker.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.mapmaker.MapmakerCommand;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class CreateBuildingCommand
extends MapmakerCommand {
    @Override
    public String getCommandName() {
        return "createbuilding";
    }

    @Override
    public String getDescription() {
        return "Create a building at specified position";
    }

    @Override
    public void registerArguments(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-createbuilding").then(Commands.m_82129_((String)"buildingType", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"owner", (ArgumentType)StringArgumentType.string()).executes(this::executeWithDefaultRotation)).then(Commands.m_82129_((String)"rotation", (ArgumentType)StringArgumentType.string()).executes(this::executeWithRotation))))));
    }

    @Override
    public int execute(CommandContext<CommandSourceStack> context) {
        return this.executeWithDefaultRotation(context);
    }

    private int executeWithDefaultRotation(CommandContext<CommandSourceStack> context) {
        return this.executeInternal(context, Rotation.NONE);
    }

    private int executeWithRotation(CommandContext<CommandSourceStack> context) {
        String rotationStr = StringArgumentType.getString(context, (String)"rotation");
        Rotation rotation = this.parseRotation(rotationStr);
        if (rotation == null) {
            this.sendError(context, "Invalid rotation: " + rotationStr + ". Use: none, clockwise_90, clockwise_180, counterclockwise_90");
            return 0;
        }
        return this.executeInternal(context, rotation);
    }

    private int executeInternal(CommandContext<CommandSourceStack> context, Rotation rotation) {
        if (!this.hasPermission(context)) {
            this.sendError(context, "You don't have permission to use mapmaker commands.");
            return 0;
        }
        String buildingType = StringArgumentType.getString(context, (String)"buildingType");
        BlockPos position = BlockPosArgument.m_264582_(context, (String)"position");
        String owner = this.getPlayerName(context, "owner");
        ServerLevel level = this.getServerLevel(context);
        if (!this.isValidPlayerName(level, owner)) {
            this.sendError(context, "Player '" + owner + "' not found.");
            return 0;
        }
        Building building = this.findBuildingByType(buildingType);
        if (building == null) {
            this.sendError(context, "Unknown building type: " + buildingType);
            this.showAvailableBuildings(context);
            return 0;
        }
        if (!this.canPlaceBuildingAt(level, position, building)) {
            this.sendError(context, "Cannot place " + building.name + " at position " + String.valueOf(position) + " (area may be occupied)");
            return 0;
        }
        try {
            BuildingPlacement buildingPlacement = building.createBuildingPlacement((Level)level, position, rotation, owner);
            if (buildingPlacement == null) {
                this.sendError(context, "Failed to create building placement for " + building.name);
                return 0;
            }
            buildingPlacement.selfBuilding = true;
            buildingPlacement.setLevel((Level)level);
            BuildingServerEvents.getBuildings().add(buildingPlacement);
            this.sendSuccess(context, "Created " + building.name + " at " + String.valueOf(position) + " (owned by " + owner + ")");
            return 1;
        }
        catch (Exception e) {
            this.sendError(context, "Error creating building: " + e.getMessage());
            return 0;
        }
    }

    private Building findBuildingByType(String buildingType) {
        String searchType = buildingType.toLowerCase().replace("_", "").replace("-", "");
        if (this.matchesBuilding(Buildings.TOWN_CENTRE, searchType)) {
            return Buildings.TOWN_CENTRE;
        }
        if (this.matchesBuilding(Buildings.BARRACKS, searchType)) {
            return Buildings.BARRACKS;
        }
        if (this.matchesBuilding(Buildings.BLACKSMITH, searchType)) {
            return Buildings.BLACKSMITH;
        }
        if (this.matchesBuilding(Buildings.LIBRARY, searchType)) {
            return Buildings.LIBRARY;
        }
        if (this.matchesBuilding(Buildings.WATCHTOWER, searchType)) {
            return Buildings.WATCHTOWER;
        }
        if (this.matchesBuilding(Buildings.CASTLE, searchType)) {
            return Buildings.CASTLE;
        }
        if (this.matchesBuilding(Buildings.WHEAT_FARM, searchType)) {
            return Buildings.WHEAT_FARM;
        }
        if (this.matchesBuilding(Buildings.OAK_STOCKPILE, searchType)) {
            return Buildings.OAK_STOCKPILE;
        }
        if (this.matchesBuilding(Buildings.VILLAGER_HOUSE, searchType)) {
            return Buildings.VILLAGER_HOUSE;
        }
        if (this.matchesBuilding(Buildings.ARCANE_TOWER, searchType)) {
            return Buildings.ARCANE_TOWER;
        }
        if (this.matchesBuilding(Buildings.OAK_BRIDGE, searchType)) {
            return Buildings.OAK_BRIDGE;
        }
        if (this.matchesBuilding(Buildings.CENTRAL_PORTAL, searchType)) {
            return Buildings.CENTRAL_PORTAL;
        }
        if (this.matchesBuilding(Buildings.FORTRESS, searchType)) {
            return Buildings.FORTRESS;
        }
        if (this.matchesBuilding(Buildings.FLAME_SANCTUARY, searchType)) {
            return Buildings.FLAME_SANCTUARY;
        }
        if (this.matchesBuilding(Buildings.BASTION, searchType)) {
            return Buildings.BASTION;
        }
        if (this.matchesBuilding(Buildings.HOGLIN_STABLES, searchType)) {
            return Buildings.HOGLIN_STABLES;
        }
        if (this.matchesBuilding(Buildings.NETHERWART_FARM, searchType)) {
            return Buildings.NETHERWART_FARM;
        }
        if (this.matchesBuilding(Buildings.BASALT_SPRINGS, searchType)) {
            return Buildings.BASALT_SPRINGS;
        }
        if (this.matchesBuilding(Buildings.BLACKSTONE_BRIDGE, searchType)) {
            return Buildings.BLACKSTONE_BRIDGE;
        }
        if (this.matchesBuilding(Buildings.STRONGHOLD, searchType)) {
            return Buildings.STRONGHOLD;
        }
        if (this.matchesBuilding(Buildings.DUNGEON, searchType)) {
            return Buildings.DUNGEON;
        }
        if (this.matchesBuilding(Buildings.GRAVEYARD, searchType)) {
            return Buildings.GRAVEYARD;
        }
        if (this.matchesBuilding(Buildings.LABORATORY, searchType)) {
            return Buildings.LABORATORY;
        }
        if (this.matchesBuilding(Buildings.HAUNTED_HOUSE, searchType)) {
            return Buildings.HAUNTED_HOUSE;
        }
        if (this.matchesBuilding(Buildings.MAUSOLEUM, searchType)) {
            return Buildings.MAUSOLEUM;
        }
        if (this.matchesBuilding(Buildings.PUMPKIN_FARM, searchType)) {
            return Buildings.PUMPKIN_FARM;
        }
        if (this.matchesBuilding(Buildings.SPIDER_LAIR, searchType)) {
            return Buildings.SPIDER_LAIR;
        }
        return null;
    }

    private boolean matchesBuilding(Building building, String searchType) {
        String buildingName = building.name.toLowerCase().replace(" ", "").replace("_", "").replace("-", "");
        return buildingName.equals(searchType) || buildingName.contains(searchType);
    }

    private Rotation parseRotation(String rotationStr) {
        return switch (rotationStr.toLowerCase()) {
            case "none", "0" -> Rotation.NONE;
            case "clockwise_90", "cw_90", "90" -> Rotation.CLOCKWISE_90;
            case "clockwise_180", "cw_180", "180" -> Rotation.CLOCKWISE_180;
            case "counterclockwise_90", "ccw_90", "270" -> Rotation.COUNTERCLOCKWISE_90;
            default -> null;
        };
    }

    private boolean canPlaceBuildingAt(ServerLevel level, BlockPos position, Building building) {
        try {
            BuildingPlacement tempPlacement = building.createBuildingPlacement((Level)level, position, Rotation.NONE, "temp");
            if (tempPlacement == null) {
                return false;
            }
            BlockPos minCorner = tempPlacement.minCorner;
            BlockPos maxCorner = tempPlacement.maxCorner;
            for (int x = minCorner.m_123341_(); x <= maxCorner.m_123341_(); ++x) {
                for (int y = minCorner.m_123342_(); y <= maxCorner.m_123342_(); ++y) {
                    for (int z = minCorner.m_123343_(); z <= maxCorner.m_123343_(); ++z) {
                        BlockPos checkPos = new BlockPos(x, y, z);
                        if (level.m_8055_(checkPos).m_247087_() || this.isReplaceableBlock(level.m_8055_(checkPos).m_60734_())) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isReplaceableBlock(Block block) {
        return block == Blocks.f_50440_ || block == Blocks.f_50493_ || block == Blocks.f_50069_ || block == Blocks.f_50652_ || block == Blocks.f_49992_ || block == Blocks.f_49994_ || block.m_49966_().m_247087_();
    }

    private void showAvailableBuildings(CommandContext<CommandSourceStack> context) {
        this.sendError(context, "Available building types:");
        this.sendError(context, "Villager: towncentre, barracks, blacksmith, library, watchtower, castle, wheatfarm, oakstockpile");
        this.sendError(context, "Piglin: centralportal, fortress, flameSanctuary, bastion, hoglinStables, netherwartfarm, basaltsprings");
        this.sendError(context, "Monster: stronghold, dungeon, graveyard, laboratory, hauntedhouse, mausoleum, pumpkinfarm, spiderllair");
    }
}

