/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.mapmaker.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.mapmaker.MapmakerCommand;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;

public class DestroyBuildingCommand
extends MapmakerCommand {
    @Override
    public String getCommandName() {
        return "destroybuilding";
    }

    @Override
    public String getDescription() {
        return "Destroy buildings by position, owner, or type";
    }

    @Override
    public void registerArguments(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-destroybuilding").then(Commands.m_82127_((String)"bypos").then(Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).executes(this::executeByPosition)))).then(Commands.m_82127_((String)"byowner").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"owner", (ArgumentType)StringArgumentType.string()).executes(this::executeByOwner)).then(Commands.m_82129_((String)"buildingType", (ArgumentType)StringArgumentType.string()).executes(this::executeByOwnerAndType))))).then(Commands.m_82127_((String)"bytype").then(Commands.m_82129_((String)"buildingType", (ArgumentType)StringArgumentType.string()).executes(this::executeByType)))).then(Commands.m_82127_((String)"all").executes(this::executeDestroyAll)));
    }

    @Override
    public int execute(CommandContext<CommandSourceStack> context) {
        return 0;
    }

    private int executeByPosition(CommandContext<CommandSourceStack> context) {
        if (!this.hasPermission(context)) {
            this.sendError(context, "You don't have permission to use mapmaker commands.");
            return 0;
        }
        BlockPos position = BlockPosArgument.m_264582_(context, (String)"position");
        ServerLevel level = this.getServerLevel(context);
        BuildingPlacement building = BuildingUtils.findBuilding(false, position);
        if (building == null) {
            this.sendError(context, "No building found at position " + String.valueOf(position));
            return 0;
        }
        String buildingName = building.getBuilding().name;
        String owner = building.ownerName;
        building.destroy(level);
        BuildingServerEvents.getBuildings().remove(building);
        this.sendSuccess(context, "Destroyed " + buildingName + " (owned by " + owner + ") at " + String.valueOf(position));
        return 1;
    }

    private int executeByOwner(CommandContext<CommandSourceStack> context) {
        return this.executeByOwnerInternal(context, "all");
    }

    private int executeByOwnerAndType(CommandContext<CommandSourceStack> context) {
        String buildingType = StringArgumentType.getString(context, (String)"buildingType");
        return this.executeByOwnerInternal(context, buildingType);
    }

    private int executeByOwnerInternal(CommandContext<CommandSourceStack> context, String buildingType) {
        if (!this.hasPermission(context)) {
            this.sendError(context, "You don't have permission to use mapmaker commands.");
            return 0;
        }
        String owner = this.getPlayerName(context, "owner");
        ServerLevel level = this.getServerLevel(context);
        if (!this.isValidBuildingType(buildingType)) {
            this.sendError(context, "Invalid building type: " + buildingType);
            return 0;
        }
        List<BuildingPlacement> buildingsToDestroy = BuildingServerEvents.getBuildings().stream().filter(building -> owner.equals("all") || building.ownerName.equals(owner)).filter(building -> buildingType.equals("all") || this.matchesBuildingType((BuildingPlacement)building, buildingType)).toList();
        if (buildingsToDestroy.isEmpty()) {
            Object message = "No buildings found";
            if (!owner.equals("all")) {
                message = (String)message + " owned by " + owner;
            }
            if (!buildingType.equals("all")) {
                message = (String)message + " of type " + buildingType;
            }
            this.sendError(context, (String)message);
            return 0;
        }
        int destroyedCount = 0;
        for (BuildingPlacement building2 : buildingsToDestroy) {
            building2.destroy(level);
            BuildingServerEvents.getBuildings().remove(building2);
            ++destroyedCount;
        }
        String message = "Destroyed " + destroyedCount + " buildings";
        if (!owner.equals("all")) {
            message = message + " owned by " + owner;
        }
        if (!buildingType.equals("all")) {
            message = message + " of type " + buildingType;
        }
        this.sendSuccess(context, message);
        return 1;
    }

    private int executeByType(CommandContext<CommandSourceStack> context) {
        if (!this.hasPermission(context)) {
            this.sendError(context, "You don't have permission to use mapmaker commands.");
            return 0;
        }
        String buildingType = StringArgumentType.getString(context, (String)"buildingType");
        ServerLevel level = this.getServerLevel(context);
        if (!this.isValidBuildingType(buildingType)) {
            this.sendError(context, "Invalid building type: " + buildingType);
            return 0;
        }
        List<BuildingPlacement> buildingsToDestroy = BuildingServerEvents.getBuildings().stream().filter(building -> this.matchesBuildingType((BuildingPlacement)building, buildingType)).toList();
        if (buildingsToDestroy.isEmpty()) {
            this.sendError(context, "No buildings found of type " + buildingType);
            return 0;
        }
        int destroyedCount = 0;
        for (BuildingPlacement building2 : buildingsToDestroy) {
            building2.destroy(level);
            BuildingServerEvents.getBuildings().remove(building2);
            ++destroyedCount;
        }
        this.sendSuccess(context, "Destroyed " + destroyedCount + " buildings of type " + buildingType);
        return 1;
    }

    private int executeDestroyAll(CommandContext<CommandSourceStack> context) {
        if (!this.hasPermission(context)) {
            this.sendError(context, "You don't have permission to use mapmaker commands.");
            return 0;
        }
        ServerLevel level = this.getServerLevel(context);
        if (BuildingServerEvents.getBuildings().isEmpty()) {
            this.sendError(context, "No buildings found to destroy");
            return 0;
        }
        int destroyedCount = BuildingServerEvents.getBuildings().size();
        for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
            building.destroy(level);
        }
        BuildingServerEvents.getBuildings().clear();
        this.sendSuccess(context, "Destroyed all " + destroyedCount + " buildings");
        return 1;
    }

    private boolean matchesBuildingType(BuildingPlacement building, String buildingType) {
        String searchType;
        if (buildingType.equals("all")) {
            return true;
        }
        String buildingName = building.getBuilding().name.toLowerCase();
        if (buildingName.contains(searchType = buildingType.toLowerCase())) {
            return true;
        }
        if (searchType.equals("production") && building instanceof ProductionPlacement) {
            return true;
        }
        if (searchType.equals("military") && (buildingName.contains("barracks") || buildingName.contains("fortress") || buildingName.contains("watchtower") || buildingName.contains("tower"))) {
            return true;
        }
        return searchType.equals("economic") && (buildingName.contains("farm") || buildingName.contains("stockpile") || buildingName.contains("mine") || buildingName.contains("centre"));
    }
}

