/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.mapmaker.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.mapmaker.MapmakerCommand;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameType;

public class LoseCommand
extends MapmakerCommand {
    @Override
    public String getCommandName() {
        return "lose";
    }

    @Override
    public String getDescription() {
        return "Trigger lose condition for specified player(s)";
    }

    @Override
    public void registerArguments(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-lose").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).executes(this::executeWithDefaults)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.string()).executes(this::executeWithMessage)).then(Commands.m_82127_((String)"destroyunits").executes(this::executeWithMessageAndDestroy)))).then(Commands.m_82127_((String)"destroyunits").executes(this::executeWithDestroy))));
    }

    @Override
    public int execute(CommandContext<CommandSourceStack> context) {
        return this.executeWithDefaults(context);
    }

    private int executeWithDefaults(CommandContext<CommandSourceStack> context) {
        return this.executeInternal(context, null, false);
    }

    private int executeWithMessage(CommandContext<CommandSourceStack> context) {
        String customMessage = StringArgumentType.getString(context, (String)"message");
        return this.executeInternal(context, customMessage, false);
    }

    private int executeWithDestroy(CommandContext<CommandSourceStack> context) {
        return this.executeInternal(context, null, true);
    }

    private int executeWithMessageAndDestroy(CommandContext<CommandSourceStack> context) {
        String customMessage = StringArgumentType.getString(context, (String)"message");
        return this.executeInternal(context, customMessage, true);
    }

    private int executeInternal(CommandContext<CommandSourceStack> context, String customMessage, boolean destroyUnits) {
        if (!this.hasPermission(context)) {
            this.sendError(context, "You don't have permission to use mapmaker commands.");
            return 0;
        }
        String playerName = this.getPlayerName(context, "player");
        ServerLevel level = this.getServerLevel(context);
        if (playerName.equals("all")) {
            this.triggerLoseForAllPlayers(level, customMessage, destroyUnits);
            this.sendSuccess(context, "Triggered lose condition for all players");
        } else {
            if (!this.isValidPlayerName(level, playerName)) {
                this.sendError(context, "Player '" + playerName + "' not found.");
                return 0;
            }
            this.triggerLoseForPlayer(level, playerName, customMessage, destroyUnits);
            this.sendSuccess(context, "Triggered lose condition for player '" + playerName + "'");
        }
        return 1;
    }

    private void triggerLoseForPlayer(ServerLevel level, String playerName, String customMessage, boolean destroyUnits) {
        ServerPlayer player = level.m_7654_().m_6846_().m_11255_(playerName);
        if (player == null) {
            return;
        }
        player.m_143403_(GameType.SPECTATOR);
        String message = customMessage != null ? customMessage : "\u00a7cDefeat! You have lost the scenario.";
        player.m_213846_((Component)Component.m_237113_((String)""));
        player.m_213846_((Component)Component.m_237113_((String)"\u00a7c============================="));
        player.m_213846_((Component)Component.m_237113_((String)message));
        player.m_213846_((Component)Component.m_237113_((String)"\u00a7c============================="));
        player.m_213846_((Component)Component.m_237113_((String)""));
        String announcement = customMessage != null ? "\u00a7c" + playerName + " has been defeated. " + customMessage : "\u00a7c" + playerName + " has been defeated!";
        for (ServerPlayer allPlayer : level.m_7654_().m_6846_().m_11314_()) {
            if (allPlayer.equals((Object)player)) continue;
            allPlayer.m_213846_((Component)Component.m_237113_((String)announcement));
        }
        if (destroyUnits) {
            this.destroyPlayerAssets(playerName);
        }
    }

    private void triggerLoseForAllPlayers(ServerLevel level, String customMessage, boolean destroyUnits) {
        String message = customMessage != null ? customMessage : "\u00a7cDefeat! All players have lost the scenario.";
        for (ServerPlayer player : level.m_7654_().m_6846_().m_11314_()) {
            player.m_143403_(GameType.SPECTATOR);
            player.m_213846_((Component)Component.m_237113_((String)""));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c============================="));
            player.m_213846_((Component)Component.m_237113_((String)message));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c============================="));
            player.m_213846_((Component)Component.m_237113_((String)""));
        }
        if (destroyUnits) {
            this.destroyAllAssets();
        }
    }

    private void destroyPlayerAssets(String playerName) {
        UnitServerEvents.getAllUnits().stream().filter(entity -> entity instanceof Unit).map(entity -> (Unit)entity).filter(unit -> unit.getOwnerName().equals(playerName)).forEach(unit -> ((LivingEntity)unit).m_6074_());
        BuildingServerEvents.getBuildings().stream().filter(building -> building.ownerName.equals(playerName)).forEach(building -> building.destroy((ServerLevel)building.getLevel()));
        BuildingServerEvents.getBuildings().removeIf(building -> building.ownerName.equals(playerName));
    }

    private void destroyAllAssets() {
        UnitServerEvents.getAllUnits().stream().filter(entity -> entity instanceof Unit).forEach(entity -> entity.m_6074_());
        BuildingServerEvents.getBuildings().forEach(building -> building.destroy((ServerLevel)building.getLevel()));
        BuildingServerEvents.getBuildings().clear();
    }
}

