/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.mapmaker.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.solegendary.reignofnether.mapmaker.MapmakerCommand;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;

public class SetUnitOwnerCommand
extends MapmakerCommand {
    @Override
    public String getCommandName() {
        return "setunitowner";
    }

    @Override
    public String getDescription() {
        return "Set unit ownership by ID, area, or type";
    }

    @Override
    public void registerArguments(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-setunitowner").then(Commands.m_82127_((String)"byid").then(Commands.m_82129_((String)"unitId", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"newOwner", (ArgumentType)StringArgumentType.string()).executes(this::executeById))))).then(Commands.m_82127_((String)"byarea").then(Commands.m_82129_((String)"pos1", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"pos2", (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"newOwner", (ArgumentType)StringArgumentType.string()).executes(this::executeByArea)).then(Commands.m_82129_((String)"unitType", (ArgumentType)StringArgumentType.string()).executes(this::executeByAreaAndType))))))).then(Commands.m_82127_((String)"bytype").then(Commands.m_82129_((String)"unitType", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"newOwner", (ArgumentType)StringArgumentType.string()).executes(this::executeByType)))));
    }

    @Override
    public int execute(CommandContext<CommandSourceStack> context) {
        return 0;
    }

    private int executeById(CommandContext<CommandSourceStack> context) {
        if (!this.hasPermission(context)) {
            this.sendError(context, "You don't have permission to use mapmaker commands.");
            return 0;
        }
        int unitId = IntegerArgumentType.getInteger(context, (String)"unitId");
        String newOwner = this.getPlayerName(context, "newOwner");
        ServerLevel level = this.getServerLevel(context);
        Unit unit = this.findUnitById(unitId);
        if (unit == null) {
            this.sendError(context, "Unit with ID " + unitId + " not found.");
            return 0;
        }
        if (!this.isValidPlayerName(level, newOwner)) {
            this.sendError(context, "Player '" + newOwner + "' not found.");
            return 0;
        }
        String oldOwner = unit.getOwnerName();
        unit.setOwnerName(newOwner);
        this.sendSuccess(context, "Changed unit " + unitId + " owner from '" + oldOwner + "' to '" + newOwner + "'");
        return 1;
    }

    private int executeByArea(CommandContext<CommandSourceStack> context) {
        return this.executeByAreaInternal(context, "all");
    }

    private int executeByAreaAndType(CommandContext<CommandSourceStack> context) {
        String unitType = StringArgumentType.getString(context, (String)"unitType");
        return this.executeByAreaInternal(context, unitType);
    }

    private int executeByAreaInternal(CommandContext<CommandSourceStack> context, String unitType) {
        if (!this.hasPermission(context)) {
            this.sendError(context, "You don't have permission to use mapmaker commands.");
            return 0;
        }
        BlockPos pos1 = BlockPosArgument.m_264582_(context, (String)"pos1");
        BlockPos pos2 = BlockPosArgument.m_264582_(context, (String)"pos2");
        String newOwner = this.getPlayerName(context, "newOwner");
        ServerLevel level = this.getServerLevel(context);
        newOwner = this.sanitizeStringInput(newOwner);
        String sanitizedUnitType = this.sanitizeStringInput(unitType);
        if (!this.areCoordinatesValid(level, pos1) || !this.areCoordinatesValid(level, pos2)) {
            this.sendDetailedError(context, "Invalid coordinates provided.", "Ensure coordinates are within world bounds and build height limits.");
            return 0;
        }
        if (!this.isAreaValid(pos1, pos2)) {
            this.sendDetailedError(context, "Area too large for processing.", "Use smaller areas (max 1000x1000x1000 blocks) to prevent performance issues.");
            return 0;
        }
        if (!this.isValidPlayerName(level, newOwner)) {
            this.sendDetailedError(context, "Player '" + newOwner + "' not found.", "Use an existing player name or 'all' for any owner.");
            return 0;
        }
        if (!this.isValidUnitType(sanitizedUnitType)) {
            this.sendDetailedError(context, "Invalid unit type: " + sanitizedUnitType, "Use 'all', unit categories (villager/piglin/monster), or specific unit names (militia/archer/zombie/etc).");
            return 0;
        }
        AABB area = new AABB((double)Math.min(pos1.m_123341_(), pos2.m_123341_()), (double)Math.min(pos1.m_123342_(), pos2.m_123342_()), (double)Math.min(pos1.m_123343_(), pos2.m_123343_()), (double)(Math.max(pos1.m_123341_(), pos2.m_123341_()) + 1), (double)(Math.max(pos1.m_123342_(), pos2.m_123342_()) + 1), (double)(Math.max(pos1.m_123343_(), pos2.m_123343_()) + 1));
        List<LivingEntity> unitsInArea = UnitServerEvents.getAllUnits().stream().filter(entity -> area.m_82393_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_())).filter(entity -> entity instanceof Unit).filter(entity -> sanitizedUnitType.equals("all") || this.matchesUnitType((Unit)entity, sanitizedUnitType)).toList();
        if (unitsInArea.isEmpty()) {
            String message = "No units found in area from " + String.valueOf(pos1) + " to " + String.valueOf(pos2);
            String suggestion = "Try expanding the search area or checking if units exist in the region.";
            if (!sanitizedUnitType.equals("all")) {
                message = message + " matching type '" + sanitizedUnitType + "'";
                suggestion = "Try using 'all' to see if any units exist in the area, or check the unit type spelling.";
            }
            this.sendDetailedError(context, message, suggestion);
            return 0;
        }
        int changedCount = 0;
        for (LivingEntity entity2 : unitsInArea) {
            Unit unit = (Unit)entity2;
            unit.setOwnerName(newOwner);
            ++changedCount;
        }
        this.sendSuccess(context, "Changed owner of " + changedCount + " units to '" + newOwner + "'");
        return 1;
    }

    private int executeByType(CommandContext<CommandSourceStack> context) {
        if (!this.hasPermission(context)) {
            this.sendError(context, "You don't have permission to use mapmaker commands.");
            return 0;
        }
        String unitType = StringArgumentType.getString(context, (String)"unitType");
        String newOwner = this.getPlayerName(context, "newOwner");
        ServerLevel level = this.getServerLevel(context);
        newOwner = this.sanitizeStringInput(newOwner);
        String sanitizedUnitType = this.sanitizeStringInput(unitType);
        if (!this.isValidPlayerName(level, newOwner)) {
            this.sendError(context, "Player '" + newOwner + "' not found.");
            return 0;
        }
        if (!this.isValidUnitType(sanitizedUnitType)) {
            this.sendError(context, "Invalid unit type: " + sanitizedUnitType);
            return 0;
        }
        List<LivingEntity> matchingUnits = UnitServerEvents.getAllUnits().stream().filter(entity -> entity instanceof Unit).filter(entity -> sanitizedUnitType.equals("all") || this.matchesUnitType((Unit)entity, sanitizedUnitType)).toList();
        if (matchingUnits.isEmpty()) {
            this.sendError(context, "No units found matching type '" + sanitizedUnitType + "'");
            return 0;
        }
        int changedCount = 0;
        for (LivingEntity entity2 : matchingUnits) {
            Unit unit = (Unit)entity2;
            unit.setOwnerName(newOwner);
            ++changedCount;
        }
        this.sendSuccess(context, "Changed owner of " + changedCount + " units (type: " + sanitizedUnitType + ") to '" + newOwner + "'");
        return 1;
    }

    private Unit findUnitById(int unitId) {
        return UnitServerEvents.getAllUnits().stream().filter(entity -> entity instanceof Unit).filter(entity -> entity.m_19879_() == unitId).map(entity -> (Unit)entity).findFirst().orElse(null);
    }

    private boolean matchesUnitType(Unit unit, String unitType) {
        String searchType;
        if (unitType.equals("all")) {
            return true;
        }
        String unitClassName = unit.getClass().getSimpleName().toLowerCase();
        if (unitClassName.contains(searchType = unitType.toLowerCase())) {
            return true;
        }
        if (searchType.equals("villager") && unitClassName.contains("villager")) {
            return true;
        }
        if (searchType.equals("piglin") && unitClassName.contains("piglin")) {
            return true;
        }
        return searchType.equals("monster") && (unitClassName.contains("zombie") || unitClassName.contains("skeleton") || unitClassName.contains("spider") || unitClassName.contains("creeper"));
    }
}

