/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.mapmaker.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.solegendary.reignofnether.mapmaker.MapmakerCommand;
import com.solegendary.reignofnether.team.Team;
import com.solegendary.reignofnether.team.TeamManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerLevel;

public class TeamAdminCommand
extends MapmakerCommand {
    @Override
    public String getCommandName() {
        return "team";
    }

    @Override
    public String getDescription() {
        return "Administer teams: create/add/remove/leader/lock/save/load/reset";
    }

    @Override
    public void registerArguments(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-team").then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"team", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"leader", (ArgumentType)StringArgumentType.string()).executes(this::create))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"team", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).executes(this::add))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"team", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).executes(this::remove))))).then(Commands.m_82127_((String)"leader").then(Commands.m_82129_((String)"team", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).executes(this::leader))))).then(Commands.m_82127_((String)"lock").then(Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(this::lock)))).then(Commands.m_82127_((String)"reset").executes(this::reset))).then(Commands.m_82127_((String)"save").executes(this::save))).then(Commands.m_82127_((String)"load").executes(this::load)));
    }

    @Override
    public int execute(CommandContext<CommandSourceStack> context) {
        return 0;
    }

    private int create(CommandContext<CommandSourceStack> ctx) {
        if (!this.hasPermission(ctx)) {
            this.sendError(ctx, "No permission.");
            return 0;
        }
        String team = StringArgumentType.getString(ctx, (String)"team");
        String leader = StringArgumentType.getString(ctx, (String)"leader");
        Team t = TeamManager.forceCreateTeam(leader, team);
        if (t != null) {
            this.sendSuccess(ctx, "Created team '" + team + "' with leader '" + leader + "'.");
            return 1;
        }
        this.sendError(ctx, "Failed to create team.");
        return 0;
    }

    private int add(CommandContext<CommandSourceStack> ctx) {
        String player;
        if (!this.hasPermission(ctx)) {
            this.sendError(ctx, "No permission.");
            return 0;
        }
        String team = StringArgumentType.getString(ctx, (String)"team");
        boolean ok = TeamManager.forceAddToTeam(team, player = StringArgumentType.getString(ctx, (String)"player"));
        if (ok) {
            this.sendSuccess(ctx, "Added '" + player + "' to team '" + team + "'.");
            return 1;
        }
        this.sendError(ctx, "Failed to add player to team.");
        return 0;
    }

    private int remove(CommandContext<CommandSourceStack> ctx) {
        String player;
        if (!this.hasPermission(ctx)) {
            this.sendError(ctx, "No permission.");
            return 0;
        }
        String team = StringArgumentType.getString(ctx, (String)"team");
        boolean ok = TeamManager.forceRemoveFromTeam(team, player = StringArgumentType.getString(ctx, (String)"player"));
        if (ok) {
            this.sendSuccess(ctx, "Removed '" + player + "' from team '" + team + "'.");
            return 1;
        }
        this.sendError(ctx, "Failed to remove player from team.");
        return 0;
    }

    private int leader(CommandContext<CommandSourceStack> ctx) {
        String player;
        if (!this.hasPermission(ctx)) {
            this.sendError(ctx, "No permission.");
            return 0;
        }
        String team = StringArgumentType.getString(ctx, (String)"team");
        boolean ok = TeamManager.forceSetLeader(team, player = StringArgumentType.getString(ctx, (String)"player"));
        if (ok) {
            this.sendSuccess(ctx, "Leader of '" + team + "' set to '" + player + "'.");
            return 1;
        }
        this.sendError(ctx, "Failed to set leader.");
        return 0;
    }

    private int lock(CommandContext<CommandSourceStack> ctx) {
        if (!this.hasPermission(ctx)) {
            this.sendError(ctx, "No permission.");
            return 0;
        }
        boolean enabled = BoolArgumentType.getBool(ctx, (String)"enabled");
        TeamManager.setLocked(enabled);
        this.sendSuccess(ctx, "Teams lock set to " + enabled);
        return 1;
    }

    private int reset(CommandContext<CommandSourceStack> ctx) {
        if (!this.hasPermission(ctx)) {
            this.sendError(ctx, "No permission.");
            return 0;
        }
        TeamManager.forceClearAll();
        this.sendSuccess(ctx, "Cleared all teams.");
        return 1;
    }

    private int save(CommandContext<CommandSourceStack> ctx) {
        if (!this.hasPermission(ctx)) {
            this.sendError(ctx, "No permission.");
            return 0;
        }
        ServerLevel level = this.getServerLevel(ctx);
        TeamManager.saveToJson(level);
        this.sendSuccess(ctx, "Saved teams.json.");
        return 1;
    }

    private int load(CommandContext<CommandSourceStack> ctx) {
        if (!this.hasPermission(ctx)) {
            this.sendError(ctx, "No permission.");
            return 0;
        }
        ServerLevel level = this.getServerLevel(ctx);
        TeamManager.loadFromJson(level);
        this.sendSuccess(ctx, "Loaded teams.json.");
        return 1;
    }
}

