/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.migration;

import com.solegendary.reignofnether.faction.FactionRegistry;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.util.Faction;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public class FactionMigrationHelper {
    public static FactionType toFactionType(Faction oldFaction) {
        if (oldFaction == null) {
            return null;
        }
        switch (oldFaction) {
            case VILLAGERS: {
                return FactionRegistry.getFaction(new ResourceLocation("reignofnether", "villagers"));
            }
            case MONSTERS: {
                return FactionRegistry.getFaction(new ResourceLocation("reignofnether", "monsters"));
            }
            case PIGLINS: {
                return FactionRegistry.getFaction(new ResourceLocation("reignofnether", "piglins"));
            }
        }
        return null;
    }

    public static Faction toLegacyFaction(FactionType factionType) {
        String factionId;
        if (factionType == null) {
            return Faction.NONE;
        }
        switch (factionId = factionType.getId().m_135815_()) {
            case "villagers": {
                return Faction.VILLAGERS;
            }
            case "monsters": {
                return Faction.MONSTERS;
            }
            case "piglins": {
                return Faction.PIGLINS;
            }
        }
        return Faction.NONE;
    }

    public static FactionType getFactionByName(String name) {
        String lowerName;
        if (name == null || name.isEmpty()) {
            return null;
        }
        switch (lowerName = name.toLowerCase()) {
            case "villagers": 
            case "villager": {
                return FactionMigrationHelper.toFactionType(Faction.VILLAGERS);
            }
            case "monsters": 
            case "monster": 
            case "undead": {
                return FactionMigrationHelper.toFactionType(Faction.MONSTERS);
            }
            case "piglins": 
            case "piglin": 
            case "nether": {
                return FactionMigrationHelper.toFactionType(Faction.PIGLINS);
            }
            case "none": 
            case "neutral": 
            case "": {
                return null;
            }
        }
        return FactionRegistry.getFaction(new ResourceLocation("reignofnether", lowerName));
    }

    public static FactionType getRandomFaction(Random random) {
        Faction[] factions = new Faction[]{Faction.VILLAGERS, Faction.MONSTERS, Faction.PIGLINS};
        Faction randomOldFaction = factions[random.nextInt(factions.length)];
        return FactionMigrationHelper.toFactionType(randomOldFaction);
    }

    public static FactionType getRandomEnemyFaction(FactionType currentFaction, Random random) {
        if (currentFaction == null) {
            return FactionMigrationHelper.getRandomFaction(random);
        }
        Faction oldCurrent = FactionMigrationHelper.toLegacyFaction(currentFaction);
        return FactionMigrationHelper.toFactionType(switch (oldCurrent) {
            case Faction.VILLAGERS -> random.nextBoolean() ? Faction.MONSTERS : Faction.PIGLINS;
            case Faction.MONSTERS -> random.nextBoolean() ? Faction.VILLAGERS : Faction.PIGLINS;
            case Faction.PIGLINS -> random.nextBoolean() ? Faction.VILLAGERS : Faction.MONSTERS;
            default -> FactionMigrationHelper.getRandomFaction(random).equals(currentFaction) ? Faction.VILLAGERS : FactionMigrationHelper.toLegacyFaction(FactionMigrationHelper.getRandomFaction(random));
        });
    }

    public static boolean areEnemies(FactionType faction1, FactionType faction2) {
        if (faction1 == null || faction2 == null) {
            return false;
        }
        return !faction1.equals(faction2);
    }

    public static boolean areAllies(FactionType faction1, FactionType faction2) {
        if (faction1 == null || faction2 == null) {
            return false;
        }
        return faction1.equals(faction2);
    }

    public static String getFactionDisplayName(FactionType factionType) {
        if (factionType == null) {
            return "None";
        }
        return factionType.getDisplayName();
    }

    public static int getFactionPrimaryColor(FactionType factionType) {
        if (factionType == null) {
            return 0xFFFFFF;
        }
        return factionType.getPrimaryColor();
    }

    public static int getFactionSecondaryColor(FactionType factionType) {
        if (factionType == null) {
            return 0xCCCCCC;
        }
        return factionType.getSecondaryColor();
    }

    public static boolean isFaction(FactionType factionType, String factionName) {
        FactionType expectedFaction = FactionMigrationHelper.getFactionByName(factionName);
        return factionType != null && factionType.equals(expectedFaction);
    }

    public static boolean isBuiltInFaction(FactionType factionType) {
        if (factionType == null) {
            return false;
        }
        String path = factionType.getId().m_135815_();
        return "villagers".equals(path) || "monsters".equals(path) || "piglins".equals(path);
    }

    public static List<FactionType> getAllFactions() {
        return FactionRegistry.getAllFactions();
    }

    public static List<FactionType> getBuiltInFactions() {
        return Arrays.asList(FactionMigrationHelper.toFactionType(Faction.VILLAGERS), FactionMigrationHelper.toFactionType(Faction.MONSTERS), FactionMigrationHelper.toFactionType(Faction.PIGLINS)).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }
}

