/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.migration;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.migration.FactionMigrationHelper;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.Faction;
import net.minecraft.world.entity.Entity;

public class LegacyFactionCompatibility {
    private static boolean migrationWarningsEnabled = true;

    public static boolean isVillager(Unit unit) {
        if (unit == null) {
            return false;
        }
        FactionType factionType = unit.getFactionType();
        return FactionMigrationHelper.isFaction(factionType, "villagers");
    }

    public static boolean isMonster(Unit unit) {
        if (unit == null) {
            return false;
        }
        FactionType factionType = unit.getFactionType();
        return FactionMigrationHelper.isFaction(factionType, "monsters");
    }

    public static boolean isPiglin(Unit unit) {
        if (unit == null) {
            return false;
        }
        FactionType factionType = unit.getFactionType();
        return FactionMigrationHelper.isFaction(factionType, "piglins");
    }

    public static boolean isVillager(Building building) {
        if (building == null) {
            return false;
        }
        return building.getFaction() == Faction.VILLAGERS;
    }

    public static boolean isMonster(Building building) {
        if (building == null) {
            return false;
        }
        return building.getFaction() == Faction.MONSTERS;
    }

    public static boolean isPiglin(Building building) {
        if (building == null) {
            return false;
        }
        return building.getFaction() == Faction.PIGLINS;
    }

    public static boolean isPiglinEntity(Entity entity) {
        if (!(entity instanceof Unit)) {
            return false;
        }
        Unit unit = (Unit)entity;
        return LegacyFactionCompatibility.isPiglin(unit);
    }

    public static boolean isMonsterEntity(Entity entity) {
        if (!(entity instanceof Unit)) {
            return false;
        }
        Unit unit = (Unit)entity;
        return LegacyFactionCompatibility.isMonster(unit);
    }

    public static boolean isVillagerEntity(Entity entity) {
        if (!(entity instanceof Unit)) {
            return false;
        }
        Unit unit = (Unit)entity;
        return LegacyFactionCompatibility.isVillager(unit);
    }

    public static boolean areEnemyUnits(Unit unit1, Unit unit2) {
        if (unit1 == null || unit2 == null) {
            return false;
        }
        return FactionMigrationHelper.areEnemies(unit1.getFactionType(), unit2.getFactionType());
    }

    public static boolean areAllyUnits(Unit unit1, Unit unit2) {
        if (unit1 == null || unit2 == null) {
            return false;
        }
        return FactionMigrationHelper.areAllies(unit1.getFactionType(), unit2.getFactionType());
    }

    public static boolean hasFireImmunityFaction(Unit unit) {
        return LegacyFactionCompatibility.isPiglin(unit);
    }

    public static boolean hasNightHealingFaction(Unit unit) {
        return LegacyFactionCompatibility.isMonster(unit);
    }

    public static boolean hasNetherHealingFaction(Unit unit) {
        return LegacyFactionCompatibility.isPiglin(unit);
    }

    public static void setMigrationWarningsEnabled(boolean enabled) {
        migrationWarningsEnabled = enabled;
    }

    private static void logMigrationWarning(String oldPattern, String newPattern) {
        if (migrationWarningsEnabled) {
            ReignOfNether.LOGGER.warn("MIGRATION: Replace '{}' with '{}'", (Object)oldPattern, (Object)newPattern);
        }
    }
}

