/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.orthoview;

import com.solegendary.reignofnether.orthoview.OrthoviewErrorHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.Vec3;

public class CameraBounds {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static double minX = Double.NEGATIVE_INFINITY;
    private static double maxX = Double.POSITIVE_INFINITY;
    private static double minZ = Double.NEGATIVE_INFINITY;
    private static double maxZ = Double.POSITIVE_INFINITY;
    private static double minY = -64.0;
    private static double maxY = 1024.0;
    private static boolean useWorldBorder = true;
    private static boolean useCustomBounds = false;
    private static boolean useSoftBoundaries = true;
    private static double softBoundaryMargin = 50.0;
    private static final double BOUNDARY_SLOWDOWN_FACTOR = 0.3;
    private static final double BOUNDARY_STOP_DISTANCE = 5.0;
    private static BoundaryMode currentMode = BoundaryMode.WORLD_BORDER;

    public static void setBoundaryMode(BoundaryMode mode) {
        currentMode = mode;
        useWorldBorder = mode == BoundaryMode.WORLD_BORDER || mode == BoundaryMode.BOTH;
        useCustomBounds = mode == BoundaryMode.CUSTOM || mode == BoundaryMode.BOTH;
    }

    public static void setCustomBounds(double minX, double maxX, double minZ, double maxZ, double minY, double maxY) {
        CameraBounds.minX = minX;
        CameraBounds.maxX = maxX;
        CameraBounds.minZ = minZ;
        CameraBounds.maxZ = maxZ;
        CameraBounds.minY = minY;
        CameraBounds.maxY = maxY;
    }

    public static void setXZBounds(double minX, double maxX, double minZ, double maxZ) {
        CameraBounds.minX = minX;
        CameraBounds.maxX = maxX;
        CameraBounds.minZ = minZ;
        CameraBounds.maxZ = maxZ;
    }

    public static void setSoftBoundaries(boolean enabled, double margin) {
        useSoftBoundaries = enabled;
        softBoundaryMargin = margin;
    }

    public static boolean isPositionValid(Vec3 position) {
        return OrthoviewErrorHandler.safeExecute(() -> {
            BlockPos blockPos;
            WorldBorder border;
            if (currentMode == BoundaryMode.NONE) {
                return true;
            }
            if (useWorldBorder && CameraBounds.MC.f_91073_ != null && !(border = CameraBounds.MC.f_91073_.m_6857_()).m_61937_(blockPos = new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_))) {
                return false;
            }
            if (useCustomBounds && (position.f_82479_ < minX || position.f_82479_ > maxX || position.f_82481_ < minZ || position.f_82481_ > maxZ || position.f_82480_ < minY || position.f_82480_ > maxY)) {
                return false;
            }
            return true;
        }, true, OrthoviewErrorHandler.ErrorType.COORDINATE_CALCULATION_ERROR, "position validation");
    }

    public static Vec3 clampPosition(Vec3 position) {
        return OrthoviewErrorHandler.safeExecute(() -> {
            if (currentMode == BoundaryMode.NONE) {
                return position;
            }
            double clampedX = position.f_82479_;
            double clampedY = position.f_82480_;
            double clampedZ = position.f_82481_;
            if (useWorldBorder && CameraBounds.MC.f_91073_ != null) {
                WorldBorder border = CameraBounds.MC.f_91073_.m_6857_();
                double borderSize = border.m_61959_() / 2.0;
                double centerX = border.m_6347_();
                double centerZ = border.m_6345_();
                clampedX = Math.max(centerX - borderSize + 1.0, Math.min(centerX + borderSize - 1.0, clampedX));
                clampedZ = Math.max(centerZ - borderSize + 1.0, Math.min(centerZ + borderSize - 1.0, clampedZ));
            }
            if (useCustomBounds) {
                clampedX = Math.max(minX, Math.min(maxX, clampedX));
                clampedY = Math.max(minY, Math.min(maxY, clampedY));
                clampedZ = Math.max(minZ, Math.min(maxZ, clampedZ));
            }
            return new Vec3(clampedX, clampedY, clampedZ);
        }, position, OrthoviewErrorHandler.ErrorType.COORDINATE_CALCULATION_ERROR, "position clamping");
    }

    public static double getMovementMultiplier(Vec3 position, Vec3 movement) {
        return OrthoviewErrorHandler.safeExecute(() -> {
            if (currentMode == BoundaryMode.NONE || !useSoftBoundaries) {
                return 1.0;
            }
            double minMultiplier = 1.0;
            if (useCustomBounds) {
                minMultiplier = Math.min(minMultiplier, CameraBounds.calculateBoundaryMultiplier(position.f_82479_, movement.f_82479_, minX, maxX));
                minMultiplier = Math.min(minMultiplier, CameraBounds.calculateBoundaryMultiplier(position.f_82481_, movement.f_82481_, minZ, maxZ));
                minMultiplier = Math.min(minMultiplier, CameraBounds.calculateBoundaryMultiplier(position.f_82480_, movement.f_82480_, minY, maxY));
            }
            if (useWorldBorder && CameraBounds.MC.f_91073_ != null) {
                WorldBorder border = CameraBounds.MC.f_91073_.m_6857_();
                double borderSize = border.m_61959_() / 2.0;
                double centerX = border.m_6347_();
                double centerZ = border.m_6345_();
                minMultiplier = Math.min(minMultiplier, CameraBounds.calculateBoundaryMultiplier(position.f_82479_, movement.f_82479_, centerX - borderSize, centerX + borderSize));
                minMultiplier = Math.min(minMultiplier, CameraBounds.calculateBoundaryMultiplier(position.f_82481_, movement.f_82481_, centerZ - borderSize, centerZ + borderSize));
            }
            return minMultiplier;
        }, 1.0, OrthoviewErrorHandler.ErrorType.COORDINATE_CALCULATION_ERROR, "movement multiplier calculation");
    }

    private static double calculateBoundaryMultiplier(double position, double movement, double minBound, double maxBound) {
        if (movement == 0.0) {
            return 1.0;
        }
        double distanceToMin = position - minBound;
        double distanceToMax = maxBound - position;
        if (movement < 0.0 && distanceToMin < softBoundaryMargin) {
            double factor = Math.max(0.0, distanceToMin - 5.0) / (softBoundaryMargin - 5.0);
            return Math.max(0.3, factor);
        }
        if (movement > 0.0 && distanceToMax < softBoundaryMargin) {
            double factor = Math.max(0.0, distanceToMax - 5.0) / (softBoundaryMargin - 5.0);
            return Math.max(0.3, factor);
        }
        return 1.0;
    }

    public static Vec3 applyCameraBounds(Vec3 currentPosition, Vec3 movement) {
        return OrthoviewErrorHandler.safeExecute(() -> {
            if (currentMode == BoundaryMode.NONE) {
                return movement;
            }
            Vec3 targetPosition = currentPosition.m_82549_(movement);
            double multiplier = CameraBounds.getMovementMultiplier(currentPosition, movement);
            Vec3 adjustedMovement = movement.m_82490_(multiplier);
            Vec3 adjustedTarget = currentPosition.m_82549_(adjustedMovement);
            Vec3 clampedTarget = CameraBounds.clampPosition(adjustedTarget);
            return clampedTarget.m_82546_(currentPosition);
        }, movement, OrthoviewErrorHandler.ErrorType.CAMERA_MOVEMENT_FAILED, "camera bounds application");
    }

    public static BoundingBox getEffectiveBounds() {
        return OrthoviewErrorHandler.safeExecute(() -> {
            double effectiveMinX = minX;
            double effectiveMaxX = maxX;
            double effectiveMinZ = minZ;
            double effectiveMaxZ = maxZ;
            double effectiveMinY = minY;
            double effectiveMaxY = maxY;
            if (useWorldBorder && CameraBounds.MC.f_91073_ != null) {
                WorldBorder border = CameraBounds.MC.f_91073_.m_6857_();
                double borderSize = border.m_61959_() / 2.0;
                double centerX = border.m_6347_();
                double centerZ = border.m_6345_();
                effectiveMinX = Math.max(effectiveMinX, centerX - borderSize);
                effectiveMaxX = Math.min(effectiveMaxX, centerX + borderSize);
                effectiveMinZ = Math.max(effectiveMinZ, centerZ - borderSize);
                effectiveMaxZ = Math.min(effectiveMaxZ, centerZ + borderSize);
            }
            return new BoundingBox(effectiveMinX, effectiveMaxX, effectiveMinZ, effectiveMaxZ, effectiveMinY, effectiveMaxY);
        }, new BoundingBox(minX, maxX, minZ, maxZ, minY, maxY), OrthoviewErrorHandler.ErrorType.COORDINATE_CALCULATION_ERROR, "effective bounds calculation");
    }

    public static void resetBounds() {
        minX = Double.NEGATIVE_INFINITY;
        maxX = Double.POSITIVE_INFINITY;
        minZ = Double.NEGATIVE_INFINITY;
        maxZ = Double.POSITIVE_INFINITY;
        minY = -64.0;
        maxY = 1024.0;
        CameraBounds.setBoundaryMode(BoundaryMode.WORLD_BORDER);
        CameraBounds.setSoftBoundaries(true, 50.0);
    }

    public static String getBoundaryStatus() {
        BoundingBox bounds = CameraBounds.getEffectiveBounds();
        return String.format("Camera Bounds - Mode: %s, Soft: %s, Bounds: %s", new Object[]{currentMode, useSoftBoundaries, bounds});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isInDangerZone(Vec3 position) {
        if (CameraBounds.getMovementMultiplier(position, new Vec3(1.0, 0.0, 0.0)) < 1.0) return true;
        if (CameraBounds.getMovementMultiplier(position, new Vec3(-1.0, 0.0, 0.0)) < 1.0) return true;
        if (CameraBounds.getMovementMultiplier(position, new Vec3(0.0, 0.0, 1.0)) < 1.0) return true;
        Vec3 vec3 = new Vec3(0.0, 0.0, -1.0);
        if (!(CameraBounds.getMovementMultiplier(position, vec3) < 1.0)) return false;
        return true;
    }

    public static enum BoundaryMode {
        NONE,
        WORLD_BORDER,
        CUSTOM,
        BOTH;

    }

    public static class BoundingBox {
        public final double minX;
        public final double maxX;
        public final double minZ;
        public final double maxZ;
        public final double minY;
        public final double maxY;

        public BoundingBox(double minX, double maxX, double minZ, double maxZ, double minY, double maxY) {
            this.minX = minX;
            this.maxX = maxX;
            this.minZ = minZ;
            this.maxZ = maxZ;
            this.minY = minY;
            this.maxY = maxY;
        }

        public boolean contains(Vec3 position) {
            return position.f_82479_ >= this.minX && position.f_82479_ <= this.maxX && position.f_82481_ >= this.minZ && position.f_82481_ <= this.maxZ && position.f_82480_ >= this.minY && position.f_82480_ <= this.maxY;
        }

        public String toString() {
            return String.format("BoundingBox[X: %.1f to %.1f, Z: %.1f to %.1f, Y: %.1f to %.1f]", this.minX, this.maxX, this.minZ, this.maxZ, this.minY, this.maxY);
        }
    }
}

