/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.orthoview;

import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.orthoview.OrthoviewErrorHandler;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CameraCollision {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final double CAMERA_RADIUS = 2.0;
    private static final double MIN_WALL_DISTANCE = 3.0;
    private static final double COLLISION_STEP_SIZE = 0.5;
    private static final ConcurrentHashMap<BlockPos, CollisionData> collisionCache = new ConcurrentHashMap();
    private static final int CACHE_EXPIRY_TIME = 100;
    private static boolean smoothCollisionEnabled = true;
    private static boolean buildingCollisionEnabled = true;
    private static boolean terrainCollisionEnabled = true;
    private static double collisionPushbackStrength = 0.7;

    public static Vec3 checkCameraCollision(Vec3 currentPosition, Vec3 intendedMovement) {
        return OrthoviewErrorHandler.safeExecute(() -> {
            if (!CameraCollision.isCollisionEnabled() || CameraCollision.MC.f_91073_ == null) {
                return intendedMovement;
            }
            Vec3 targetPosition = currentPosition.m_82549_(intendedMovement);
            CollisionResult collision = CameraCollision.detectCollision(currentPosition, targetPosition);
            if (!collision.hasCollision) {
                return intendedMovement;
            }
            return CameraCollision.calculateCollisionResponse(currentPosition, intendedMovement, collision);
        }, intendedMovement, OrthoviewErrorHandler.ErrorType.CAMERA_MOVEMENT_FAILED, "camera collision detection");
    }

    private static CollisionResult detectCollision(Vec3 from, Vec3 to) {
        Vec3 direction = to.m_82546_(from);
        double distance = direction.m_82553_();
        if (distance < 0.1) {
            return CollisionResult.NO_COLLISION;
        }
        Vec3 normalizedDirection = direction.m_82541_();
        int steps = (int)Math.ceil(distance / 0.5);
        for (int i = 0; i <= steps; ++i) {
            double t = (double)i / (double)steps;
            Vec3 samplePoint = from.m_82549_(direction.m_82490_(t));
            CollisionData collision = CameraCollision.checkCollisionAtPoint(samplePoint);
            if (!collision.hasCollision) continue;
            Vec3 safePosition = from.m_82549_(direction.m_82490_(Math.max(0.0, t - 0.1)));
            return new CollisionResult(true, collision.type, safePosition, collision.normalVector, samplePoint);
        }
        return CollisionResult.NO_COLLISION;
    }

    private static CollisionData checkCollisionAtPoint(Vec3 point) {
        BlockPos blockPos = new BlockPos((int)point.f_82479_, (int)point.f_82480_, (int)point.f_82481_);
        CollisionData cached = collisionCache.get(blockPos);
        if (cached != null && !cached.isExpired()) {
            return cached;
        }
        CollisionData newData = CameraCollision.calculateCollisionAtPoint(point);
        collisionCache.put(blockPos, newData);
        if (collisionCache.size() > 500) {
            CameraCollision.cleanupCollisionCache();
        }
        return newData;
    }

    private static CollisionData calculateCollisionAtPoint(Vec3 point) {
        ClientLevel level = CameraCollision.MC.f_91073_;
        if (level == null) {
            return new CollisionData(false, point, Vec3.f_82478_, CollisionType.NONE);
        }
        if (terrainCollisionEnabled) {
            CollisionData terrainCollision = CameraCollision.checkTerrainCollision(point, (Level)level);
            if (terrainCollision.hasCollision) {
                return terrainCollision;
            }
        }
        if (buildingCollisionEnabled) {
            CollisionData buildingCollision = CameraCollision.checkBuildingCollision(point);
            if (buildingCollision.hasCollision) {
                return buildingCollision;
            }
        }
        return new CollisionData(false, point, Vec3.f_82478_, CollisionType.NONE);
    }

    private static CollisionData checkTerrainCollision(Vec3 point, Level level) {
        int checkRadius = (int)Math.ceil(2.0);
        for (int dx = -checkRadius; dx <= checkRadius; ++dx) {
            for (int dy = -checkRadius; dy <= checkRadius; ++dy) {
                for (int dz = -checkRadius; dz <= checkRadius; ++dz) {
                    BlockState state;
                    BlockPos checkPos = new BlockPos((int)point.f_82479_ + dx, (int)point.f_82480_ + dy, (int)point.f_82481_ + dz);
                    double distance = point.m_82554_(Vec3.m_82512_((Vec3i)checkPos));
                    if (distance > 2.0 || !CameraCollision.isSolidForCamera(state = level.m_8055_(checkPos), level, checkPos)) continue;
                    CollisionType type = CameraCollision.getBlockCollisionType(state);
                    Vec3 normal = CameraCollision.calculateSurfaceNormal(point, checkPos);
                    Vec3 safePos = CameraCollision.calculateSafePosition(point, checkPos, normal);
                    return new CollisionData(true, safePos, normal, type);
                }
            }
        }
        return new CollisionData(false, point, Vec3.f_82478_, CollisionType.NONE);
    }

    private static CollisionData checkBuildingCollision(Vec3 point) {
        for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
            AABB buildingBounds;
            AABB expandedBounds;
            if (building == null || !(expandedBounds = (buildingBounds = new AABB((double)building.minCorner.m_123341_(), (double)building.minCorner.m_123342_(), (double)building.minCorner.m_123343_(), (double)(building.maxCorner.m_123341_() + 1), (double)(building.maxCorner.m_123342_() + 1), (double)(building.maxCorner.m_123343_() + 1))).m_82400_(3.0)).m_82390_(point)) continue;
            Vec3 normal = CameraCollision.calculateBuildingNormal(point, buildingBounds);
            Vec3 safePos = CameraCollision.calculateSafePositionFromAABB(point, expandedBounds, normal);
            return new CollisionData(true, safePos, normal, CollisionType.BUILDING);
        }
        return new CollisionData(false, point, Vec3.f_82478_, CollisionType.NONE);
    }

    private static boolean isSolidForCamera(BlockState state, Level level, BlockPos pos) {
        if (state.m_60795_()) {
            return false;
        }
        VoxelShape shape = state.m_60812_((BlockGetter)level, pos);
        if (shape.m_83281_()) {
            return false;
        }
        return state.m_280555_() || state.m_60804_((BlockGetter)level, pos);
    }

    private static CollisionType getBlockCollisionType(BlockState state) {
        String blockName = state.m_60734_().m_7705_().toLowerCase();
        if (blockName.contains("water")) {
            return CollisionType.WATER;
        }
        if (blockName.contains("lava")) {
            return CollisionType.LAVA;
        }
        if (blockName.contains("structure") || blockName.contains("brick") || blockName.contains("stone")) {
            return CollisionType.STRUCTURE;
        }
        return CollisionType.TERRAIN;
    }

    private static Vec3 calculateSurfaceNormal(Vec3 cameraPos, BlockPos blockPos) {
        Vec3 blockCenter = Vec3.m_82512_((Vec3i)blockPos);
        Vec3 diff = cameraPos.m_82546_(blockCenter);
        double absX = Math.abs(diff.f_82479_);
        double absY = Math.abs(diff.f_82480_);
        double absZ = Math.abs(diff.f_82481_);
        if (absX >= absY && absX >= absZ) {
            return new Vec3(Math.signum(diff.f_82479_), 0.0, 0.0);
        }
        if (absY >= absZ) {
            return new Vec3(0.0, Math.signum(diff.f_82480_), 0.0);
        }
        return new Vec3(0.0, 0.0, Math.signum(diff.f_82481_));
    }

    private static Vec3 calculateBuildingNormal(Vec3 cameraPos, AABB buildingBounds) {
        Vec3 center = buildingBounds.m_82399_();
        Vec3 diff = cameraPos.m_82546_(center);
        double dx = Math.max(0.0, Math.max(buildingBounds.f_82288_ - cameraPos.f_82479_, cameraPos.f_82479_ - buildingBounds.f_82291_));
        double dy = Math.max(0.0, Math.max(buildingBounds.f_82289_ - cameraPos.f_82480_, cameraPos.f_82480_ - buildingBounds.f_82292_));
        double dz = Math.max(0.0, Math.max(buildingBounds.f_82290_ - cameraPos.f_82481_, cameraPos.f_82481_ - buildingBounds.f_82293_));
        if (dx >= dy && dx >= dz) {
            return new Vec3(Math.signum(diff.f_82479_), 0.0, 0.0);
        }
        if (dy >= dz) {
            return new Vec3(0.0, Math.signum(diff.f_82480_), 0.0);
        }
        return new Vec3(0.0, 0.0, Math.signum(diff.f_82481_));
    }

    private static Vec3 calculateSafePosition(Vec3 currentPos, BlockPos collisionBlock, Vec3 normal) {
        Vec3 blockCenter = Vec3.m_82512_((Vec3i)collisionBlock);
        double safeDistance = 5.0;
        return blockCenter.m_82549_(normal.m_82490_(safeDistance));
    }

    private static Vec3 calculateSafePositionFromAABB(Vec3 currentPos, AABB bounds, Vec3 normal) {
        Vec3 center = bounds.m_82399_();
        Vec3 extent = new Vec3((bounds.f_82291_ - bounds.f_82288_) / 2.0, (bounds.f_82292_ - bounds.f_82289_) / 2.0, (bounds.f_82293_ - bounds.f_82290_) / 2.0);
        return center.m_82549_(normal.m_82559_(extent.m_82520_(3.0, 3.0, 3.0)));
    }

    private static Vec3 calculateCollisionResponse(Vec3 currentPos, Vec3 intendedMovement, CollisionResult collision) {
        if (!smoothCollisionEnabled) {
            return Vec3.f_82478_;
        }
        Vec3 normal = collision.normal;
        Vec3 slideDirection = intendedMovement.m_82546_(normal.m_82490_(intendedMovement.m_82526_(normal)));
        Vec3 pushback = normal.m_82490_(collisionPushbackStrength);
        return slideDirection.m_82549_(pushback).m_82490_(0.7);
    }

    private static void cleanupCollisionCache() {
        collisionCache.entrySet().removeIf(entry -> ((CollisionData)entry.getValue()).isExpired());
    }

    public static void clearCache() {
        collisionCache.clear();
    }

    public static boolean isCollisionEnabled() {
        return terrainCollisionEnabled || buildingCollisionEnabled;
    }

    public static void setSmoothCollisionEnabled(boolean enabled) {
        smoothCollisionEnabled = enabled;
    }

    public static void setBuildingCollisionEnabled(boolean enabled) {
        buildingCollisionEnabled = enabled;
    }

    public static void setTerrainCollisionEnabled(boolean enabled) {
        terrainCollisionEnabled = enabled;
    }

    public static void setCollisionPushbackStrength(double strength) {
        collisionPushbackStrength = Math.max(0.0, Math.min(1.0, strength));
    }

    public static String getCollisionStatistics() {
        return String.format("Camera Collision Cache: %d entries, Settings: Smooth=%s, Building=%s, Terrain=%s", collisionCache.size(), smoothCollisionEnabled, buildingCollisionEnabled, terrainCollisionEnabled);
    }

    public static boolean isCameraInCollision(Vec3 cameraPosition) {
        if (!CameraCollision.isCollisionEnabled() || CameraCollision.MC.f_91073_ == null) {
            return false;
        }
        CollisionData collision = CameraCollision.checkCollisionAtPoint(cameraPosition);
        return collision.hasCollision;
    }

    public static Vec3 getSafeCameraPosition(Vec3 cameraPosition) {
        if (!CameraCollision.isCollisionEnabled() || CameraCollision.MC.f_91073_ == null) {
            return cameraPosition;
        }
        CollisionData collision = CameraCollision.checkCollisionAtPoint(cameraPosition);
        return collision.hasCollision ? collision.safePosition : cameraPosition;
    }

    private static class CollisionResult {
        static final CollisionResult NO_COLLISION = new CollisionResult(false, CollisionType.NONE, Vec3.f_82478_, Vec3.f_82478_, Vec3.f_82478_);
        final boolean hasCollision;
        final CollisionType type;
        final Vec3 safePosition;
        final Vec3 normal;
        final Vec3 collisionPoint;

        CollisionResult(boolean collision, CollisionType type, Vec3 safePos, Vec3 normal, Vec3 collisionPoint) {
            this.hasCollision = collision;
            this.type = type;
            this.safePosition = safePos;
            this.normal = normal;
            this.collisionPoint = collisionPoint;
        }
    }

    private static class CollisionData {
        final boolean hasCollision;
        final Vec3 safePosition;
        final Vec3 normalVector;
        final long timestamp;
        final CollisionType type;

        CollisionData(boolean collision, Vec3 safePos, Vec3 normal, CollisionType type) {
            this.hasCollision = collision;
            this.safePosition = safePos;
            this.normalVector = normal;
            this.type = type;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 5000L;
        }
    }

    public static enum CollisionType {
        NONE,
        TERRAIN,
        BUILDING,
        STRUCTURE,
        WATER,
        LAVA;

    }
}

