/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.orthoview;

import com.solegendary.reignofnether.orthoview.OrthoviewErrorHandler;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class CameraShake {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final ConcurrentLinkedQueue<ShakeEffect> activeShakes = new ConcurrentLinkedQueue();
    private static float currentShakeX = 0.0f;
    private static float currentShakeY = 0.0f;
    private static float currentShakeZ = 0.0f;
    private static boolean shakeEnabled = true;
    private static float globalShakeMultiplier = 1.0f;
    private static float maxShakeIntensity = 5.0f;
    private static double maxShakeDistance = 100.0;
    private static long lastUpdateTime = 0L;
    private static final long UPDATE_INTERVAL_MS = 16L;

    public static void addShake(ShakeType type, Vec3 sourcePosition, float intensityMultiplier) {
        if (!shakeEnabled || CameraShake.MC.f_91074_ == null) {
            return;
        }
        OrthoviewErrorHandler.safeExecute(() -> {
            float finalIntensity = type.baseIntensity * intensityMultiplier * globalShakeMultiplier;
            if ((finalIntensity = Math.min(finalIntensity, maxShakeIntensity)) > 0.01f) {
                ShakeEffect effect = new ShakeEffect(type, sourcePosition, finalIntensity, type.baseDuration);
                activeShakes.offer(effect);
                while (activeShakes.size() > 10) {
                    activeShakes.poll();
                }
            }
        }, OrthoviewErrorHandler.ErrorType.RENDERING_ERROR, "camera shake addition");
    }

    public static void addShake(ShakeType type, float intensityMultiplier) {
        if (CameraShake.MC.f_91074_ != null) {
            CameraShake.addShake(type, CameraShake.MC.f_91074_.m_20182_(), intensityMultiplier);
        }
    }

    public static void addShake(ShakeType type, Vec3 sourcePosition) {
        CameraShake.addShake(type, sourcePosition, 1.0f);
    }

    public static void updateShakes() {
        if (!shakeEnabled) {
            currentShakeZ = 0.0f;
            currentShakeY = 0.0f;
            currentShakeX = 0.0f;
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastUpdateTime < 16L) {
            return;
        }
        lastUpdateTime = currentTime;
        OrthoviewErrorHandler.safeExecute(() -> {
            currentShakeZ = 0.0f;
            currentShakeY = 0.0f;
            currentShakeX = 0.0f;
            activeShakes.removeIf(shake -> {
                shake.update();
                if (!shake.isExpired()) {
                    float shakeAmount = shake.currentIntensity;
                    long seed = shake.startTime + (long)shake.ticksRemaining;
                    float randomX = (float)(Math.sin((double)seed * 0.01) * (double)shakeAmount);
                    float randomY = (float)(Math.cos((double)seed * 0.013) * (double)shakeAmount);
                    float randomZ = (float)(Math.sin((double)seed * 0.017) * (double)shakeAmount * 0.5);
                    currentShakeX += randomX;
                    currentShakeY += randomY;
                    currentShakeZ += randomZ;
                    return false;
                }
                return true;
            });
            currentShakeX = Mth.m_14036_((float)currentShakeX, (float)(-maxShakeIntensity), (float)maxShakeIntensity);
            currentShakeY = Mth.m_14036_((float)currentShakeY, (float)(-maxShakeIntensity), (float)maxShakeIntensity);
            currentShakeZ = Mth.m_14036_((float)currentShakeZ, (float)(-maxShakeIntensity), (float)maxShakeIntensity);
        }, OrthoviewErrorHandler.ErrorType.RENDERING_ERROR, "camera shake update");
    }

    public static float getShakeX() {
        return currentShakeX;
    }

    public static float getShakeY() {
        return currentShakeY;
    }

    public static float getShakeZ() {
        return currentShakeZ;
    }

    public static float getTotalShakeIntensity() {
        return (float)Math.sqrt(currentShakeX * currentShakeX + currentShakeY * currentShakeY + currentShakeZ * currentShakeZ);
    }

    public static boolean hasActiveShakes() {
        return !activeShakes.isEmpty() && CameraShake.getTotalShakeIntensity() > 0.01f;
    }

    public static void clearAllShakes() {
        activeShakes.clear();
        currentShakeZ = 0.0f;
        currentShakeY = 0.0f;
        currentShakeX = 0.0f;
    }

    public static void setShakeEnabled(boolean enabled) {
        shakeEnabled = enabled;
        if (!enabled) {
            CameraShake.clearAllShakes();
        }
    }

    public static boolean isShakeEnabled() {
        return shakeEnabled;
    }

    public static void setGlobalShakeMultiplier(float multiplier) {
        globalShakeMultiplier = Math.max(0.0f, Math.min(2.0f, multiplier));
    }

    public static float getGlobalShakeMultiplier() {
        return globalShakeMultiplier;
    }

    public static void setMaxShakeIntensity(float maxIntensity) {
        maxShakeIntensity = Math.max(0.1f, Math.min(10.0f, maxIntensity));
    }

    public static void setMaxShakeDistance(double distance) {
        maxShakeDistance = Math.max(10.0, Math.min(500.0, distance));
    }

    public static String getShakeStatistics() {
        return String.format("Camera Shake: %d active effects, Total intensity: %.2f, Settings: Enabled=%s, Global=%.1fx", activeShakes.size(), Float.valueOf(CameraShake.getTotalShakeIntensity()), shakeEnabled, Float.valueOf(globalShakeMultiplier));
    }

    public static void explosionAt(Vec3 position, float power) {
        CameraShake.addShake(ShakeType.EXPLOSION, position, power);
    }

    public static void combatHit(Vec3 position) {
        CameraShake.addShake(ShakeType.COMBAT_HIT, position, 1.0f);
    }

    public static void buildingDestroyed(Vec3 position) {
        CameraShake.addShake(ShakeType.BUILDING_DESTROYED, position, 1.0f);
    }

    public static void lightningStrike(Vec3 position) {
        CameraShake.addShake(ShakeType.LIGHTNING, position, 1.0f);
    }

    public static void artilleryStrike(Vec3 position, float power) {
        CameraShake.addShake(ShakeType.ARTILLERY, position, power);
    }

    public static void spellCast(Vec3 position, float intensity) {
        CameraShake.addShake(ShakeType.SPELL_CAST, position, intensity);
    }

    public static void earthquake(float intensity) {
        if (CameraShake.MC.f_91074_ != null) {
            CameraShake.addShake(ShakeType.EARTHQUAKE, CameraShake.MC.f_91074_.m_20182_(), intensity);
        }
    }

    public static enum ShakeType {
        EXPLOSION(0.8f, 30, FalloffPattern.EXPONENTIAL),
        COMBAT_HIT(0.3f, 8, FalloffPattern.LINEAR),
        BUILDING_DESTROYED(1.2f, 45, FalloffPattern.EXPONENTIAL),
        EARTHQUAKE(0.5f, 120, FalloffPattern.SINE_WAVE),
        IMPACT(0.4f, 12, FalloffPattern.QUADRATIC),
        LIGHTNING(0.6f, 15, FalloffPattern.SHARP_DECAY),
        ARTILLERY(1.0f, 35, FalloffPattern.EXPONENTIAL),
        SPELL_CAST(0.2f, 10, FalloffPattern.LINEAR);

        final float baseIntensity;
        final int baseDuration;
        final FalloffPattern falloffPattern;

        private ShakeType(float intensity, int duration, FalloffPattern pattern) {
            this.baseIntensity = intensity;
            this.baseDuration = duration;
            this.falloffPattern = pattern;
        }
    }

    private static class ShakeEffect {
        final ShakeType type;
        final Vec3 sourcePosition;
        final float intensity;
        final int maxDuration;
        final FalloffPattern falloffPattern;
        final long startTime;
        int ticksRemaining;
        float currentIntensity;

        ShakeEffect(ShakeType type, Vec3 source, float intensity, int duration) {
            this.type = type;
            this.sourcePosition = source;
            this.intensity = intensity;
            this.maxDuration = duration;
            this.falloffPattern = type.falloffPattern;
            this.startTime = System.currentTimeMillis();
            this.ticksRemaining = duration;
            this.currentIntensity = intensity;
        }

        boolean isExpired() {
            return this.ticksRemaining <= 0;
        }

        void update() {
            --this.ticksRemaining;
            if (this.ticksRemaining <= 0) {
                this.currentIntensity = 0.0f;
                return;
            }
            float progress = 1.0f - (float)this.ticksRemaining / (float)this.maxDuration;
            float falloffMultiplier = this.calculateFalloff(progress, this.falloffPattern);
            float distanceMultiplier = 1.0f;
            if (CameraShake.MC.f_91074_ != null && this.sourcePosition != null) {
                double distance = CameraShake.MC.f_91074_.m_20182_().m_82554_(this.sourcePosition);
                distanceMultiplier = (float)Math.max(0.0, 1.0 - distance / maxShakeDistance);
            }
            this.currentIntensity = this.intensity * falloffMultiplier * distanceMultiplier;
        }

        private float calculateFalloff(float progress, FalloffPattern pattern) {
            switch (pattern) {
                case LINEAR: {
                    return 1.0f - progress;
                }
                case QUADRATIC: {
                    return (float)Math.pow(1.0f - progress, 2.0);
                }
                case EXPONENTIAL: {
                    return (float)Math.exp((double)(-progress) * 4.0);
                }
                case SINE_WAVE: {
                    return (1.0f - progress) * (float)Math.sin((double)progress * Math.PI * 4.0) * 0.3f + (1.0f - progress) * 0.7f;
                }
                case SHARP_DECAY: {
                    return (float)Math.exp((double)(-progress) * 8.0);
                }
                case BOUNCE: {
                    float bounce = (float)Math.abs(Math.sin((double)progress * Math.PI * 6.0)) * (1.0f - progress);
                    return bounce * 0.4f + (1.0f - progress) * 0.6f;
                }
            }
            return 1.0f - progress;
        }
    }

    public static enum FalloffPattern {
        LINEAR,
        QUADRATIC,
        EXPONENTIAL,
        SINE_WAVE,
        SHARP_DECAY,
        BOUNCE;

    }
}

