/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.orthoview;

public class CameraTransitions {
    public static float ease(float t, EasingType type) {
        t = Math.max(0.0f, Math.min(1.0f, t));
        switch (type) {
            case LINEAR: {
                return t;
            }
            case EASE_IN_QUAD: {
                return t * t;
            }
            case EASE_OUT_QUAD: {
                return 1.0f - (1.0f - t) * (1.0f - t);
            }
            case EASE_IN_OUT_QUAD: {
                return t < 0.5f ? 2.0f * t * t : 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 2.0) / 2.0f;
            }
            case EASE_IN_CUBIC: {
                return t * t * t;
            }
            case EASE_OUT_CUBIC: {
                return 1.0f - (float)Math.pow(1.0f - t, 3.0);
            }
            case EASE_IN_OUT_CUBIC: {
                return t < 0.5f ? 4.0f * t * t * t : 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 3.0) / 2.0f;
            }
            case EASE_IN_QUART: {
                return t * t * t * t;
            }
            case EASE_OUT_QUART: {
                return 1.0f - (float)Math.pow(1.0f - t, 4.0);
            }
            case EASE_IN_OUT_QUART: {
                return t < 0.5f ? 8.0f * t * t * t * t : 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 4.0) / 2.0f;
            }
            case EASE_IN_SINE: {
                return 1.0f - (float)Math.cos((double)t * Math.PI / 2.0);
            }
            case EASE_OUT_SINE: {
                return (float)Math.sin((double)t * Math.PI / 2.0);
            }
            case EASE_IN_OUT_SINE: {
                return -((float)Math.cos(Math.PI * (double)t) - 1.0f) / 2.0f;
            }
            case EASE_OUT_BOUNCE: {
                float n1 = 7.5625f;
                float d1 = 2.75f;
                if (t < 0.36363637f) {
                    return 7.5625f * t * t;
                }
                if (t < 0.72727275f) {
                    return 7.5625f * (t -= 0.54545456f) * t + 0.75f;
                }
                if (t < 0.90909094f) {
                    return 7.5625f * (t -= 0.8181818f) * t + 0.9375f;
                }
                return 7.5625f * (t -= 0.95454544f) * t + 0.984375f;
            }
        }
        return t;
    }

    public static float lerp(float start, float end, float t, EasingType type) {
        float easedT = CameraTransitions.ease(t, type);
        return start + (end - start) * easedT;
    }

    public static float[] lerp2D(float startX, float startZ, float endX, float endZ, float t, EasingType type) {
        float easedT = CameraTransitions.ease(t, type);
        return new float[]{startX + (endX - startX) * easedT, startZ + (endZ - startZ) * easedT};
    }

    public static EasingType getRecommendedEasing(CameraMovementType movementType) {
        switch (movementType) {
            case PAN: {
                return EasingType.EASE_OUT_CUBIC;
            }
            case ZOOM: {
                return EasingType.EASE_IN_OUT_QUAD;
            }
            case ROTATION: {
                return EasingType.EASE_IN_OUT_CUBIC;
            }
            case FOCUS_TRANSITION: {
                return EasingType.EASE_IN_OUT_SINE;
            }
            case SNAP_TO_UNIT: {
                return EasingType.EASE_OUT_QUART;
            }
            case COMBAT_FOLLOW: {
                return EasingType.EASE_OUT_SINE;
            }
            case CINEMATIC_PAN: {
                return EasingType.EASE_IN_OUT_SINE;
            }
            case DRAMATIC_ZOOM: {
                return EasingType.EASE_IN_OUT_CUBIC;
            }
            case TUTORIAL_GUIDE: {
                return EasingType.EASE_IN_OUT_SINE;
            }
            case BUILDING_FOCUS: {
                return EasingType.EASE_OUT_CUBIC;
            }
            case MINIMAP_SYNC: {
                return EasingType.EASE_OUT_QUAD;
            }
        }
        return EasingType.EASE_OUT_CUBIC;
    }

    public static float smoothLerp(float start, float end, float t) {
        float smoothT = CameraTransitions.smoothStep(t);
        return start + (end - start) * smoothT;
    }

    public static float smootherLerp(float start, float end, float t) {
        float smootherT = CameraTransitions.smootherStep(t);
        return start + (end - start) * smootherT;
    }

    public static float[] smoothLerp2D(float startX, float startZ, float endX, float endZ, float t) {
        float smoothT = CameraTransitions.smoothStep(t);
        return new float[]{startX + (endX - startX) * smoothT, startZ + (endZ - startZ) * smoothT};
    }

    public static float[] smootherLerp2D(float startX, float startZ, float endX, float endZ, float t) {
        float smootherT = CameraTransitions.smootherStep(t);
        return new float[]{startX + (endX - startX) * smootherT, startZ + (endZ - startZ) * smootherT};
    }

    public static boolean shouldUseEnhancedSmoothing(CameraMovementType movementType) {
        switch (movementType) {
            case CINEMATIC_PAN: 
            case BUILDING_FOCUS: 
            case MINIMAP_SYNC: {
                return true;
            }
            case DRAMATIC_ZOOM: 
            case TUTORIAL_GUIDE: {
                return true;
            }
        }
        return false;
    }

    public static boolean shouldUseSmoothierStep(CameraMovementType movementType) {
        switch (movementType) {
            case DRAMATIC_ZOOM: 
            case TUTORIAL_GUIDE: {
                return true;
            }
        }
        return false;
    }

    public static float smartLerp(float start, float end, float t, CameraMovementType movementType) {
        if (!CameraTransitions.shouldUseEnhancedSmoothing(movementType)) {
            return CameraTransitions.lerp(start, end, t, CameraTransitions.getRecommendedEasing(movementType));
        }
        if (CameraTransitions.shouldUseSmoothierStep(movementType)) {
            return CameraTransitions.smootherLerp(start, end, t);
        }
        return CameraTransitions.smoothLerp(start, end, t);
    }

    public static float[] smartLerp2D(float startX, float startZ, float endX, float endZ, float t, CameraMovementType movementType) {
        if (!CameraTransitions.shouldUseEnhancedSmoothing(movementType)) {
            return CameraTransitions.lerp2D(startX, startZ, endX, endZ, t, CameraTransitions.getRecommendedEasing(movementType));
        }
        if (CameraTransitions.shouldUseSmoothierStep(movementType)) {
            return CameraTransitions.smootherLerp2D(startX, startZ, endX, endZ, t);
        }
        return CameraTransitions.smoothLerp2D(startX, startZ, endX, endZ, t);
    }

    public static float smoothStep(float t) {
        t = Math.max(0.0f, Math.min(1.0f, t));
        return t * t * (3.0f - 2.0f * t);
    }

    public static float smootherStep(float t) {
        t = Math.max(0.0f, Math.min(1.0f, t));
        return t * t * t * (t * (t * 6.0f - 15.0f) + 10.0f);
    }

    public static enum EasingType {
        LINEAR,
        EASE_IN_QUAD,
        EASE_OUT_QUAD,
        EASE_IN_OUT_QUAD,
        EASE_IN_CUBIC,
        EASE_OUT_CUBIC,
        EASE_IN_OUT_CUBIC,
        EASE_IN_QUART,
        EASE_OUT_QUART,
        EASE_IN_OUT_QUART,
        EASE_IN_SINE,
        EASE_OUT_SINE,
        EASE_IN_OUT_SINE,
        EASE_OUT_BOUNCE;

    }

    public static enum CameraMovementType {
        PAN,
        ZOOM,
        ROTATION,
        FOCUS_TRANSITION,
        SNAP_TO_UNIT,
        COMBAT_FOLLOW,
        CINEMATIC_PAN,
        DRAMATIC_ZOOM,
        TUTORIAL_GUIDE,
        BUILDING_FOCUS,
        MINIMAP_SYNC;

    }
}

