/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.orthoview;

import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.orthoview.CameraManager;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.orthoview.OrthoviewErrorHandler;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import java.nio.DoubleBuffer;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.ScreenEvent;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;

public class InputManager {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final float CAMROT_MOUSE_SENSITIVITY = 0.12f;
    private static final float ZOOM_STEP_KEY = 5.0f;
    private static final float ZOOM_STEP_SCROLL = 1.0f;
    private static float mouseRightDownX = 0.0f;
    private static float mouseRightDownY = 0.0f;
    private static float mouseLeftDownX = 0.0f;
    private static float mouseLeftDownY = 0.0f;
    private static boolean cameraMovingByMouse = false;

    public static boolean isCameraMovingByMouse() {
        return cameraMovingByMouse;
    }

    public static void handleMouseScroll(ScreenEvent.MouseScrolled evt) {
        OrthoviewErrorHandler.safeExecute(() -> {
            if (!OrthoviewClientEvents.isEnabled() || CameraManager.isCameraLocked()) {
                return;
            }
            if (Keybindings.altMod.isDown()) {
                float scrollDirection = (float)Math.signum(evt.getScrollDelta());
                CameraManager.zoomCam(scrollDirection * -1.0f);
            }
        }, OrthoviewErrorHandler.ErrorType.INPUT_PROCESSING_ERROR, "mouse scroll handling");
    }

    public static void handleMouseClick(ScreenEvent.MouseButtonPressed.Post evt) {
        if (!OrthoviewClientEvents.isEnabled() || CameraManager.isCameraLocked()) {
            return;
        }
        if (evt.getButton() == 0) {
            mouseLeftDownX = (float)evt.getMouseX();
            mouseLeftDownY = (float)evt.getMouseY();
        } else if (evt.getButton() == 1) {
            mouseRightDownX = (float)evt.getMouseX();
            mouseRightDownY = (float)evt.getMouseY();
        }
    }

    public static void handleMouseRelease(ScreenEvent.MouseButtonReleased evt) {
        if (!OrthoviewClientEvents.isEnabled() || CameraManager.isCameraLocked()) {
            return;
        }
        if (evt.getButton() == 0) {
            cameraMovingByMouse = false;
        }
        if (evt.getButton() == 1) {
            cameraMovingByMouse = false;
            CameraManager.commitRotationAdjustments();
        }
    }

    public static void handleMouseDrag(ScreenEvent.MouseDragged evt) {
        if (!OrthoviewClientEvents.isEnabled() || CameraManager.isCameraLocked()) {
            return;
        }
        if (evt.getMouseButton() == 0 && Keybindings.altMod.isDown() || evt.getMouseButton() == 2) {
            cameraMovingByMouse = true;
            float zoom = CameraManager.getZoom();
            float panSensitivity = CameraManager.getPanSensitivityMult();
            float moveX = (float)evt.getDragX() * 0.2f * (zoom / 90.0f) * panSensitivity;
            float moveZ = (float)evt.getDragY() * 0.2f * (zoom / 90.0f) * panSensitivity;
            CameraManager.panCam(moveX, 0.0f, moveZ);
        } else if (evt.getMouseButton() == 1 && Keybindings.altMod.isDown()) {
            cameraMovingByMouse = true;
            float rotAdjX = (float)(evt.getMouseX() - (double)mouseRightDownX) * 0.12f;
            CameraManager.setCamRotAdj(rotAdjX, 0.0f);
        }
    }

    public static void handleScreenInput() {
        OrthoviewErrorHandler.safeExecute(() -> {
            if (!OrthoviewClientEvents.isEnabled()) {
                return;
            }
            InputManager.handleEdgePanning();
            InputManager.handleKeyboardInput();
            InputManager.handleCursorLocking();
        }, OrthoviewErrorHandler.ErrorType.INPUT_PROCESSING_ERROR, "screen input handling");
    }

    private static void handleEdgePanning() {
        if (CameraManager.isCameraLocked() || Keybindings.altMod.isDown() || !MC.m_91302_()) {
            return;
        }
        long glfwWindow = MC.m_91268_().m_85439_();
        int glfwWinWidth = MC.m_91268_().m_85443_();
        int glfwWinHeight = MC.m_91268_().m_85444_();
        DoubleBuffer glfwCursorX = BufferUtils.createDoubleBuffer((int)1);
        DoubleBuffer glfwCursorY = BufferUtils.createDoubleBuffer((int)1);
        GLFW.glfwGetCursorPos((long)glfwWindow, (DoubleBuffer)glfwCursorX, (DoubleBuffer)glfwCursorY);
        double cursorX = glfwCursorX.get();
        double cursorY = glfwCursorY.get();
        float panSensitivity = CameraManager.getEdgeCamPanSensitivity();
        if (cursorX <= 0.0) {
            CameraManager.panCam(panSensitivity, 0.0f, 0.0f);
            TutorialClientEvents.pannedLeft = true;
        } else if (cursorX >= (double)glfwWinWidth) {
            CameraManager.panCam(-panSensitivity, 0.0f, 0.0f);
            TutorialClientEvents.pannedRight = true;
        }
        if (cursorY <= 0.0) {
            CameraManager.panCam(0.0f, 0.0f, panSensitivity);
            TutorialClientEvents.pannedUp = true;
        } else if (cursorY >= (double)glfwWinHeight) {
            CameraManager.panCam(0.0f, 0.0f, -panSensitivity);
            TutorialClientEvents.pannedDown = true;
        }
    }

    private static void handleKeyboardInput() {
        if (Keybindings.zoomIn.isDown()) {
            CameraManager.zoomCam(-5.0f);
        }
        if (Keybindings.zoomOut.isDown()) {
            CameraManager.zoomCam(5.0f);
        }
        if (!CameraManager.isCameraLocked() && !Keybindings.altMod.isDown()) {
            float panSensitivity = CameraManager.getEdgeCamPanSensitivity();
            if (Keybindings.panPlusX.isDown()) {
                CameraManager.panCam(panSensitivity, 0.0f, 0.0f);
            } else if (Keybindings.panMinusX.isDown()) {
                CameraManager.panCam(-panSensitivity, 0.0f, 0.0f);
            }
            if (Keybindings.panPlusZ.isDown()) {
                CameraManager.panCam(0.0f, 0.0f, panSensitivity);
            } else if (Keybindings.panMinusZ.isDown()) {
                CameraManager.panCam(0.0f, 0.0f, -panSensitivity);
            }
        }
    }

    private static void handleCursorLocking() {
        long glfwWindow = MC.m_91268_().m_85439_();
        int glfwWinWidth = MC.m_91268_().m_85443_();
        int glfwWinHeight = MC.m_91268_().m_85444_();
        DoubleBuffer glfwCursorX = BufferUtils.createDoubleBuffer((int)1);
        DoubleBuffer glfwCursorY = BufferUtils.createDoubleBuffer((int)1);
        GLFW.glfwGetCursorPos((long)glfwWindow, (DoubleBuffer)glfwCursorX, (DoubleBuffer)glfwCursorY);
        double cursorX = glfwCursorX.get();
        double cursorY = glfwCursorY.get();
        if (cursorX >= (double)glfwWinWidth) {
            GLFW.glfwSetCursorPos((long)glfwWindow, (double)glfwWinWidth, (double)cursorY);
        }
        if (cursorY >= (double)glfwWinHeight) {
            GLFW.glfwSetCursorPos((long)glfwWindow, (double)cursorX, (double)glfwWinHeight);
        }
        if (cursorX <= 0.0) {
            GLFW.glfwSetCursorPos((long)glfwWindow, (double)0.0, (double)cursorY);
        }
        if (cursorY <= 0.0) {
            GLFW.glfwSetCursorPos((long)glfwWindow, (double)cursorX, (double)0.0);
        }
    }

    public static void reset() {
        cameraMovingByMouse = false;
        mouseRightDownX = 0.0f;
        mouseRightDownY = 0.0f;
        mouseLeftDownX = 0.0f;
        mouseLeftDownY = 0.0f;
    }
}

